
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to add an image as a watermark.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for WatermarkImageType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="WatermarkImageType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="data" type="{http://schema.webpdf.de/1.0/operation}WatermarkFileDataType"/>
 *         <element name="position" type="{http://schema.webpdf.de/1.0/operation}WatermarkPositionType" minOccurs="0"/>
 *       </all>
 *       <attribute name="scale" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="opacity" type="{http://schema.webpdf.de/1.0/operation}OpacityType" default="25" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "WatermarkImageType", propOrder = {

})
public class WatermarkImageType {

    @XmlElement(required = true)
    protected WatermarkFileDataType data;
    protected WatermarkPositionType position;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the scaling of the image in percent.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "scale")
    protected Integer scale;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the image's opacity. A percent value between 0 and 100 is allowed, whereby 0 equals the minimum opacity. The higher the value, the more the content of the PDF document will be covered over.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "opacity")
    protected Integer opacity;

    /**
     * Gets the value of the data property.
     * 
     * @return
     *     possible object is
     *     {@link WatermarkFileDataType }
     *     
     */
    public WatermarkFileDataType getData() {
        return data;
    }

    /**
     * Sets the value of the data property.
     * 
     * @param value
     *     allowed object is
     *     {@link WatermarkFileDataType }
     *     
     */
    public void setData(WatermarkFileDataType value) {
        this.data = value;
    }

    public boolean isSetData() {
        return (this.data!= null);
    }

    /**
     * Gets the value of the position property.
     * 
     * @return
     *     possible object is
     *     {@link WatermarkPositionType }
     *     
     */
    public WatermarkPositionType getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link WatermarkPositionType }
     *     
     */
    public void setPosition(WatermarkPositionType value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the scaling of the image in percent.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getScale() {
        if (scale == null) {
            return  0;
        } else {
            return scale;
        }
    }

    /**
     * Sets the value of the scale property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getScale()
     */
    public void setScale(int value) {
        this.scale = value;
    }

    public boolean isSetScale() {
        return (this.scale!= null);
    }

    public void unsetScale() {
        this.scale = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p419895_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p810131_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the image's opacity. A percent value between 0 and 100 is allowed, whereby 0 equals the minimum opacity. The higher the value, the more the content of the PDF document will be covered over.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getOpacity() {
        if (opacity == null) {
            return  25;
        } else {
            return opacity;
        }
    }

    /**
     * Sets the value of the opacity property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getOpacity()
     */
    public void setOpacity(int value) {
        this.opacity = value;
    }

    public boolean isSetOpacity() {
        return (this.opacity!= null);
    }

    public void unsetOpacity() {
        this.opacity = null;
    }

}
