
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;For "tif" exports, this parameter is used to define the quality of black-and-white images if "group3" or "group4" is used as a compression method. The higher the quality, the more time that will be required in order to render the image:&#13;
 *                     &lt;ul&gt;&lt;li&gt;low = Direct conversion (best reserved for "text only" content)&lt;/li&gt;&lt;li&gt;middle = A diffusion filter will be applied to the image before conversion&lt;/li&gt;&lt;li&gt;high = Greyscale conversion and a diffusion filter will be applied to the image before conversion&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TiffBlackAndWhiteQualityType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="TiffBlackAndWhiteQualityType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="low"/>
 *     <enumeration value="middle"/>
 *     <enumeration value="high"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "TiffBlackAndWhiteQualityType")
@XmlEnum
public enum TiffBlackAndWhiteQualityType {

    @XmlEnumValue("low")
    LOW("low"),
    @XmlEnumValue("middle")
    MIDDLE("middle"),
    @XmlEnumValue("high")
    HIGH("high");
    private final String value;

    TiffBlackAndWhiteQualityType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static TiffBlackAndWhiteQualityType fromValue(String v) {
        for (TiffBlackAndWhiteQualityType c: TiffBlackAndWhiteQualityType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
