
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This element is used to configure the display of contents for which the syntax highlighter was unable to identify a known language.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TextHighlightType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TextHighlightType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="fontSize" type="{http://www.w3.org/2001/XMLSchema}string" default="10px" />
 *       <attribute name="fontOrigin" type="{http://schema.webpdf.de/1.0/operation}FontOriginModeType" default="system" />
 *       <attribute name="fontFamily" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="wordBreak" type="{http://schema.webpdf.de/1.0/operation}TextWrapModeType" default="auto" />
 *       <attribute name="lineNumbers" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="lineHeight" type="{http://www.w3.org/2001/XMLSchema}string" default="12px" />
 *       <attribute name="color" type="{http://www.w3.org/2001/XMLSchema}string" default="#000000" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TextHighlightType")
public class TextHighlightType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the font size for the text to the specified value.&#13;
     *                         You can use any of the following units:&#13;
     *                         &lt;ul&gt;&lt;li&gt;px = Pixels&lt;/li&gt;&lt;li&gt;cm = Centimeters&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;li&gt;pt = Points&lt;/li&gt;&lt;li&gt;pc = Pica&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fontSize")
    protected String fontSize;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify whether the selected font should be obtained from your operating system or from the "templates/fonts" folder (in your webPDF installation path).&#13;
     *                         Possible values:&#13;
     *                         &lt;ul&gt;&lt;li&gt;system = It will be possible to select from the fonts available system-wide.&lt;/li&gt;&lt;li&gt;folder =It will be possible to select from the fonts in "templates/fonts".&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fontOrigin")
    protected FontOriginModeType fontOrigin;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the font to use for the text. If you select "folder" for the "fontOrigin" parameter, the font here needs to be specified with the filename for the file. Otherwise, use the name of the font you want. If the value is left blank, the "SourceHanSans" font will be used automatically.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fontFamily")
    protected String fontFamily;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to configure the word wrap behaviour during highlighting&#13;
     *                         Possible values:&#13;
     *                         &lt;ul&gt;&lt;li&gt;auto = Automatic word wrap if necessary.&lt;/li&gt;&lt;li&gt;none = Suppress the addition of extra line breaks.&lt;/li&gt;&lt;li&gt;word = Line breaks allowed only after words.&lt;/li&gt;&lt;li&gt;all = Line breaks allowed unconditionally.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "wordBreak")
    protected TextWrapModeType wordBreak;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", line numbers are added before the code.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "lineNumbers")
    protected Boolean lineNumbers;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the line height. You can use any of the following units:&#13;
     *                         &lt;ul&gt;&lt;li&gt;px = Pixels&lt;/li&gt;&lt;li&gt;cm = Centimeters&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;li&gt;pt = Points&lt;/li&gt;&lt;li&gt;pc = Pica&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "lineHeight")
    protected String lineHeight;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the font color for the text to the given value. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "color")
    protected String color;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the font size for the text to the specified value.&#13;
     *                         You can use any of the following units:&#13;
     *                         &lt;ul&gt;&lt;li&gt;px = Pixels&lt;/li&gt;&lt;li&gt;cm = Centimeters&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;li&gt;pt = Points&lt;/li&gt;&lt;li&gt;pc = Pica&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFontSize() {
        if (fontSize == null) {
            return "10px";
        } else {
            return fontSize;
        }
    }

    /**
     * Sets the value of the fontSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFontSize()
     */
    public void setFontSize(String value) {
        this.fontSize = value;
    }

    public boolean isSetFontSize() {
        return (this.fontSize!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify whether the selected font should be obtained from your operating system or from the "templates/fonts" folder (in your webPDF installation path).&#13;
     *                         Possible values:&#13;
     *                         &lt;ul&gt;&lt;li&gt;system = It will be possible to select from the fonts available system-wide.&lt;/li&gt;&lt;li&gt;folder =It will be possible to select from the fonts in "templates/fonts".&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link FontOriginModeType }
     *     
     */
    public FontOriginModeType getFontOrigin() {
        if (fontOrigin == null) {
            return FontOriginModeType.SYSTEM;
        } else {
            return fontOrigin;
        }
    }

    /**
     * Sets the value of the fontOrigin property.
     * 
     * @param value
     *     allowed object is
     *     {@link FontOriginModeType }
     *     
     * @see #getFontOrigin()
     */
    public void setFontOrigin(FontOriginModeType value) {
        this.fontOrigin = value;
    }

    public boolean isSetFontOrigin() {
        return (this.fontOrigin!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the font to use for the text. If you select "folder" for the "fontOrigin" parameter, the font here needs to be specified with the filename for the file. Otherwise, use the name of the font you want. If the value is left blank, the "SourceHanSans" font will be used automatically.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFontFamily() {
        if (fontFamily == null) {
            return "";
        } else {
            return fontFamily;
        }
    }

    /**
     * Sets the value of the fontFamily property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFontFamily()
     */
    public void setFontFamily(String value) {
        this.fontFamily = value;
    }

    public boolean isSetFontFamily() {
        return (this.fontFamily!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to configure the word wrap behaviour during highlighting&#13;
     *                         Possible values:&#13;
     *                         &lt;ul&gt;&lt;li&gt;auto = Automatic word wrap if necessary.&lt;/li&gt;&lt;li&gt;none = Suppress the addition of extra line breaks.&lt;/li&gt;&lt;li&gt;word = Line breaks allowed only after words.&lt;/li&gt;&lt;li&gt;all = Line breaks allowed unconditionally.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TextWrapModeType }
     *     
     */
    public TextWrapModeType getWordBreak() {
        if (wordBreak == null) {
            return TextWrapModeType.AUTO;
        } else {
            return wordBreak;
        }
    }

    /**
     * Sets the value of the wordBreak property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextWrapModeType }
     *     
     * @see #getWordBreak()
     */
    public void setWordBreak(TextWrapModeType value) {
        this.wordBreak = value;
    }

    public boolean isSetWordBreak() {
        return (this.wordBreak!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", line numbers are added before the code.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isLineNumbers() {
        if (lineNumbers == null) {
            return false;
        } else {
            return lineNumbers;
        }
    }

    /**
     * Sets the value of the lineNumbers property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isLineNumbers()
     */
    public void setLineNumbers(boolean value) {
        this.lineNumbers = value;
    }

    public boolean isSetLineNumbers() {
        return (this.lineNumbers!= null);
    }

    public void unsetLineNumbers() {
        this.lineNumbers = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the line height. You can use any of the following units:&#13;
     *                         &lt;ul&gt;&lt;li&gt;px = Pixels&lt;/li&gt;&lt;li&gt;cm = Centimeters&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;li&gt;pt = Points&lt;/li&gt;&lt;li&gt;pc = Pica&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLineHeight() {
        if (lineHeight == null) {
            return "12px";
        } else {
            return lineHeight;
        }
    }

    /**
     * Sets the value of the lineHeight property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getLineHeight()
     */
    public void setLineHeight(String value) {
        this.lineHeight = value;
    }

    public boolean isSetLineHeight() {
        return (this.lineHeight!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the font color for the text to the given value. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getColor() {
        if (color == null) {
            return "#000000";
        } else {
            return color;
        }
    }

    /**
     * Sets the value of the color property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getColor()
     */
    public void setColor(String value) {
        this.color = value;
    }

    public boolean isSetColor() {
        return (this.color!= null);
    }

}
