
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An annotation that adds a note icon to a page.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TextAnnotationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TextAnnotationType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseAnnotationType">
 *       <all>
 *         <element name="position" type="{http://schema.webpdf.de/1.0/operation}RectangleType" minOccurs="0"/>
 *         <element name="normalAppearance" type="{http://schema.webpdf.de/1.0/operation}AppearanceSourceType" minOccurs="0"/>
 *       </all>
 *       <attribute name="icon" type="{http://schema.webpdf.de/1.0/operation}TextAnnotationIconsType" default="note" />
 *       <attribute name="initialOpen" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="appearanceGeneration" type="{http://schema.webpdf.de/1.0/operation}AppearanceGenerationType" default="nonStandard" />
 *       <attribute name="customIconName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TextAnnotationType", propOrder = {
    "position",
    "normalAppearance"
})
public class TextAnnotationType
    extends BaseAnnotationType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the bounds within which the shape shall be positioned.&lt;/p&gt;
     * </pre>
     * 
     */
    protected RectangleType position;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the data source for the visible appearance of a customized text annotation.&#13;
     * &#13;
     *                                 &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                     If this element is present, this shall always take precedence for the appearance generation.&#13;
     *                                 &lt;/p&gt;
     * </pre>
     * 
     */
    protected AppearanceSourceType normalAppearance;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the icon that should be displayed for the note on the page. The following values are available:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;check = The text annotation approves the content.&lt;/li&gt;&lt;li&gt;checkmark = The text annotation adds a gray checkmark to the content.&lt;/li&gt;&lt;li&gt;circle = The text annotation is a comment on the circled content.&lt;/li&gt;&lt;li&gt;comment = The text annotation is a comment to the marked contents.&lt;/li&gt;&lt;li&gt;cross = The text annotation marks the content or crosses it out.&lt;/li&gt;&lt;li&gt;crossHair = The text annotation targets the content in the crosshair.&lt;/li&gt;&lt;li&gt;insert = The text annotation is suggesting inserting some content.&lt;/li&gt;&lt;li&gt;key = The text annotation marks or contains a key content/information.&lt;/li&gt;&lt;li&gt;note = The text annotation is a mere note concerning the marked content.&lt;/li&gt;&lt;li&gt;help = The text annotation provides helpful information concerning the marked content.&lt;/li&gt;&lt;li&gt;newParagraph = The text annotation suggests adding a new Paragraph at a specific point.&lt;/li&gt;&lt;li&gt;paragraph = The text annotation is concerning the whole paragraph.&lt;/li&gt;&lt;li&gt;rightArrow = The text annotation is concerning the content to the right.&lt;/li&gt;&lt;li&gt;rightPointer = The text annotation is concerning the content to the right.&lt;/li&gt;&lt;li&gt;star = The text annotation marks content as especially important.&lt;/li&gt;&lt;li&gt;upArrow = The text annotation is concerning the content at the top.&lt;/li&gt;&lt;li&gt;upLeftArrow = The text annotation is concerning the content at the top left.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "icon")
    protected TextAnnotationIconsType icon;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true," the popup for the corresponding "note" annotation will be opened as soon as the corresponding document page is viewed.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "initialOpen")
    protected Boolean initialOpen;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Determines for which named annotations appearance streams shall be generated.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 Per definition some named annotations are defined as standard names and PDF readers shall provide the means to draw those. For text annotations: comment, insert, key, note, help, newParagraph and paragraph are standard names.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;always = An appearance stream shall be prepared for all created named annotations.&lt;/li&gt;&lt;li&gt;never = Don't provide appearance streams and rely on PDF readers to dynamically generate a proper representation of named annotations.&lt;/li&gt;&lt;li&gt;nonStandard = Only provide appearance streams for non standard annotations.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "appearanceGeneration")
    protected AppearanceGenerationType appearanceGeneration;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets a custom icon name for this annotation.&#13;
     * &#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 This name shall always take precedence over possibly set standard names. (icon)&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "customIconName")
    protected String customIconName;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the bounds within which the shape shall be positioned.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link RectangleType }
     *     
     */
    public RectangleType getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link RectangleType }
     *     
     * @see #getPosition()
     */
    public void setPosition(RectangleType value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the data source for the visible appearance of a customized text annotation.&#13;
     * &#13;
     *                                 &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                     If this element is present, this shall always take precedence for the appearance generation.&#13;
     *                                 &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link AppearanceSourceType }
     *     
     */
    public AppearanceSourceType getNormalAppearance() {
        return normalAppearance;
    }

    /**
     * Sets the value of the normalAppearance property.
     * 
     * @param value
     *     allowed object is
     *     {@link AppearanceSourceType }
     *     
     * @see #getNormalAppearance()
     */
    public void setNormalAppearance(AppearanceSourceType value) {
        this.normalAppearance = value;
    }

    public boolean isSetNormalAppearance() {
        return (this.normalAppearance!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the icon that should be displayed for the note on the page. The following values are available:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;check = The text annotation approves the content.&lt;/li&gt;&lt;li&gt;checkmark = The text annotation adds a gray checkmark to the content.&lt;/li&gt;&lt;li&gt;circle = The text annotation is a comment on the circled content.&lt;/li&gt;&lt;li&gt;comment = The text annotation is a comment to the marked contents.&lt;/li&gt;&lt;li&gt;cross = The text annotation marks the content or crosses it out.&lt;/li&gt;&lt;li&gt;crossHair = The text annotation targets the content in the crosshair.&lt;/li&gt;&lt;li&gt;insert = The text annotation is suggesting inserting some content.&lt;/li&gt;&lt;li&gt;key = The text annotation marks or contains a key content/information.&lt;/li&gt;&lt;li&gt;note = The text annotation is a mere note concerning the marked content.&lt;/li&gt;&lt;li&gt;help = The text annotation provides helpful information concerning the marked content.&lt;/li&gt;&lt;li&gt;newParagraph = The text annotation suggests adding a new Paragraph at a specific point.&lt;/li&gt;&lt;li&gt;paragraph = The text annotation is concerning the whole paragraph.&lt;/li&gt;&lt;li&gt;rightArrow = The text annotation is concerning the content to the right.&lt;/li&gt;&lt;li&gt;rightPointer = The text annotation is concerning the content to the right.&lt;/li&gt;&lt;li&gt;star = The text annotation marks content as especially important.&lt;/li&gt;&lt;li&gt;upArrow = The text annotation is concerning the content at the top.&lt;/li&gt;&lt;li&gt;upLeftArrow = The text annotation is concerning the content at the top left.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TextAnnotationIconsType }
     *     
     */
    public TextAnnotationIconsType getIcon() {
        if (icon == null) {
            return TextAnnotationIconsType.NOTE;
        } else {
            return icon;
        }
    }

    /**
     * Sets the value of the icon property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextAnnotationIconsType }
     *     
     * @see #getIcon()
     */
    public void setIcon(TextAnnotationIconsType value) {
        this.icon = value;
    }

    public boolean isSetIcon() {
        return (this.icon!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true," the popup for the corresponding "note" annotation will be opened as soon as the corresponding document page is viewed.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isInitialOpen() {
        if (initialOpen == null) {
            return true;
        } else {
            return initialOpen;
        }
    }

    /**
     * Sets the value of the initialOpen property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isInitialOpen()
     */
    public void setInitialOpen(boolean value) {
        this.initialOpen = value;
    }

    public boolean isSetInitialOpen() {
        return (this.initialOpen!= null);
    }

    public void unsetInitialOpen() {
        this.initialOpen = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Determines for which named annotations appearance streams shall be generated.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 Per definition some named annotations are defined as standard names and PDF readers shall provide the means to draw those. For text annotations: comment, insert, key, note, help, newParagraph and paragraph are standard names.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;always = An appearance stream shall be prepared for all created named annotations.&lt;/li&gt;&lt;li&gt;never = Don't provide appearance streams and rely on PDF readers to dynamically generate a proper representation of named annotations.&lt;/li&gt;&lt;li&gt;nonStandard = Only provide appearance streams for non standard annotations.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link AppearanceGenerationType }
     *     
     */
    public AppearanceGenerationType getAppearanceGeneration() {
        if (appearanceGeneration == null) {
            return AppearanceGenerationType.NON_STANDARD;
        } else {
            return appearanceGeneration;
        }
    }

    /**
     * Sets the value of the appearanceGeneration property.
     * 
     * @param value
     *     allowed object is
     *     {@link AppearanceGenerationType }
     *     
     * @see #getAppearanceGeneration()
     */
    public void setAppearanceGeneration(AppearanceGenerationType value) {
        this.appearanceGeneration = value;
    }

    public boolean isSetAppearanceGeneration() {
        return (this.appearanceGeneration!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets a custom icon name for this annotation.&#13;
     * &#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 This name shall always take precedence over possibly set standard names. (icon)&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCustomIconName() {
        if (customIconName == null) {
            return "";
        } else {
            return customIconName;
        }
    }

    /**
     * Sets the value of the customIconName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCustomIconName()
     */
    public void setCustomIconName(String value) {
        this.customIconName = value;
    }

    public boolean isSetCustomIconName() {
        return (this.customIconName!= null);
    }

}
