
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
 *                     Selects the SVG syntax used for formatting paths.&#13;
 *                     &lt;ul&gt;&lt;li&gt;verbose = Writes verbose paths, containing a human readable complete and simple syntax.&lt;/li&gt;&lt;li&gt;compress = Compresses path draw instructions, by applying the EBNF (Extended Backus Naur Form).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SvgPathDrawModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="SvgPathDrawModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="verbose"/>
 *     <enumeration value="compact"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "SvgPathDrawModeType")
@XmlEnum
public enum SvgPathDrawModeType {

    @XmlEnumValue("verbose")
    VERBOSE("verbose"),
    @XmlEnumValue("compact")
    COMPACT("compact");
    private final String value;

    SvgPathDrawModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static SvgPathDrawModeType fromValue(String v) {
        for (SvgPathDrawModeType c: SvgPathDrawModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
