
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If you use a JPEG "image type element," the file size can be automatically optimized. The corresponding optimization routine will attempt to limit the file to a max. size by gradually reducing the JPEG quality until the image is smaller than a specific size. If the "sizeOptimization" block is present, the image will be optimized. If it is not present, the image will not be optimized further after being exported.&#13;
 * &#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     Please note that optimization can make the graphic export operation significantly slower. In addition to this, make sure to use values for the "dpi", "height", and "width" parameters that ensure that the size you want can actually be reached with compression.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SizeOptimizationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SizeOptimizationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="maxSize" type="{http://www.w3.org/2001/XMLSchema}int" default="100000" />
 *       <attribute name="maxRetries" type="{http://www.w3.org/2001/XMLSchema}int" default="5" />
 *       <attribute name="stepSize" type="{http://www.w3.org/2001/XMLSchema}int" default="10" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SizeOptimizationType")
public class SizeOptimizationType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the maximum size of the JPEG file (file size), in bytes, that should be reached. The optimization routine will be successfully completed if the file reaches or falls below the specified file size. Make sure to use a value &amp;gt; 0; otherwise, an error will be thrown.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "maxSize")
    protected Integer maxSize;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the number of runs that should be used for optimization. If the target size cannot be reached after the specified number of runs, the operation will be cancelled and an error code will be returned.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "maxRetries")
    protected Integer maxRetries;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the increment by which the JPEG quality (jpegQuality) should be reduced every run in order to reach the desired file size. If the values for maxRetries and stepSize result in an illegal JPEG quality value being reached, the operation will be cancelled and an error code will be returned.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "stepSize")
    protected Integer stepSize;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the maximum size of the JPEG file (file size), in bytes, that should be reached. The optimization routine will be successfully completed if the file reaches or falls below the specified file size. Make sure to use a value &amp;gt; 0; otherwise, an error will be thrown.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getMaxSize() {
        if (maxSize == null) {
            return  100000;
        } else {
            return maxSize;
        }
    }

    /**
     * Sets the value of the maxSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getMaxSize()
     */
    public void setMaxSize(int value) {
        this.maxSize = value;
    }

    public boolean isSetMaxSize() {
        return (this.maxSize!= null);
    }

    public void unsetMaxSize() {
        this.maxSize = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the number of runs that should be used for optimization. If the target size cannot be reached after the specified number of runs, the operation will be cancelled and an error code will be returned.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getMaxRetries() {
        if (maxRetries == null) {
            return  5;
        } else {
            return maxRetries;
        }
    }

    /**
     * Sets the value of the maxRetries property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getMaxRetries()
     */
    public void setMaxRetries(int value) {
        this.maxRetries = value;
    }

    public boolean isSetMaxRetries() {
        return (this.maxRetries!= null);
    }

    public void unsetMaxRetries() {
        this.maxRetries = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the increment by which the JPEG quality (jpegQuality) should be reduced every run in order to reach the desired file size. If the values for maxRetries and stepSize result in an illegal JPEG quality value being reached, the operation will be cancelled and an error code will be returned.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getStepSize() {
        if (stepSize == null) {
            return  10;
        } else {
            return stepSize;
        }
    }

    /**
     * Sets the value of the stepSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getStepSize()
     */
    public void setStepSize(int value) {
        this.stepSize = value;
    }

    public boolean isSetStepSize() {
        return (this.stepSize!= null);
    }

    public void unsetStepSize() {
        this.stepSize = null;
    }

}
