
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A common base type for simple shape (currently circle and square) annotations.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SimpleShapeAnnotationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SimpleShapeAnnotationType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseAnnotationType">
 *       <all>
 *         <element name="position" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice minOccurs="0">
 *                   <element name="rectangle" type="{http://schema.webpdf.de/1.0/operation}RectangleType"/>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="border" type="{http://schema.webpdf.de/1.0/operation}BorderType" minOccurs="0"/>
 *       </all>
 *       <attribute name="interiorColor" type="{http://schema.webpdf.de/1.0/operation}RgbColorType" default="#000000" />
 *       <attribute name="drawMode" type="{http://schema.webpdf.de/1.0/operation}DrawModeType" default="fillAndStroke" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SimpleShapeAnnotationType", propOrder = {
    "position",
    "border"
})
@XmlSeeAlso({
    CircleAnnotationType.class,
    SquareAnnotationType.class
})
public class SimpleShapeAnnotationType
    extends BaseAnnotationType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the bounds within which the shape shall be positioned.&lt;/p&gt;
     * </pre>
     * 
     */
    protected SimpleShapeAnnotationType.Position position;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define a border for the drawn shape. This shall only then have effect, if the outline of the shape is stroked.&lt;/p&gt;
     * </pre>
     * 
     */
    protected BorderType border;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the font color. The hereby defined color needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "interiorColor")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String interiorColor;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the draw mode for a geometrical shape.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;fill = The shape shall be filled with a given interior color.&lt;/li&gt;&lt;li&gt;stroke = The outline of the shape shall be stroked with a given color.&lt;/li&gt;&lt;li&gt;fillAndStroke = The shall shall be filled with a given interior color and it's outline shall be stroked with a given color.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "drawMode")
    protected DrawModeType drawMode;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the bounds within which the shape shall be positioned.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link SimpleShapeAnnotationType.Position }
     *     
     */
    public SimpleShapeAnnotationType.Position getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleShapeAnnotationType.Position }
     *     
     * @see #getPosition()
     */
    public void setPosition(SimpleShapeAnnotationType.Position value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define a border for the drawn shape. This shall only then have effect, if the outline of the shape is stroked.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link BorderType }
     *     
     */
    public BorderType getBorder() {
        return border;
    }

    /**
     * Sets the value of the border property.
     * 
     * @param value
     *     allowed object is
     *     {@link BorderType }
     *     
     * @see #getBorder()
     */
    public void setBorder(BorderType value) {
        this.border = value;
    }

    public boolean isSetBorder() {
        return (this.border!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the font color. The hereby defined color needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInteriorColor() {
        if (interiorColor == null) {
            return "#000000";
        } else {
            return interiorColor;
        }
    }

    /**
     * Sets the value of the interiorColor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getInteriorColor()
     */
    public void setInteriorColor(String value) {
        this.interiorColor = value;
    }

    public boolean isSetInteriorColor() {
        return (this.interiorColor!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the draw mode for a geometrical shape.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;fill = The shape shall be filled with a given interior color.&lt;/li&gt;&lt;li&gt;stroke = The outline of the shape shall be stroked with a given color.&lt;/li&gt;&lt;li&gt;fillAndStroke = The shall shall be filled with a given interior color and it's outline shall be stroked with a given color.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link DrawModeType }
     *     
     */
    public DrawModeType getDrawMode() {
        if (drawMode == null) {
            return DrawModeType.FILL_AND_STROKE;
        } else {
            return drawMode;
        }
    }

    /**
     * Sets the value of the drawMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link DrawModeType }
     *     
     * @see #getDrawMode()
     */
    public void setDrawMode(DrawModeType value) {
        this.drawMode = value;
    }

    public boolean isSetDrawMode() {
        return (this.drawMode!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice minOccurs="0">
     *         <element name="rectangle" type="{http://schema.webpdf.de/1.0/operation}RectangleType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "rectangle"
    })
    public static class Position {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Select an unrotated rectangular position.&lt;/p&gt;
         * </pre>
         * 
         */
        protected RectangleType rectangle;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Select an unrotated rectangular position.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link RectangleType }
         *     
         */
        public RectangleType getRectangle() {
            return rectangle;
        }

        /**
         * Sets the value of the rectangle property.
         * 
         * @param value
         *     allowed object is
         *     {@link RectangleType }
         *     
         * @see #getRectangle()
         */
        public void setRectangle(RectangleType value) {
            this.rectangle = value;
        }

        public boolean isSetRectangle() {
            return (this.rectangle!= null);
        }

    }

}
