
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import net.webpdf.wsclient.schema.ParameterInterface;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The "Signature" web service can be used to digitally sign documents or to remove all signatures from a PDF documents.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SignatureType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SignatureType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <choice>
 *         <element name="add">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <all>
 *                   <element name="appearance" minOccurs="0">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <all>
 *                             <element name="position" type="{http://schema.webpdf.de/1.0/operation}SignaturePositionType" minOccurs="0"/>
 *                             <element name="image" type="{http://schema.webpdf.de/1.0/operation}SignatureImageType" minOccurs="0"/>
 *                             <element name="identifierElements" type="{http://schema.webpdf.de/1.0/operation}SignatureIdentifierType" minOccurs="0"/>
 *                           </all>
 *                           <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                           <attribute name="identifier" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                           <attribute name="page" default="1">
 *                             <simpleType>
 *                               <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *                                 <minInclusive value="1"/>
 *                               </restriction>
 *                             </simpleType>
 *                           </attribute>
 *                           <attribute name="showCommonName" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                   <element name="signer" minOccurs="0">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <all>
 *                             <element name="keyPair" type="{http://schema.webpdf.de/1.0/operation}KeyPairType"/>
 *                           </all>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                 </all>
 *                 <attGroup ref="{http://schema.webpdf.de/1.0/operation}SignatureInfoGroup"/>
 *                 <attribute name="certificationLevel" type="{http://schema.webpdf.de/1.0/operation}CertificationLevelType" default="noChanges" />
 *                 <attribute name="fieldName" type="{http://www.w3.org/2001/XMLSchema}string" default="Signature1" />
 *                 <attribute name="keyName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                 <attribute name="keyPassword" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                 <attribute name="appendSignature" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="clear">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="flatten" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </choice>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SignatureType", propOrder = {
    "add",
    "clear"
})
public class SignatureType
    implements ParameterInterface
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to add a new signature to the PDF document.&lt;/p&gt;
     * </pre>
     * 
     */
    protected SignatureType.Add add;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to remove all existing signatures from the PDF document.&#13;
     * &#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                             Be aware, that this will also remove probably set passwords and encryption from the document.&#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     */
    protected SignatureType.Clear clear;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to add a new signature to the PDF document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link SignatureType.Add }
     *     
     */
    public SignatureType.Add getAdd() {
        return add;
    }

    /**
     * Sets the value of the add property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureType.Add }
     *     
     * @see #getAdd()
     */
    public void setAdd(SignatureType.Add value) {
        this.add = value;
    }

    public boolean isSetAdd() {
        return (this.add!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to remove all existing signatures from the PDF document.&#13;
     * &#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                             Be aware, that this will also remove probably set passwords and encryption from the document.&#13;
     *                         &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link SignatureType.Clear }
     *     
     */
    public SignatureType.Clear getClear() {
        return clear;
    }

    /**
     * Sets the value of the clear property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureType.Clear }
     *     
     * @see #getClear()
     */
    public void setClear(SignatureType.Clear value) {
        this.clear = value;
    }

    public boolean isSetClear() {
        return (this.clear!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <all>
     *         <element name="appearance" minOccurs="0">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <all>
     *                   <element name="position" type="{http://schema.webpdf.de/1.0/operation}SignaturePositionType" minOccurs="0"/>
     *                   <element name="image" type="{http://schema.webpdf.de/1.0/operation}SignatureImageType" minOccurs="0"/>
     *                   <element name="identifierElements" type="{http://schema.webpdf.de/1.0/operation}SignatureIdentifierType" minOccurs="0"/>
     *                 </all>
     *                 <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *                 <attribute name="identifier" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *                 <attribute name="page" default="1">
     *                   <simpleType>
     *                     <restriction base="{http://www.w3.org/2001/XMLSchema}int">
     *                       <minInclusive value="1"/>
     *                     </restriction>
     *                   </simpleType>
     *                 </attribute>
     *                 <attribute name="showCommonName" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *         <element name="signer" minOccurs="0">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <all>
     *                   <element name="keyPair" type="{http://schema.webpdf.de/1.0/operation}KeyPairType"/>
     *                 </all>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *       </all>
     *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}SignatureInfoGroup"/>
     *       <attribute name="certificationLevel" type="{http://schema.webpdf.de/1.0/operation}CertificationLevelType" default="noChanges" />
     *       <attribute name="fieldName" type="{http://www.w3.org/2001/XMLSchema}string" default="Signature1" />
     *       <attribute name="keyName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *       <attribute name="keyPassword" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *       <attribute name="appendSignature" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {

    })
    public static class Add {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the signature's visual appearance.&lt;/p&gt;
         * </pre>
         * 
         */
        protected SignatureType.Add.Appearance appearance;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Contains a key pair (&lt;code&gt;&amp;lt;keyPair&amp;gt;&lt;/code&gt;) consisting of the certificate (with public key) and the private key that identifies the signer (&lt;code&gt;&amp;lt;signer&amp;gt;&lt;/code&gt;) who performs the signature. The certificate and the signer's private key must be passed as a PEM file in &lt;code&gt;&amp;lt;certificate&amp;gt;&lt;/code&gt; and &lt;code&gt;&amp;lt;privateKey&amp;gt;&lt;/code&gt; respectively.&#13;
         *                                         The element is optional. If no &lt;code&gt;&amp;lt;keyPair&amp;gt;&lt;/code&gt; (consisting of the certificate and the private key) is passed directly, then a certificate must be selected via &lt;code&gt;&amp;lt;keyName&amp;gt;&lt;/code&gt;, which is loaded from the server's global keystore.&#13;
         *                                     &lt;/p&gt;
         * </pre>
         * 
         */
        protected SignatureType.Add.Signer signer;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter defines the level of the signature.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;none = Sign, but do not certify, the document, i.e., additional signatures and changes will be allowed.&lt;/li&gt;&lt;li&gt;noChanges = Certify the document and do not allow any additional changes anymore.&lt;/li&gt;&lt;li&gt;formFillingAndSignatures = Certify the document, but allow for fields to be filled out.&lt;/li&gt;&lt;li&gt;formFillingAndSignaturesAndAnnotations = Certify the document, but allow for fields to be filled out and annotations to be added.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "certificationLevel")
        protected CertificationLevelType certificationLevel;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the name of the field (in the document) in which the signature will be saved. If a field name that is not unique is declared, then a unique name will be automatically created.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "fieldName")
        protected String fieldName;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the name of the key (alias) that is to be used to sign the document. This option overwrites the server's configuration setting. Additional information can be found in the "Keystore" chapter.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "keyName")
        protected String keyName;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the password required in order to access the private key with "keyName." This option overwrites the server's configuration setting. Additional information can be found in the "Keystore" chapter.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "keyPassword")
        protected String keyPassword;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Deprecated:&lt;/b&gt;&#13;
         *                                     Usage of this parameter is discouraged, as it is no longer in use.&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "appendSignature")
        protected Boolean appendSignature;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the location of the signature.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "location")
        protected String location;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the name of the person signing the document.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "contact")
        protected String contact;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the reason why the document is being signed.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "reason")
        protected String reason;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the signature's visual appearance.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link SignatureType.Add.Appearance }
         *     
         */
        public SignatureType.Add.Appearance getAppearance() {
            return appearance;
        }

        /**
         * Sets the value of the appearance property.
         * 
         * @param value
         *     allowed object is
         *     {@link SignatureType.Add.Appearance }
         *     
         * @see #getAppearance()
         */
        public void setAppearance(SignatureType.Add.Appearance value) {
            this.appearance = value;
        }

        public boolean isSetAppearance() {
            return (this.appearance!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Contains a key pair (&lt;code&gt;&amp;lt;keyPair&amp;gt;&lt;/code&gt;) consisting of the certificate (with public key) and the private key that identifies the signer (&lt;code&gt;&amp;lt;signer&amp;gt;&lt;/code&gt;) who performs the signature. The certificate and the signer's private key must be passed as a PEM file in &lt;code&gt;&amp;lt;certificate&amp;gt;&lt;/code&gt; and &lt;code&gt;&amp;lt;privateKey&amp;gt;&lt;/code&gt; respectively.&#13;
         *                                         The element is optional. If no &lt;code&gt;&amp;lt;keyPair&amp;gt;&lt;/code&gt; (consisting of the certificate and the private key) is passed directly, then a certificate must be selected via &lt;code&gt;&amp;lt;keyName&amp;gt;&lt;/code&gt;, which is loaded from the server's global keystore.&#13;
         *                                     &lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link SignatureType.Add.Signer }
         *     
         */
        public SignatureType.Add.Signer getSigner() {
            return signer;
        }

        /**
         * Sets the value of the signer property.
         * 
         * @param value
         *     allowed object is
         *     {@link SignatureType.Add.Signer }
         *     
         * @see #getSigner()
         */
        public void setSigner(SignatureType.Add.Signer value) {
            this.signer = value;
        }

        public boolean isSetSigner() {
            return (this.signer!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter defines the level of the signature.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;none = Sign, but do not certify, the document, i.e., additional signatures and changes will be allowed.&lt;/li&gt;&lt;li&gt;noChanges = Certify the document and do not allow any additional changes anymore.&lt;/li&gt;&lt;li&gt;formFillingAndSignatures = Certify the document, but allow for fields to be filled out.&lt;/li&gt;&lt;li&gt;formFillingAndSignaturesAndAnnotations = Certify the document, but allow for fields to be filled out and annotations to be added.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link CertificationLevelType }
         *     
         */
        public CertificationLevelType getCertificationLevel() {
            if (certificationLevel == null) {
                return CertificationLevelType.NO_CHANGES;
            } else {
                return certificationLevel;
            }
        }

        /**
         * Sets the value of the certificationLevel property.
         * 
         * @param value
         *     allowed object is
         *     {@link CertificationLevelType }
         *     
         * @see #getCertificationLevel()
         */
        public void setCertificationLevel(CertificationLevelType value) {
            this.certificationLevel = value;
        }

        public boolean isSetCertificationLevel() {
            return (this.certificationLevel!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the name of the field (in the document) in which the signature will be saved. If a field name that is not unique is declared, then a unique name will be automatically created.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getFieldName() {
            if (fieldName == null) {
                return "Signature1";
            } else {
                return fieldName;
            }
        }

        /**
         * Sets the value of the fieldName property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getFieldName()
         */
        public void setFieldName(String value) {
            this.fieldName = value;
        }

        public boolean isSetFieldName() {
            return (this.fieldName!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the name of the key (alias) that is to be used to sign the document. This option overwrites the server's configuration setting. Additional information can be found in the "Keystore" chapter.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getKeyName() {
            if (keyName == null) {
                return "";
            } else {
                return keyName;
            }
        }

        /**
         * Sets the value of the keyName property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getKeyName()
         */
        public void setKeyName(String value) {
            this.keyName = value;
        }

        public boolean isSetKeyName() {
            return (this.keyName!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the password required in order to access the private key with "keyName." This option overwrites the server's configuration setting. Additional information can be found in the "Keystore" chapter.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getKeyPassword() {
            if (keyPassword == null) {
                return "";
            } else {
                return keyPassword;
            }
        }

        /**
         * Sets the value of the keyPassword property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getKeyPassword()
         */
        public void setKeyPassword(String value) {
            this.keyPassword = value;
        }

        public boolean isSetKeyPassword() {
            return (this.keyPassword!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Deprecated:&lt;/b&gt;&#13;
         *                                     Usage of this parameter is discouraged, as it is no longer in use.&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isAppendSignature() {
            if (appendSignature == null) {
                return false;
            } else {
                return appendSignature;
            }
        }

        /**
         * Sets the value of the appendSignature property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         * @see #isAppendSignature()
         */
        public void setAppendSignature(boolean value) {
            this.appendSignature = value;
        }

        public boolean isSetAppendSignature() {
            return (this.appendSignature!= null);
        }

        public void unsetAppendSignature() {
            this.appendSignature = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the location of the signature.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getLocation() {
            if (location == null) {
                return "";
            } else {
                return location;
            }
        }

        /**
         * Sets the value of the location property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getLocation()
         */
        public void setLocation(String value) {
            this.location = value;
        }

        public boolean isSetLocation() {
            return (this.location!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the name of the person signing the document.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getContact() {
            if (contact == null) {
                return "";
            } else {
                return contact;
            }
        }

        /**
         * Sets the value of the contact property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getContact()
         */
        public void setContact(String value) {
            this.contact = value;
        }

        public boolean isSetContact() {
            return (this.contact!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the reason why the document is being signed.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getReason() {
            if (reason == null) {
                return "";
            } else {
                return reason;
            }
        }

        /**
         * Sets the value of the reason property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getReason()
         */
        public void setReason(String value) {
            this.reason = value;
        }

        public boolean isSetReason() {
            return (this.reason!= null);
        }


        /**
         * <p>Java class for anonymous complex type</p>.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.</p>
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <all>
         *         <element name="position" type="{http://schema.webpdf.de/1.0/operation}SignaturePositionType" minOccurs="0"/>
         *         <element name="image" type="{http://schema.webpdf.de/1.0/operation}SignatureImageType" minOccurs="0"/>
         *         <element name="identifierElements" type="{http://schema.webpdf.de/1.0/operation}SignatureIdentifierType" minOccurs="0"/>
         *       </all>
         *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
         *       <attribute name="identifier" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
         *       <attribute name="page" default="1">
         *         <simpleType>
         *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
         *             <minInclusive value="1"/>
         *           </restriction>
         *         </simpleType>
         *       </attribute>
         *       <attribute name="showCommonName" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {

        })
        public static class Appearance {

            protected SignaturePositionType position;
            protected SignatureImageType image;
            protected SignatureIdentifierType identifierElements;
            /**
             * <pre>
             * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Name that will be displayed in the signature's left-hand side area. If no value is specified, the name of the signer is displayed in this area (CN name part from the certificate) if &lt;code&gt;showCommonName&lt;/code&gt; is enabled.&#13;
             *                                             &lt;/p&gt;
             * </pre>
             * 
             */
            @XmlAttribute(name = "name")
            protected String name;
            /**
             * <pre>
             * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Text that should be displayed in the signature's right-hand side text field. If a value is not specified, the field will display the name of the signatory and the name parts of the certificate (please refer to &lt;code&gt;&amp;lt;identifierElements&amp;gt;&lt;/code&gt; further below).&#13;
             *                                             &lt;/p&gt;
             * </pre>
             * 
             */
            @XmlAttribute(name = "identifier")
            protected String identifier;
            /**
             * <pre>
             * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the page on which the signature is to be displayed.&lt;/p&gt;
             * </pre>
             * 
             */
            @XmlAttribute(name = "page")
            protected Integer page;
            /**
             * <pre>
             * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the certificate name (CN) of the certificate in the signature's left-hand side area. A set &lt;code&gt;name&lt;/code&gt; always has priority over the setting of this option.&#13;
             *                                             &lt;/p&gt;
             * </pre>
             * 
             */
            @XmlAttribute(name = "showCommonName")
            protected Boolean showCommonName;

            /**
             * Gets the value of the position property.
             * 
             * @return
             *     possible object is
             *     {@link SignaturePositionType }
             *     
             */
            public SignaturePositionType getPosition() {
                return position;
            }

            /**
             * Sets the value of the position property.
             * 
             * @param value
             *     allowed object is
             *     {@link SignaturePositionType }
             *     
             */
            public void setPosition(SignaturePositionType value) {
                this.position = value;
            }

            public boolean isSetPosition() {
                return (this.position!= null);
            }

            /**
             * Gets the value of the image property.
             * 
             * @return
             *     possible object is
             *     {@link SignatureImageType }
             *     
             */
            public SignatureImageType getImage() {
                return image;
            }

            /**
             * Sets the value of the image property.
             * 
             * @param value
             *     allowed object is
             *     {@link SignatureImageType }
             *     
             */
            public void setImage(SignatureImageType value) {
                this.image = value;
            }

            public boolean isSetImage() {
                return (this.image!= null);
            }

            /**
             * Gets the value of the identifierElements property.
             * 
             * @return
             *     possible object is
             *     {@link SignatureIdentifierType }
             *     
             */
            public SignatureIdentifierType getIdentifierElements() {
                return identifierElements;
            }

            /**
             * Sets the value of the identifierElements property.
             * 
             * @param value
             *     allowed object is
             *     {@link SignatureIdentifierType }
             *     
             */
            public void setIdentifierElements(SignatureIdentifierType value) {
                this.identifierElements = value;
            }

            public boolean isSetIdentifierElements() {
                return (this.identifierElements!= null);
            }

            /**
             * <pre>
             * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Name that will be displayed in the signature's left-hand side area. If no value is specified, the name of the signer is displayed in this area (CN name part from the certificate) if &lt;code&gt;showCommonName&lt;/code&gt; is enabled.&#13;
             *                                             &lt;/p&gt;
             * </pre>
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getName() {
                if (name == null) {
                    return "";
                } else {
                    return name;
                }
            }

            /**
             * Sets the value of the name property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             * @see #getName()
             */
            public void setName(String value) {
                this.name = value;
            }

            public boolean isSetName() {
                return (this.name!= null);
            }

            /**
             * <pre>
             * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Text that should be displayed in the signature's right-hand side text field. If a value is not specified, the field will display the name of the signatory and the name parts of the certificate (please refer to &lt;code&gt;&amp;lt;identifierElements&amp;gt;&lt;/code&gt; further below).&#13;
             *                                             &lt;/p&gt;
             * </pre>
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getIdentifier() {
                if (identifier == null) {
                    return "";
                } else {
                    return identifier;
                }
            }

            /**
             * Sets the value of the identifier property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             * @see #getIdentifier()
             */
            public void setIdentifier(String value) {
                this.identifier = value;
            }

            public boolean isSetIdentifier() {
                return (this.identifier!= null);
            }

            /**
             * <pre>
             * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the page on which the signature is to be displayed.&lt;/p&gt;
             * </pre>
             * 
             * @return
             *     possible object is
             *     {@link Integer }
             *     
             */
            public int getPage() {
                if (page == null) {
                    return  1;
                } else {
                    return page;
                }
            }

            /**
             * Sets the value of the page property.
             * 
             * @param value
             *     allowed object is
             *     {@link Integer }
             *     
             * @see #getPage()
             */
            public void setPage(int value) {
                this.page = value;
            }

            public boolean isSetPage() {
                return (this.page!= null);
            }

            public void unsetPage() {
                this.page = null;
            }

            /**
             * <pre>
             * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Displays or hides the certificate name (CN) of the certificate in the signature's left-hand side area. A set &lt;code&gt;name&lt;/code&gt; always has priority over the setting of this option.&#13;
             *                                             &lt;/p&gt;
             * </pre>
             * 
             * @return
             *     possible object is
             *     {@link Boolean }
             *     
             */
            public boolean isShowCommonName() {
                if (showCommonName == null) {
                    return true;
                } else {
                    return showCommonName;
                }
            }

            /**
             * Sets the value of the showCommonName property.
             * 
             * @param value
             *     allowed object is
             *     {@link Boolean }
             *     
             * @see #isShowCommonName()
             */
            public void setShowCommonName(boolean value) {
                this.showCommonName = value;
            }

            public boolean isSetShowCommonName() {
                return (this.showCommonName!= null);
            }

            public void unsetShowCommonName() {
                this.showCommonName = null;
            }

        }


        /**
         * <p>Java class for anonymous complex type</p>.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.</p>
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <all>
         *         <element name="keyPair" type="{http://schema.webpdf.de/1.0/operation}KeyPairType"/>
         *       </all>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {

        })
        public static class Signer {

            @XmlElement(required = true)
            protected KeyPairType keyPair;

            /**
             * Gets the value of the keyPair property.
             * 
             * @return
             *     possible object is
             *     {@link KeyPairType }
             *     
             */
            public KeyPairType getKeyPair() {
                return keyPair;
            }

            /**
             * Sets the value of the keyPair property.
             * 
             * @param value
             *     allowed object is
             *     {@link KeyPairType }
             *     
             */
            public void setKeyPair(KeyPairType value) {
                this.keyPair = value;
            }

            public boolean isSetKeyPair() {
                return (this.keyPair!= null);
            }

        }

    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="flatten" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Clear {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When set to "true", this will render all visible signatures to the page content.&#13;
         * &#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
         *                                     The actual signatures will still be removed! The hereby generated visual representation is not verifyable or binding and can not serve/does not count as a valid digital signature.&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "flatten")
        protected Boolean flatten;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When set to "true", this will render all visible signatures to the page content.&#13;
         * &#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p272839_="https://jakarta.ee/xml/ns/jaxb" xmlns:p501776_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
         *                                     The actual signatures will still be removed! The hereby generated visual representation is not verifyable or binding and can not serve/does not count as a valid digital signature.&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isFlatten() {
            if (flatten == null) {
                return false;
            } else {
                return flatten;
            }
        }

        /**
         * Sets the value of the flatten property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         * @see #isFlatten()
         */
        public void setFlatten(boolean value) {
            this.flatten = value;
        }

        public boolean isSetFlatten() {
            return (this.flatten!= null);
        }

        public void unsetFlatten() {
            this.flatten = null;
        }

    }

}
