
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p241767_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p507843_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set an area from which attachments that meet the selection rules will be removed. You can use multiple selection elements.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SelectionAttachmentType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SelectionAttachmentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="fileMask" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="context" type="{http://schema.webpdf.de/1.0/operation}ContextType" default="all" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SelectionAttachmentType")
public class SelectionAttachmentType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p241767_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p507843_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Page range to which the selection applies.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p241767_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p507843_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Filters by file name for the selection. "*.xls", for example, would result in all XLS attachments in the selection area being removed. Meanwhile, "xyz.json" would result in attachments named "xyz.json" being removed from the selection area.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fileMask")
    protected String fileMask;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p241767_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p507843_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Level to which the selection applies.&#13;
     *                         &lt;ul&gt;&lt;li&gt;all = All levels&lt;/li&gt;&lt;li&gt;document = Document level only&lt;/li&gt;&lt;li&gt;page = Page level only&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "context")
    protected ContextType context;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p241767_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p507843_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Page range to which the selection applies.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p241767_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p507843_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Filters by file name for the selection. "*.xls", for example, would result in all XLS attachments in the selection area being removed. Meanwhile, "xyz.json" would result in attachments named "xyz.json" being removed from the selection area.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFileMask() {
        if (fileMask == null) {
            return "";
        } else {
            return fileMask;
        }
    }

    /**
     * Sets the value of the fileMask property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFileMask()
     */
    public void setFileMask(String value) {
        this.fileMask = value;
    }

    public boolean isSetFileMask() {
        return (this.fileMask!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p241767_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p507843_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Level to which the selection applies.&#13;
     *                         &lt;ul&gt;&lt;li&gt;all = All levels&lt;/li&gt;&lt;li&gt;document = Document level only&lt;/li&gt;&lt;li&gt;page = Page level only&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ContextType }
     *     
     */
    public ContextType getContext() {
        if (context == null) {
            return ContextType.ALL;
        } else {
            return context;
        }
    }

    /**
     * Sets the value of the context property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContextType }
     *     
     * @see #getContext()
     */
    public void setContext(ContextType value) {
        this.context = value;
    }

    public boolean isSetContext() {
        return (this.context!= null);
    }

}
