
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page relative position to place the barcode at.&#13;
 *                     &lt;ul&gt;&lt;li&gt;insertBefore = Places the barcode on a new, empty page before the selected page.&lt;/li&gt;&lt;li&gt;appendAtEnd = Places the barcode on a new, empty page at the end of the document.&lt;/li&gt;&lt;li&gt;addToPage = Place the barcode on the selected page.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for QrSwissPaymentPdfModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="QrSwissPaymentPdfModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="insertBefore"/>
 *     <enumeration value="appendAtEnd"/>
 *     <enumeration value="addToPage"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "QrSwissPaymentPdfModeType")
@XmlEnum
public enum QrSwissPaymentPdfModeType {

    @XmlEnumValue("insertBefore")
    INSERT_BEFORE("insertBefore"),
    @XmlEnumValue("appendAtEnd")
    APPEND_AT_END("appendAtEnd"),
    @XmlEnumValue("addToPage")
    ADD_TO_PAGE("addToPage");
    private final String value;

    QrSwissPaymentPdfModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static QrSwissPaymentPdfModeType fromValue(String v) {
        for (QrSwissPaymentPdfModeType c: QrSwissPaymentPdfModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
