
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the format of the encoded data.&#13;
 *                     &lt;ul&gt;&lt;li&gt;plain = The code shall contain plain text.&lt;/li&gt;&lt;li&gt;json = The code shall contain structured json data.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for QrSwissPaymentContentFormatType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="QrSwissPaymentContentFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="plain"/>
 *     <enumeration value="json"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "QrSwissPaymentContentFormatType")
@XmlEnum
public enum QrSwissPaymentContentFormatType {

    @XmlEnumValue("plain")
    PLAIN("plain"),
    @XmlEnumValue("json")
    JSON("json");
    private final String value;

    QrSwissPaymentContentFormatType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static QrSwissPaymentContentFormatType fromValue(String v) {
        for (QrSwissPaymentContentFormatType c: QrSwissPaymentContentFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
