
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
 *                     The &lt;code&gt;pdfa&lt;/code&gt; element allows to make settings for automatic handling of PDF/A documents. Editing a PDF/A document will most likely render it invalid, thus the web service operation checks whether it´s execution is valid for a given PDF/A document according to these settings.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PdfaSettingsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PdfaSettingsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="pdfaEditProfile" type="{http://schema.webpdf.de/1.0/operation}PdfaEditProfileType" default="removePdfaMetadata" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PdfaSettingsType")
public class PdfaSettingsType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the profile whose rules web services have to check before they can come to execution. These profiles define a set of rules concerning the validity of PDF/A documents. A web service whose execution for a given PDF/A document would violate the rule set selected here should instead abort with an appropriate error code.&#13;
     *                         &lt;ul&gt;&lt;li&gt;generalEditRestrictions = All changes to PDF/A documents are prohibited.&lt;/li&gt;&lt;li&gt;removePdfaMetadata = All changes to PDF/A documents are allowed, but the PDF/A state of the document is revoked. (By removing the PDF/A metadata.)&lt;/li&gt;&lt;li&gt;noEditRestrictions = All changes to PDF/A documents are allowed, without touching the PDF/A state of the document. (Risking the invalidation of the document.)&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pdfaEditProfile")
    protected PdfaEditProfileType pdfaEditProfile;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the profile whose rules web services have to check before they can come to execution. These profiles define a set of rules concerning the validity of PDF/A documents. A web service whose execution for a given PDF/A document would violate the rule set selected here should instead abort with an appropriate error code.&#13;
     *                         &lt;ul&gt;&lt;li&gt;generalEditRestrictions = All changes to PDF/A documents are prohibited.&lt;/li&gt;&lt;li&gt;removePdfaMetadata = All changes to PDF/A documents are allowed, but the PDF/A state of the document is revoked. (By removing the PDF/A metadata.)&lt;/li&gt;&lt;li&gt;noEditRestrictions = All changes to PDF/A documents are allowed, without touching the PDF/A state of the document. (Risking the invalidation of the document.)&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PdfaEditProfileType }
     *     
     */
    public PdfaEditProfileType getPdfaEditProfile() {
        if (pdfaEditProfile == null) {
            return PdfaEditProfileType.REMOVE_PDFA_METADATA;
        } else {
            return pdfaEditProfile;
        }
    }

    /**
     * Sets the value of the pdfaEditProfile property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfaEditProfileType }
     *     
     * @see #getPdfaEditProfile()
     */
    public void setPdfaEditProfile(PdfaEditProfileType value) {
        this.pdfaEditProfile = value;
    }

    public boolean isSetPdfaEditProfile() {
        return (this.pdfaEditProfile!= null);
    }

}
