
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p106995_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p874552_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter can be used to optionally activate automatic error correction.&#13;
 *                     If a PDF/A conversion does not work, this may be due to defective PDF syntax structures in the source document. If error correction is enabled then an attempt will be made to correct these syntax errors automatically.&#13;
 * &#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p106995_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p874552_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     If the conversion of an existing PDF document to a certain level (e.g. PDF/A-1) does not work, then there must not always be syntax errors in the document. It may also be that the source document does not have all the necessary content (e.g. missing font embedding) that is mandatory for conversion to a certain level. In this case it may be sufficient to switch to a different PDF/A level.&#13;
 *                     Therefore, the conversion report should always be checked first to see if there is really a defective source document before activating error correction.&#13;
 * &#13;
 *                     Error correction tries to correct syntax errors such as defective XREF tables or defective objects (defective data streams) in the PDF structure. First the PDF/conversion is performed normally. If errors are then detected so that a valid PDF/A is not created, an attempt is made to perform error correction.&#13;
 *                     If the error correction works, a second pass of the PDF/A conversion is performed. If this run works, then the corresponding PDF/A document is delivered. If not, the corresponding error code and possibly the error report will be delivered.&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p106995_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p874552_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     If error correction is active, then visual and/or content deviations may occur in the converted PDF/A document. If you activate this option, then the resulting document should be checked in any case.&#13;
 * &#13;
 *                     It is recommended to perform the PDF/A conversion first without activating the error correction to be sure that the document is not visually and contentwise changed after the conversion. Only if the conversion was not possible (and the error report was checked) should the option be activated in a second call. The PDF/A document of the second call should be checked for visual and content problems.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PdfaErrorCorrectionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PdfaErrorCorrectionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="enabled" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PdfaErrorCorrectionType")
public class PdfaErrorCorrectionType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p106995_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p874552_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Enables or disables error correction. If the option is set to "true" then PDF syntax errors in the PDF document will be corrected during PDF/A conversion.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "enabled")
    protected Boolean enabled;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p106995_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p874552_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Enables or disables error correction. If the option is set to "true" then PDF syntax errors in the PDF document will be corrected during PDF/A conversion.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isEnabled() {
        if (enabled == null) {
            return false;
        } else {
            return enabled;
        }
    }

    /**
     * Sets the value of the enabled property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isEnabled()
     */
    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isSetEnabled() {
        return (this.enabled!= null);
    }

    public void unsetEnabled() {
        this.enabled = null;
    }

}
