
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The &lt;code&gt;password&lt;/code&gt; element can be used to set the user and owner passwords or certificates for the PDF document which are needed if the PDF document is protected. For example, if a protected PDF document is to be edited with the web service, then these settings can be used to provide the password or certificates for access.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PdfPasswordType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PdfPasswordType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="keyPair" type="{http://schema.webpdf.de/1.0/operation}KeyPairType" minOccurs="0"/>
 *       </all>
 *       <attribute name="permission" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="open" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PdfPasswordType", propOrder = {

})
public class PdfPasswordType {

    protected KeyPairType keyPair;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A password that allows "editing access" to the document. If the provided PDF document is password protected and the web service operation is to edit the document, then the appropriate password (owner password) must be provided to unlock the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "permission")
    protected String permission;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A password that is required to open the document. If the provided PDF document is protected in such a way that a password (user password) is required to read the document, the corresponding password must also be passed. Without this password it is not possible to edit the document with the web service, because it cannot be read.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "open")
    protected String open;

    /**
     * Gets the value of the keyPair property.
     * 
     * @return
     *     possible object is
     *     {@link KeyPairType }
     *     
     */
    public KeyPairType getKeyPair() {
        return keyPair;
    }

    /**
     * Sets the value of the keyPair property.
     * 
     * @param value
     *     allowed object is
     *     {@link KeyPairType }
     *     
     */
    public void setKeyPair(KeyPairType value) {
        this.keyPair = value;
    }

    public boolean isSetKeyPair() {
        return (this.keyPair!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A password that allows "editing access" to the document. If the provided PDF document is password protected and the web service operation is to edit the document, then the appropriate password (owner password) must be provided to unlock the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPermission() {
        if (permission == null) {
            return "";
        } else {
            return permission;
        }
    }

    /**
     * Sets the value of the permission property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPermission()
     */
    public void setPermission(String value) {
        this.permission = value;
    }

    public boolean isSetPermission() {
        return (this.permission!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A password that is required to open the document. If the provided PDF document is protected in such a way that a password (user password) is required to read the document, the corresponding password must also be passed. Without this password it is not possible to edit the document with the web service, because it cannot be read.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOpen() {
        if (open == null) {
            return "";
        } else {
            return open;
        }
    }

    /**
     * Sets the value of the open property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getOpen()
     */
    public void setOpen(String value) {
        this.open = value;
    }

    public boolean isSetOpen() {
        return (this.open!= null);
    }

}
