
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects which criteria to use to determine the orientation (portrait/landscape) of pages (see also "pageOrientation"):&#13;
 *                     &lt;ul&gt;&lt;li&gt;value = Based solely on the page rotation value entered in the PDF.&lt;/li&gt;&lt;li&gt;dimensions = Based on the ratio of the page dimensions to each other.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for OrientationDetectionType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="OrientationDetectionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="value"/>
 *     <enumeration value="dimensions"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "OrientationDetectionType")
@XmlEnum
public enum OrientationDetectionType {

    @XmlEnumValue("value")
    VALUE("value"),
    @XmlEnumValue("dimensions")
    DIMENSIONS("dimensions");
    private final String value;

    OrientationDetectionType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static OrientationDetectionType fromValue(String v) {
        for (OrientationDetectionType c: OrientationDetectionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
