
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p203484_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p715512_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If images are converted to PDF documents during the character recognition process, the size of the page will be computed based on the size of the image and the DPI resolution. This element can be used to specify a custom page size instead.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for OcrPageType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="OcrPageType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="width" default="210">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="height" default="297">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="metrics" type="{http://schema.webpdf.de/1.0/operation}MetricsType" default="mm" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OcrPageType")
public class OcrPageType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p203484_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p715512_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Width of the page in the PDF document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "width")
    protected Integer width;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p203484_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p715512_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Height of the page in the PDF document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "height")
    protected Integer height;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p203484_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p715512_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
     *                         Unit for the page size arguments.&#13;
     *                         &lt;ul&gt;&lt;li&gt;pt = Points(1/72 inch)&lt;/li&gt;&lt;li&gt;pc = Picas(12 points)&lt;/li&gt;&lt;li&gt;px = Pixels(1/96 inch)&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "metrics")
    protected MetricsType metrics;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p203484_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p715512_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Width of the page in the PDF document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getWidth() {
        if (width == null) {
            return  210;
        } else {
            return width;
        }
    }

    /**
     * Sets the value of the width property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getWidth()
     */
    public void setWidth(int value) {
        this.width = value;
    }

    public boolean isSetWidth() {
        return (this.width!= null);
    }

    public void unsetWidth() {
        this.width = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p203484_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p715512_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Height of the page in the PDF document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getHeight() {
        if (height == null) {
            return  297;
        } else {
            return height;
        }
    }

    /**
     * Sets the value of the height property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getHeight()
     */
    public void setHeight(int value) {
        this.height = value;
    }

    public boolean isSetHeight() {
        return (this.height!= null);
    }

    public void unsetHeight() {
        this.height = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p203484_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p715512_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&#13;
     *                         Unit for the page size arguments.&#13;
     *                         &lt;ul&gt;&lt;li&gt;pt = Points(1/72 inch)&lt;/li&gt;&lt;li&gt;pc = Picas(12 points)&lt;/li&gt;&lt;li&gt;px = Pixels(1/96 inch)&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link MetricsType }
     *     
     */
    public MetricsType getMetrics() {
        if (metrics == null) {
            return MetricsType.MM;
        } else {
            return metrics;
        }
    }

    /**
     * Sets the value of the metrics property.
     * 
     * @param value
     *     allowed object is
     *     {@link MetricsType }
     *     
     * @see #getMetrics()
     */
    public void setMetrics(MetricsType value) {
        this.metrics = value;
    }

    public boolean isSetMetrics() {
        return (this.metrics!= null);
    }

}
