
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The merge operation element can be used to merge documents.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     When a "merge" operation is performed, the pages and structural information (such as outlines and tag) will be merged. This can result in name conflicts that can prevent a success. If you would rather like to ignore such conflicts use the matching "ignoreConflicts" parameter.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     Merging documents could also fail because of signatures or a used PDF/A format. As&#13;
 *                     &lt;ul&gt;&lt;li&gt;by definition - altering PDF/A documents and signed documents would result in an invalidation of such documents/signatures.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for MergeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="MergeType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <all>
 *         <element name="data" type="{http://schema.webpdf.de/1.0/operation}MergeFileDataType"/>
 *       </all>
 *       <attribute name="mode" type="{http://schema.webpdf.de/1.0/operation}MergeModeType" default="atTheEnd" />
 *       <attribute name="page" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="sourceIsZip" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="outlineName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="resetMetadata" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="removeStaticXFA" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MergeType", propOrder = {
    "data"
})
public class MergeType
    extends BaseToolboxType
{

    @XmlElement(required = true)
    protected MergeFileDataType data;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the mode used to merge the PDF documents. The PDF document passed with the "data" element will be appended to the current PDF document or inserted at a specific point.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The following modes define the position where the documents will be inserted. Instead of a single base document, the "portfolio" mode always expects a ZIP archive. The elements in this archive will be added, all with identical permissions, to the resulting portfolio (the data element is not required at all for "portfolio").&#13;
     *                                 &lt;ul&gt;&lt;li&gt;atTheEnd = At the end of the PDF document&lt;/li&gt;&lt;li&gt;atTheBeginning = At the beginning of the PDF document&lt;/li&gt;&lt;li&gt;afterPage = After a page (please refer to the "page" attribute) in the PDF document&lt;/li&gt;&lt;li&gt;beforePage = Before a page (please refer to the "page" attribute) in the PDF document&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "mode")
    protected MergeModeType mode;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the page number where the PDF document should be inserted.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "page")
    protected Integer page;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this parameter is enabled, a ZIP archive&#13;
     *                                 &lt;ul&gt;&lt;li&gt;containing the documents to merge - will be expected as the webservice's source document. Also - in that case, the "data" parameter is not required. The first element in the ZIP archive will be used as a base document to which all following entries will be appended.&lt;/li&gt;&lt;/ul&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 The usage of this parameter is expected to be used for the "portfolio" mode. All the documents in the ZIP archive will be added to the portfolio receiving identical permission settings.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "sourceIsZip")
    protected Boolean sourceIsZip;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the base path that should be used for outline nodes of the source document. This parameter can contain a slash separated path and should ideally end with the name of the document ("A/B/filename"). If this parameter is not set, all outlines will be appended to the root outline node.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "outlineName")
    protected String outlineName;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If you enable this parameter, the source document's metadata will be removed and replaced with default values.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "resetMetadata")
    protected Boolean resetMetadata;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this parameter is enabled, all entries related to static XFA documents and all connected extended permission settings will be removed from the document. Using this parameter it is possible to merge static XFA documents with other documents, which is normally forbidden by default.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 Although this parameter allows the merging of static XFA documents, this will not create a valid static XFA document as a result. All structures qualifying a document as a static XFA document will be removed. The resulting document will contain a pure Acroform and will not be recognized as a XFA form by applications for XFA creation/editing. Also, all extended access&#13;
     *                                 &lt;ul&gt;&lt;li&gt;and write permissions will be removed (That normally can expected to be found in a static XFA document).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "removeStaticXFA")
    protected Boolean removeStaticXFA;

    /**
     * Gets the value of the data property.
     * 
     * @return
     *     possible object is
     *     {@link MergeFileDataType }
     *     
     */
    public MergeFileDataType getData() {
        return data;
    }

    /**
     * Sets the value of the data property.
     * 
     * @param value
     *     allowed object is
     *     {@link MergeFileDataType }
     *     
     */
    public void setData(MergeFileDataType value) {
        this.data = value;
    }

    public boolean isSetData() {
        return (this.data!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the mode used to merge the PDF documents. The PDF document passed with the "data" element will be appended to the current PDF document or inserted at a specific point.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The following modes define the position where the documents will be inserted. Instead of a single base document, the "portfolio" mode always expects a ZIP archive. The elements in this archive will be added, all with identical permissions, to the resulting portfolio (the data element is not required at all for "portfolio").&#13;
     *                                 &lt;ul&gt;&lt;li&gt;atTheEnd = At the end of the PDF document&lt;/li&gt;&lt;li&gt;atTheBeginning = At the beginning of the PDF document&lt;/li&gt;&lt;li&gt;afterPage = After a page (please refer to the "page" attribute) in the PDF document&lt;/li&gt;&lt;li&gt;beforePage = Before a page (please refer to the "page" attribute) in the PDF document&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link MergeModeType }
     *     
     */
    public MergeModeType getMode() {
        if (mode == null) {
            return MergeModeType.AT_THE_END;
        } else {
            return mode;
        }
    }

    /**
     * Sets the value of the mode property.
     * 
     * @param value
     *     allowed object is
     *     {@link MergeModeType }
     *     
     * @see #getMode()
     */
    public void setMode(MergeModeType value) {
        this.mode = value;
    }

    public boolean isSetMode() {
        return (this.mode!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the page number where the PDF document should be inserted.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  1;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getPage()
     */
    public void setPage(int value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    public void unsetPage() {
        this.page = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this parameter is enabled, a ZIP archive&#13;
     *                                 &lt;ul&gt;&lt;li&gt;containing the documents to merge - will be expected as the webservice's source document. Also - in that case, the "data" parameter is not required. The first element in the ZIP archive will be used as a base document to which all following entries will be appended.&lt;/li&gt;&lt;/ul&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 The usage of this parameter is expected to be used for the "portfolio" mode. All the documents in the ZIP archive will be added to the portfolio receiving identical permission settings.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isSourceIsZip() {
        if (sourceIsZip == null) {
            return false;
        } else {
            return sourceIsZip;
        }
    }

    /**
     * Sets the value of the sourceIsZip property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isSourceIsZip()
     */
    public void setSourceIsZip(boolean value) {
        this.sourceIsZip = value;
    }

    public boolean isSetSourceIsZip() {
        return (this.sourceIsZip!= null);
    }

    public void unsetSourceIsZip() {
        this.sourceIsZip = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the base path that should be used for outline nodes of the source document. This parameter can contain a slash separated path and should ideally end with the name of the document ("A/B/filename"). If this parameter is not set, all outlines will be appended to the root outline node.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOutlineName() {
        if (outlineName == null) {
            return "";
        } else {
            return outlineName;
        }
    }

    /**
     * Sets the value of the outlineName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getOutlineName()
     */
    public void setOutlineName(String value) {
        this.outlineName = value;
    }

    public boolean isSetOutlineName() {
        return (this.outlineName!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If you enable this parameter, the source document's metadata will be removed and replaced with default values.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isResetMetadata() {
        if (resetMetadata == null) {
            return false;
        } else {
            return resetMetadata;
        }
    }

    /**
     * Sets the value of the resetMetadata property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isResetMetadata()
     */
    public void setResetMetadata(boolean value) {
        this.resetMetadata = value;
    }

    public boolean isSetResetMetadata() {
        return (this.resetMetadata!= null);
    }

    public void unsetResetMetadata() {
        this.resetMetadata = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this parameter is enabled, all entries related to static XFA documents and all connected extended permission settings will be removed from the document. Using this parameter it is possible to merge static XFA documents with other documents, which is normally forbidden by default.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 Although this parameter allows the merging of static XFA documents, this will not create a valid static XFA document as a result. All structures qualifying a document as a static XFA document will be removed. The resulting document will contain a pure Acroform and will not be recognized as a XFA form by applications for XFA creation/editing. Also, all extended access&#13;
     *                                 &lt;ul&gt;&lt;li&gt;and write permissions will be removed (That normally can expected to be found in a static XFA document).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRemoveStaticXFA() {
        if (removeStaticXFA == null) {
            return false;
        } else {
            return removeStaticXFA;
        }
    }

    /**
     * Sets the value of the removeStaticXFA property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isRemoveStaticXFA()
     */
    public void setRemoveStaticXFA(boolean value) {
        this.removeStaticXFA = value;
    }

    public boolean isSetRemoveStaticXFA() {
        return (this.removeStaticXFA!= null);
    }

    public void unsetRemoveStaticXFA() {
        this.removeStaticXFA = null;
    }

}
