
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the mode used to merge the PDF documents. The PDF document passed with the "data" element will be appended to the current PDF document or inserted at a specific point.&#13;
 *                     The following modes define the position where the documents will be inserted. Instead of a single base document, the "portfolio" mode always expects a ZIP archive. The elements in this archive will be added, all with identical permissions, to the resulting portfolio (the data element is not required at all for "portfolio").&#13;
 *                     &lt;ul&gt;&lt;li&gt;atTheEnd = At the end of the PDF document&lt;/li&gt;&lt;li&gt;atTheBeginning = At the beginning of the PDF document&lt;/li&gt;&lt;li&gt;afterPage = After a page (please refer to the "page" attribute) in the PDF document&lt;/li&gt;&lt;li&gt;beforePage = Before a page (please refer to the "page" attribute) in the PDF document&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for MergeModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="MergeModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="atTheEnd"/>
 *     <enumeration value="atTheBeginning"/>
 *     <enumeration value="afterPage"/>
 *     <enumeration value="beforePage"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "MergeModeType")
@XmlEnum
public enum MergeModeType {

    @XmlEnumValue("atTheEnd")
    AT_THE_END("atTheEnd"),
    @XmlEnumValue("atTheBeginning")
    AT_THE_BEGINNING("atTheBeginning"),
    @XmlEnumValue("afterPage")
    AFTER_PAGE("afterPage"),
    @XmlEnumValue("beforePage")
    BEFORE_PAGE("beforePage");
    private final String value;

    MergeModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static MergeModeType fromValue(String v) {
        for (MergeModeType c: MergeModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
