
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import net.webpdf.wsclient.schema.FileDataType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Contains the BASE64 encoded file that should be inserted or appended. The "format" attribute is used to define whether the file is a single PDF document, a ZIP file containing multiple PDF documents or a list of documents references by ID.&#13;
 * &#13;
 *                     If a ZIP archive is passed as the source document of the web service request, this parameter can be omitted. The parameter "sourceIsZip" must be set to "true" in that case.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for MergeFileDataType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="MergeFileDataType">
 *   <simpleContent>
 *     <extension base="<http://www.w3.org/2001/XMLSchema>base64Binary">
 *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}FileDataGroup"/>
 *       <attribute name="format" default="pdf">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}FileDataFormatType">
 *             <enumeration value="id"/>
 *             <enumeration value="pdf"/>
 *             <enumeration value="zip"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="outlineName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </extension>
 *   </simpleContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MergeFileDataType", propOrder = {
    "value"
})
public class MergeFileDataType
    implements FileDataType<byte[]>
{

    @XmlValue
    protected byte[] value;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the format used to pass the documents to be used for merging.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;pdf = A single PDF file&lt;/li&gt;&lt;li&gt;zip = It is a ZIP file that contains one or more PDF documents.&lt;/li&gt;&lt;li&gt;id = It is a semicolon separated list of document ID's referencing documents already on the server (REST API only).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 The "id" parameter can be used only with REST API. Each document that has been uploaded to the server via REST API has a unique ID. This ID can be used to reference the document. In the content of the "data" element, the list is passed as BASE64 content.&#13;
     *                                 Example for two documents:&lt;ul&gt;&lt;li&gt;List of documents: 3bde686a47284a2da3bfce62bd6bb8bd;f5c2b314d0c74fd0878d1f4ca310b0ad&lt;/li&gt;&lt;li&gt;BASE64 encoded: M2JkZTY4NmE0NzI4NGEyZGEzYmZjZTYyYmQ2YmI4YmQ7ZjVjMmIzMTRkMGM3NGZkMDg3OGQxZjRjYTMxMGIwYWQ=&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "format")
    protected FileDataFormatType format;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the base path that should be used for outline nodes of the appended document. This parameter can contain a slash separated path and should ideally end with the name of the document ("A/B/filename"). If this parameter is not set, all outlines will be appended to the root outline node.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "outlineName")
    protected String outlineName;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the data source for the hereby expressed resource.&#13;
     *                         Possible values are:&#13;
     *                         &lt;ul&gt;&lt;li&gt;value = The element's value shall contain the BASE64 encoded data.&lt;/li&gt;&lt;li&gt;uri = The data shall be located at the given uri.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "source")
    protected FileDataSourceType source;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The uri the data shall be located at. (This shall only have effect, if the "source" is "uri".)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "uri")
    @XmlSchemaType(name = "anyURI")
    protected String uri;

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setValue(byte[] value) {
        this.value = value;
    }

    public boolean isSetValue() {
        return (this.value!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the format used to pass the documents to be used for merging.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;pdf = A single PDF file&lt;/li&gt;&lt;li&gt;zip = It is a ZIP file that contains one or more PDF documents.&lt;/li&gt;&lt;li&gt;id = It is a semicolon separated list of document ID's referencing documents already on the server (REST API only).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 The "id" parameter can be used only with REST API. Each document that has been uploaded to the server via REST API has a unique ID. This ID can be used to reference the document. In the content of the "data" element, the list is passed as BASE64 content.&#13;
     *                                 Example for two documents:&lt;ul&gt;&lt;li&gt;List of documents: 3bde686a47284a2da3bfce62bd6bb8bd;f5c2b314d0c74fd0878d1f4ca310b0ad&lt;/li&gt;&lt;li&gt;BASE64 encoded: M2JkZTY4NmE0NzI4NGEyZGEzYmZjZTYyYmQ2YmI4YmQ7ZjVjMmIzMTRkMGM3NGZkMDg3OGQxZjRjYTMxMGIwYWQ=&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link FileDataFormatType }
     *     
     */
    public FileDataFormatType getFormat() {
        if (format == null) {
            return FileDataFormatType.PDF;
        } else {
            return format;
        }
    }

    /**
     * Sets the value of the format property.
     * 
     * @param value
     *     allowed object is
     *     {@link FileDataFormatType }
     *     
     * @see #getFormat()
     */
    public void setFormat(FileDataFormatType value) {
        this.format = value;
    }

    public boolean isSetFormat() {
        return (this.format!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p375802_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832464_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the base path that should be used for outline nodes of the appended document. This parameter can contain a slash separated path and should ideally end with the name of the document ("A/B/filename"). If this parameter is not set, all outlines will be appended to the root outline node.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOutlineName() {
        if (outlineName == null) {
            return "";
        } else {
            return outlineName;
        }
    }

    /**
     * Sets the value of the outlineName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getOutlineName()
     */
    public void setOutlineName(String value) {
        this.outlineName = value;
    }

    public boolean isSetOutlineName() {
        return (this.outlineName!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the data source for the hereby expressed resource.&#13;
     *                         Possible values are:&#13;
     *                         &lt;ul&gt;&lt;li&gt;value = The element's value shall contain the BASE64 encoded data.&lt;/li&gt;&lt;li&gt;uri = The data shall be located at the given uri.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link FileDataSourceType }
     *     
     */
    public FileDataSourceType getSource() {
        if (source == null) {
            return FileDataSourceType.VALUE;
        } else {
            return source;
        }
    }

    /**
     * Sets the value of the source property.
     * 
     * @param value
     *     allowed object is
     *     {@link FileDataSourceType }
     *     
     * @see #getSource()
     */
    public void setSource(FileDataSourceType value) {
        this.source = value;
    }

    public boolean isSetSource() {
        return (this.source!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The uri the data shall be located at. (This shall only have effect, if the "source" is "uri".)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUri() {
        if (uri == null) {
            return "";
        } else {
            return uri;
        }
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUri()
     */
    public void setUri(String value) {
        this.uri = value;
    }

    public boolean isSetUri() {
        return (this.uri!= null);
    }

}
