
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the type of markup. The following values are available:&#13;
 *                     &lt;ul&gt;&lt;li&gt;highlight = Highlights text&lt;/li&gt;&lt;li&gt;underline = Underlines text with a straight line&lt;/li&gt;&lt;li&gt;strikeOut = Strikes text through&lt;/li&gt;&lt;li&gt;squiggly = Underlines text with a squiggly line&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for MarkupsAnnotationType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="MarkupsAnnotationType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="highlight"/>
 *     <enumeration value="underline"/>
 *     <enumeration value="strikeOut"/>
 *     <enumeration value="squiggly"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "MarkupsAnnotationType")
@XmlEnum
public enum MarkupsAnnotationType {

    @XmlEnumValue("highlight")
    HIGHLIGHT("highlight"),
    @XmlEnumValue("underline")
    UNDERLINE("underline"),
    @XmlEnumValue("strikeOut")
    STRIKE_OUT("strikeOut"),
    @XmlEnumValue("squiggly")
    SQUIGGLY("squiggly");
    private final String value;

    MarkupsAnnotationType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static MarkupsAnnotationType fromValue(String v) {
        for (MarkupsAnnotationType c: MarkupsAnnotationType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
