
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p490833_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p603985_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p985611_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the zoom settings according to a defined mode.&#13;
 *                     &lt;ul&gt;&lt;li&gt;none = Uses the application's default view&lt;/li&gt;&lt;li&gt;fitWidth = Page width&lt;/li&gt;&lt;li&gt;fitPage = Page dimensions&lt;/li&gt;&lt;li&gt;fitHeight = Page height&lt;/li&gt;&lt;li&gt;fitVisible = Page content width&lt;/li&gt;&lt;li&gt;fitActual = Uses the original page dimensions (100% zoom factor)&lt;/li&gt;&lt;li&gt;zoom = Sets an explicit magnification value&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for MagnificationType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="MagnificationType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="fitWidth"/>
 *     <enumeration value="fitVisible"/>
 *     <enumeration value="fitHeight"/>
 *     <enumeration value="fitPage"/>
 *     <enumeration value="fitActual"/>
 *     <enumeration value="zoom"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "MagnificationType")
@XmlEnum
public enum MagnificationType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("fitWidth")
    FIT_WIDTH("fitWidth"),
    @XmlEnumValue("fitVisible")
    FIT_VISIBLE("fitVisible"),
    @XmlEnumValue("fitHeight")
    FIT_HEIGHT("fitHeight"),
    @XmlEnumValue("fitPage")
    FIT_PAGE("fitPage"),
    @XmlEnumValue("fitActual")
    FIT_ACTUAL("fitActual"),
    @XmlEnumValue("zoom")
    ZOOM("zoom");
    private final String value;

    MagnificationType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static MagnificationType fromValue(String v) {
        for (MagnificationType c: MagnificationType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
