
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify additional arguments for running an application and selecting the file in a platform-specific way (as of this writing, operating systems other than Microsoft Windows are not supported when it comes to passing these arguments).&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for LaunchParameterType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="LaunchParameterType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <choice>
 *         <element name="windows">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="fileName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                 <attribute name="directory" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                 <attribute name="operation" type="{http://schema.webpdf.de/1.0/operation}ApplicationOperationType" default="open" />
 *                 <attribute name="arguments" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </choice>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LaunchParameterType", propOrder = {
    "windows"
})
public class LaunchParameterType {

    protected LaunchParameterType.Windows windows;

    /**
     * Gets the value of the windows property.
     * 
     * @return
     *     possible object is
     *     {@link LaunchParameterType.Windows }
     *     
     */
    public LaunchParameterType.Windows getWindows() {
        return windows;
    }

    /**
     * Sets the value of the windows property.
     * 
     * @param value
     *     allowed object is
     *     {@link LaunchParameterType.Windows }
     *     
     */
    public void setWindows(LaunchParameterType.Windows value) {
        this.windows = value;
    }

    public boolean isSetWindows() {
        return (this.windows!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="fileName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *       <attribute name="directory" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *       <attribute name="operation" type="{http://schema.webpdf.de/1.0/operation}ApplicationOperationType" default="open" />
     *       <attribute name="arguments" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Windows {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A Windows filename using the standard Windows path syntax. If there is a backslash in the specified path, it must be escaped by preceding it with another backslash.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "fileName")
        protected String fileName;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the basic path, using standard DOS syntax, from which navigation will take place.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "directory")
        protected String directory;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the standard operation that should be carried out with the specified document.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;open = Open the document.&lt;/li&gt;&lt;li&gt;print = Print the document.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "operation")
        protected ApplicationOperationType operation;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The arguments that should be passed to the application when making a call.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "arguments")
        protected String arguments;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A Windows filename using the standard Windows path syntax. If there is a backslash in the specified path, it must be escaped by preceding it with another backslash.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getFileName() {
            if (fileName == null) {
                return "";
            } else {
                return fileName;
            }
        }

        /**
         * Sets the value of the fileName property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getFileName()
         */
        public void setFileName(String value) {
            this.fileName = value;
        }

        public boolean isSetFileName() {
            return (this.fileName!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the basic path, using standard DOS syntax, from which navigation will take place.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getDirectory() {
            if (directory == null) {
                return "";
            } else {
                return directory;
            }
        }

        /**
         * Sets the value of the directory property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getDirectory()
         */
        public void setDirectory(String value) {
            this.directory = value;
        }

        public boolean isSetDirectory() {
            return (this.directory!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the standard operation that should be carried out with the specified document.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;open = Open the document.&lt;/li&gt;&lt;li&gt;print = Print the document.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link ApplicationOperationType }
         *     
         */
        public ApplicationOperationType getOperation() {
            if (operation == null) {
                return ApplicationOperationType.OPEN;
            } else {
                return operation;
            }
        }

        /**
         * Sets the value of the operation property.
         * 
         * @param value
         *     allowed object is
         *     {@link ApplicationOperationType }
         *     
         * @see #getOperation()
         */
        public void setOperation(ApplicationOperationType value) {
            this.operation = value;
        }

        public boolean isSetOperation() {
            return (this.operation!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The arguments that should be passed to the application when making a call.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getArguments() {
            if (arguments == null) {
                return "";
            } else {
                return arguments;
            }
        }

        /**
         * Sets the value of the arguments property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getArguments()
         */
        public void setArguments(String value) {
            this.arguments = value;
        }

        public boolean isSetArguments() {
            return (this.arguments!= null);
        }

    }

}
