
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify all the properties you want for a content structure entry that is to be created, including the actions it will trigger.&#13;
 *                     An entry can contain any number of the specified subelements you want in the order you want them. All subelements represent a type of action that will be triggered when the entry is clicked on and that will be executed in succession.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ItemType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ItemType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ItemReferenceType">
 *       <choice maxOccurs="unbounded" minOccurs="0">
 *         <element name="goTo" type="{http://schema.webpdf.de/1.0/operation}GoToDestinationActionType"/>
 *         <element name="launchApplication" type="{http://schema.webpdf.de/1.0/operation}LaunchApplicationActionType"/>
 *         <element name="resolveURI" type="{http://schema.webpdf.de/1.0/operation}URIActionType"/>
 *         <element name="playSound" type="{http://schema.webpdf.de/1.0/operation}SoundActionType"/>
 *         <element name="hideAnnotation" type="{http://schema.webpdf.de/1.0/operation}HideActionType"/>
 *         <element name="executeNamed" type="{http://schema.webpdf.de/1.0/operation}NamedActionType"/>
 *         <element name="submitForm" type="{http://schema.webpdf.de/1.0/operation}SubmitFormActionType"/>
 *         <element name="resetForm" type="{http://schema.webpdf.de/1.0/operation}ResetFormActionType"/>
 *         <element name="importSchema" type="{http://schema.webpdf.de/1.0/operation}ImportDataActionType"/>
 *         <element name="executeJavaScript" type="{http://schema.webpdf.de/1.0/operation}JavaScriptActionType"/>
 *         <element name="setLayerState" type="{http://schema.webpdf.de/1.0/operation}SetOCGStateActionType"/>
 *         <element name="setTransition" type="{http://schema.webpdf.de/1.0/operation}TransitionActionType"/>
 *         <element name="goTo3DView" type="{http://schema.webpdf.de/1.0/operation}GoTo3DViewActionType"/>
 *         <element name="goToThread" type="{http://schema.webpdf.de/1.0/operation}ThreadActionType"/>
 *       </choice>
 *       <attribute name="isOpen" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="italic" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="bold" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="color" type="{http://schema.webpdf.de/1.0/operation}RgbColorType" default="#000000" />
 *       <attribute name="pathPosition" type="{http://schema.webpdf.de/1.0/operation}AddPositionType" default="inplace" />
 *       <attribute name="itemName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ItemType", propOrder = {
    "actions"
})
public class ItemType
    extends ItemReferenceType
{

    @XmlElements({
        @XmlElement(name = "goTo", type = GoToDestinationActionType.class),
        @XmlElement(name = "launchApplication", type = LaunchApplicationActionType.class),
        @XmlElement(name = "resolveURI", type = URIActionType.class),
        @XmlElement(name = "playSound", type = SoundActionType.class),
        @XmlElement(name = "hideAnnotation", type = HideActionType.class),
        @XmlElement(name = "executeNamed", type = NamedActionType.class),
        @XmlElement(name = "submitForm", type = SubmitFormActionType.class),
        @XmlElement(name = "resetForm", type = ResetFormActionType.class),
        @XmlElement(name = "importSchema", type = ImportDataActionType.class),
        @XmlElement(name = "executeJavaScript", type = JavaScriptActionType.class),
        @XmlElement(name = "setLayerState", type = SetOCGStateActionType.class),
        @XmlElement(name = "setTransition", type = TransitionActionType.class),
        @XmlElement(name = "goTo3DView", type = GoTo3DViewActionType.class),
        @XmlElement(name = "goToThread", type = ThreadActionType.class)
    })
    protected List<ActionEventType> actions;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the element will already be expanded when the document is opened.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "isOpen")
    protected Boolean isOpen;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the element's name will be shown in italics.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "italic")
    protected Boolean italic;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the element's name will be shown in bold.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "bold")
    protected Boolean bold;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the colour that will be used to display the element's name. The hereby defined color needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "color")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String color;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the position where the entry should be created. The path passed in "path" will be interpreted based on this value.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;before = An entry will be generated on the same level before the entry that was selected with "path.&lt;/li&gt;&lt;li&gt;inplace = The entry selected with "path" will be treated as a parent element and will contain the new generated entry.&lt;/li&gt;&lt;li&gt;after = An entry will be generated on the same level after the entry that was selected with "path.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pathPosition")
    protected AddPositionType pathPosition;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The name of the new entry in the content structure that should be placed relative to the selected path.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "itemName")
    protected String itemName;

    /**
     * Gets the value of the actions property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the actions property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getActions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GoTo3DViewActionType }
     * {@link GoToDestinationActionType }
     * {@link HideActionType }
     * {@link ImportDataActionType }
     * {@link JavaScriptActionType }
     * {@link LaunchApplicationActionType }
     * {@link NamedActionType }
     * {@link ResetFormActionType }
     * {@link SetOCGStateActionType }
     * {@link SoundActionType }
     * {@link SubmitFormActionType }
     * {@link ThreadActionType }
     * {@link TransitionActionType }
     * {@link URIActionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the actions property.
     */
    public List<ActionEventType> getActions() {
        if (actions == null) {
            actions = new ArrayList<>();
        }
        return this.actions;
    }

    public boolean isSetActions() {
        return ((this.actions!= null)&&(!this.actions.isEmpty()));
    }

    public void unsetActions() {
        this.actions = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the element will already be expanded when the document is opened.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isIsOpen() {
        if (isOpen == null) {
            return false;
        } else {
            return isOpen;
        }
    }

    /**
     * Sets the value of the isOpen property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isIsOpen()
     */
    public void setIsOpen(boolean value) {
        this.isOpen = value;
    }

    public boolean isSetIsOpen() {
        return (this.isOpen!= null);
    }

    public void unsetIsOpen() {
        this.isOpen = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the element's name will be shown in italics.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isItalic() {
        if (italic == null) {
            return false;
        } else {
            return italic;
        }
    }

    /**
     * Sets the value of the italic property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isItalic()
     */
    public void setItalic(boolean value) {
        this.italic = value;
    }

    public boolean isSetItalic() {
        return (this.italic!= null);
    }

    public void unsetItalic() {
        this.italic = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the element's name will be shown in bold.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isBold() {
        if (bold == null) {
            return false;
        } else {
            return bold;
        }
    }

    /**
     * Sets the value of the bold property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isBold()
     */
    public void setBold(boolean value) {
        this.bold = value;
    }

    public boolean isSetBold() {
        return (this.bold!= null);
    }

    public void unsetBold() {
        this.bold = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the colour that will be used to display the element's name. The hereby defined color needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getColor() {
        if (color == null) {
            return "#000000";
        } else {
            return color;
        }
    }

    /**
     * Sets the value of the color property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getColor()
     */
    public void setColor(String value) {
        this.color = value;
    }

    public boolean isSetColor() {
        return (this.color!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the position where the entry should be created. The path passed in "path" will be interpreted based on this value.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;before = An entry will be generated on the same level before the entry that was selected with "path.&lt;/li&gt;&lt;li&gt;inplace = The entry selected with "path" will be treated as a parent element and will contain the new generated entry.&lt;/li&gt;&lt;li&gt;after = An entry will be generated on the same level after the entry that was selected with "path.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link AddPositionType }
     *     
     */
    public AddPositionType getPathPosition() {
        if (pathPosition == null) {
            return AddPositionType.INPLACE;
        } else {
            return pathPosition;
        }
    }

    /**
     * Sets the value of the pathPosition property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddPositionType }
     *     
     * @see #getPathPosition()
     */
    public void setPathPosition(AddPositionType value) {
        this.pathPosition = value;
    }

    public boolean isSetPathPosition() {
        return (this.pathPosition!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The name of the new entry in the content structure that should be placed relative to the selected path.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getItemName() {
        if (itemName == null) {
            return "";
        } else {
            return itemName;
        }
    }

    /**
     * Sets the value of the itemName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getItemName()
     */
    public void setItemName(String value) {
        this.itemName = value;
    }

    public boolean isSetItemName() {
        return (this.itemName!= null);
    }

}
