
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The fitHeight element is used to specify a location within the document. It will jump to a page in the document and set a zoom factor that will ensure that the entire page height is displayed.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for FitHeightDestinationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="FitHeightDestinationType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}DestinationEventType">
 *       <attribute name="page" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="leftOffset" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="metrics" type="{http://schema.webpdf.de/1.0/operation}MetricsType" default="px" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FitHeightDestinationType")
public class FitHeightDestinationType
    extends DestinationEventType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The document page to which the jump will be.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "page")
    protected Integer page;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The area's offset from the left page margin.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "leftOffset")
    protected Integer leftOffset;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the unit in which the maximum dimensions are specified.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;pt = Points(1/72 inch)&lt;/li&gt;&lt;li&gt;pc = Picas(12 points)&lt;/li&gt;&lt;li&gt;px = Pixels(1/96 inch)&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "metrics")
    protected MetricsType metrics;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The document page to which the jump will be.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  1;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getPage()
     */
    public void setPage(int value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    public void unsetPage() {
        this.page = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The area's offset from the left page margin.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getLeftOffset() {
        if (leftOffset == null) {
            return  0;
        } else {
            return leftOffset;
        }
    }

    /**
     * Sets the value of the leftOffset property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getLeftOffset()
     */
    public void setLeftOffset(int value) {
        this.leftOffset = value;
    }

    public boolean isSetLeftOffset() {
        return (this.leftOffset!= null);
    }

    public void unsetLeftOffset() {
        this.leftOffset = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the unit in which the maximum dimensions are specified.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;pt = Points(1/72 inch)&lt;/li&gt;&lt;li&gt;pc = Picas(12 points)&lt;/li&gt;&lt;li&gt;px = Pixels(1/96 inch)&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link MetricsType }
     *     
     */
    public MetricsType getMetrics() {
        if (metrics == null) {
            return MetricsType.PX;
        } else {
            return metrics;
        }
    }

    /**
     * Sets the value of the metrics property.
     * 
     * @param value
     *     allowed object is
     *     {@link MetricsType }
     *     
     * @see #getMetrics()
     */
    public void setMetrics(MetricsType value) {
        this.metrics = value;
    }

    public boolean isSetMetrics() {
        return (this.metrics!= null);
    }

}
