
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import net.webpdf.wsclient.schema.AccessPermissionType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;These parameters can be used to set encryption for a PDF document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for EncryptType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="EncryptType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <choice>
 *         <element name="password" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="encryptionKey" type="{http://schema.webpdf.de/1.0/operation}PdfEncryptionKeyType" default="RC4_128" />
 *                 <attribute name="permission" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                 <attribute name="open" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </choice>
 *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}securityFlags"/>
 *       <attribute name="contentEncryption" type="{http://schema.webpdf.de/1.0/operation}PdfContentEncryptionType" default="encryptEverything" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "EncryptType", propOrder = {
    "password"
})
public class EncryptType
    implements AccessPermissionType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the password for encryption and the encryption key length.&lt;/p&gt;
     * </pre>
     * 
     */
    protected EncryptType.Password password;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies whether certain contents should be treated differently than others during encryption.&#13;
     *                         &lt;ul&gt;&lt;li&gt;encryptEverything = All contents of the document are encrypted without distinction (if provided by the standard).&lt;/li&gt;&lt;li&gt;exposeMetadata = The document's metadata is left unencrypted to make it discoverable by processing programs. (Has an effect only for 128 bit and 256 bit AES).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "contentEncryption")
    protected PdfContentEncryptionType contentEncryption;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be rearranged (e.g., pages can be deleted, inserted, and rotated).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canAssemble")
    protected Boolean canAssemble;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," content can be extracted (copied) from the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canExtractContent")
    protected Boolean canExtractContent;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," content can be extracted (copied) for accessibility purposes.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canExtractForAccessibility")
    protected Boolean canExtractForAccessibility;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," form fields can be filled out and the document can be signed.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canFillInForm")
    protected Boolean canFillInForm;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," changes to the document are permitted.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canModify")
    protected Boolean canModify;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," comments can be added to the document and deleted from the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canModifyAnnotations")
    protected Boolean canModifyAnnotations;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be printed.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canPrint")
    protected Boolean canPrint;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be printed at high resolution levels.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canPrintHighRes")
    protected Boolean canPrintHighRes;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the password for encryption and the encryption key length.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link EncryptType.Password }
     *     
     */
    public EncryptType.Password getPassword() {
        return password;
    }

    /**
     * Sets the value of the password property.
     * 
     * @param value
     *     allowed object is
     *     {@link EncryptType.Password }
     *     
     * @see #getPassword()
     */
    public void setPassword(EncryptType.Password value) {
        this.password = value;
    }

    public boolean isSetPassword() {
        return (this.password!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies whether certain contents should be treated differently than others during encryption.&#13;
     *                         &lt;ul&gt;&lt;li&gt;encryptEverything = All contents of the document are encrypted without distinction (if provided by the standard).&lt;/li&gt;&lt;li&gt;exposeMetadata = The document's metadata is left unencrypted to make it discoverable by processing programs. (Has an effect only for 128 bit and 256 bit AES).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PdfContentEncryptionType }
     *     
     */
    public PdfContentEncryptionType getContentEncryption() {
        if (contentEncryption == null) {
            return PdfContentEncryptionType.ENCRYPT_EVERYTHING;
        } else {
            return contentEncryption;
        }
    }

    /**
     * Sets the value of the contentEncryption property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfContentEncryptionType }
     *     
     * @see #getContentEncryption()
     */
    public void setContentEncryption(PdfContentEncryptionType value) {
        this.contentEncryption = value;
    }

    public boolean isSetContentEncryption() {
        return (this.contentEncryption!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be rearranged (e.g., pages can be deleted, inserted, and rotated).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanAssemble() {
        if (canAssemble == null) {
            return false;
        } else {
            return canAssemble;
        }
    }

    /**
     * Sets the value of the canAssemble property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanAssemble()
     */
    public void setCanAssemble(boolean value) {
        this.canAssemble = value;
    }

    public boolean isSetCanAssemble() {
        return (this.canAssemble!= null);
    }

    public void unsetCanAssemble() {
        this.canAssemble = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," content can be extracted (copied) from the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanExtractContent() {
        if (canExtractContent == null) {
            return false;
        } else {
            return canExtractContent;
        }
    }

    /**
     * Sets the value of the canExtractContent property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanExtractContent()
     */
    public void setCanExtractContent(boolean value) {
        this.canExtractContent = value;
    }

    public boolean isSetCanExtractContent() {
        return (this.canExtractContent!= null);
    }

    public void unsetCanExtractContent() {
        this.canExtractContent = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," content can be extracted (copied) for accessibility purposes.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanExtractForAccessibility() {
        if (canExtractForAccessibility == null) {
            return false;
        } else {
            return canExtractForAccessibility;
        }
    }

    /**
     * Sets the value of the canExtractForAccessibility property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanExtractForAccessibility()
     */
    public void setCanExtractForAccessibility(boolean value) {
        this.canExtractForAccessibility = value;
    }

    public boolean isSetCanExtractForAccessibility() {
        return (this.canExtractForAccessibility!= null);
    }

    public void unsetCanExtractForAccessibility() {
        this.canExtractForAccessibility = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," form fields can be filled out and the document can be signed.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanFillInForm() {
        if (canFillInForm == null) {
            return false;
        } else {
            return canFillInForm;
        }
    }

    /**
     * Sets the value of the canFillInForm property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanFillInForm()
     */
    public void setCanFillInForm(boolean value) {
        this.canFillInForm = value;
    }

    public boolean isSetCanFillInForm() {
        return (this.canFillInForm!= null);
    }

    public void unsetCanFillInForm() {
        this.canFillInForm = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," changes to the document are permitted.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanModify() {
        if (canModify == null) {
            return false;
        } else {
            return canModify;
        }
    }

    /**
     * Sets the value of the canModify property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanModify()
     */
    public void setCanModify(boolean value) {
        this.canModify = value;
    }

    public boolean isSetCanModify() {
        return (this.canModify!= null);
    }

    public void unsetCanModify() {
        this.canModify = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," comments can be added to the document and deleted from the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanModifyAnnotations() {
        if (canModifyAnnotations == null) {
            return false;
        } else {
            return canModifyAnnotations;
        }
    }

    /**
     * Sets the value of the canModifyAnnotations property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanModifyAnnotations()
     */
    public void setCanModifyAnnotations(boolean value) {
        this.canModifyAnnotations = value;
    }

    public boolean isSetCanModifyAnnotations() {
        return (this.canModifyAnnotations!= null);
    }

    public void unsetCanModifyAnnotations() {
        this.canModifyAnnotations = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be printed.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanPrint() {
        if (canPrint == null) {
            return false;
        } else {
            return canPrint;
        }
    }

    /**
     * Sets the value of the canPrint property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanPrint()
     */
    public void setCanPrint(boolean value) {
        this.canPrint = value;
    }

    public boolean isSetCanPrint() {
        return (this.canPrint!= null);
    }

    public void unsetCanPrint() {
        this.canPrint = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be printed at high resolution levels.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanPrintHighRes() {
        if (canPrintHighRes == null) {
            return false;
        } else {
            return canPrintHighRes;
        }
    }

    /**
     * Sets the value of the canPrintHighRes property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanPrintHighRes()
     */
    public void setCanPrintHighRes(boolean value) {
        this.canPrintHighRes = value;
    }

    public boolean isSetCanPrintHighRes() {
        return (this.canPrintHighRes!= null);
    }

    public void unsetCanPrintHighRes() {
        this.canPrintHighRes = null;
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="encryptionKey" type="{http://schema.webpdf.de/1.0/operation}PdfEncryptionKeyType" default="RC4_128" />
     *       <attribute name="permission" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *       <attribute name="open" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Password {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the encryption level for the document.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;RC4_40 = 40-bit RC4&lt;/li&gt;&lt;li&gt;RC4_128 = 128-bit RC4&lt;/li&gt;&lt;li&gt;AES_128 = 128-bit AES&lt;/li&gt;&lt;li&gt;AES_256 = 256-bit AES&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
         *                                     Please note that the option "256-bit AES" only works if the "Java Cryptography Extension (JCE)" has been enabled with "Unlimited Strength" in the JVM. You can obtain the modified "Policy Files" (along with instructions for installation) from the Oracle website:&#13;
         *                                     Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files 7 Download:&#13;
         *                                     http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "encryptionKey")
        protected PdfEncryptionKeyType encryptionKey;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the password that will be requested if the file is opened for editing (e.g., when removing pages). The password is required to enable the individual access permissions and must not be blank if the access permissions are to be used.&#13;
         * &#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
         *                                     Please note that the password and the associated access permissions will only provide protection if an appropriate display program for PDF documents takes these settings into account.&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "permission")
        protected String permission;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the password that will be requested if the PDF document is opened for reading.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "open")
        protected String open;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the encryption level for the document.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;RC4_40 = 40-bit RC4&lt;/li&gt;&lt;li&gt;RC4_128 = 128-bit RC4&lt;/li&gt;&lt;li&gt;AES_128 = 128-bit AES&lt;/li&gt;&lt;li&gt;AES_256 = 256-bit AES&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
         *                                     Please note that the option "256-bit AES" only works if the "Java Cryptography Extension (JCE)" has been enabled with "Unlimited Strength" in the JVM. You can obtain the modified "Policy Files" (along with instructions for installation) from the Oracle website:&#13;
         *                                     Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files 7 Download:&#13;
         *                                     http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link PdfEncryptionKeyType }
         *     
         */
        public PdfEncryptionKeyType getEncryptionKey() {
            if (encryptionKey == null) {
                return PdfEncryptionKeyType.RC_4_128;
            } else {
                return encryptionKey;
            }
        }

        /**
         * Sets the value of the encryptionKey property.
         * 
         * @param value
         *     allowed object is
         *     {@link PdfEncryptionKeyType }
         *     
         * @see #getEncryptionKey()
         */
        public void setEncryptionKey(PdfEncryptionKeyType value) {
            this.encryptionKey = value;
        }

        public boolean isSetEncryptionKey() {
            return (this.encryptionKey!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the password that will be requested if the file is opened for editing (e.g., when removing pages). The password is required to enable the individual access permissions and must not be blank if the access permissions are to be used.&#13;
         * &#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
         *                                     Please note that the password and the associated access permissions will only provide protection if an appropriate display program for PDF documents takes these settings into account.&#13;
         *                                 &lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getPermission() {
            if (permission == null) {
                return "";
            } else {
                return permission;
            }
        }

        /**
         * Sets the value of the permission property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getPermission()
         */
        public void setPermission(String value) {
            this.permission = value;
        }

        public boolean isSetPermission() {
            return (this.permission!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p881634_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p918570_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the password that will be requested if the PDF document is opened for reading.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getOpen() {
            if (open == null) {
                return "";
            } else {
                return open;
            }
        }

        /**
         * Sets the value of the open property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getOpen()
         */
        public void setOpen(String value) {
            this.open = value;
        }

        public boolean isSetOpen() {
            return (this.open!= null);
        }

    }

}
