
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If you add another (optional) &lt;code&gt;&amp;lt;custom .../&amp;gt;&lt;/code&gt; element to the description element, you can use it to store your own values in the PDF description. The element can occur multiple times and defines an additional entry for the description.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for DescriptionCustomType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="DescriptionCustomType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="key" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="value" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="remove" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DescriptionCustomType")
public class DescriptionCustomType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Describes the name of the field to be added to the PDF description. The value must not be empty, must be unique, and must not conflict with the other (default) field names (e.g. "Subject"). If a name conflict occurs, the entry will be skipped and not entered.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "key")
    protected String key;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Describes the value to be stored in the PDF description.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "value")
    protected String value;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then the field is not added but removed. In this case "value" has no meaning. If the field is not present, then the entry is skipped.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "remove")
    protected Boolean remove;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Describes the name of the field to be added to the PDF description. The value must not be empty, must be unique, and must not conflict with the other (default) field names (e.g. "Subject"). If a name conflict occurs, the entry will be skipped and not entered.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getKey() {
        if (key == null) {
            return "";
        } else {
            return key;
        }
    }

    /**
     * Sets the value of the key property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getKey()
     */
    public void setKey(String value) {
        this.key = value;
    }

    public boolean isSetKey() {
        return (this.key!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Describes the value to be stored in the PDF description.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        if (value == null) {
            return "";
        } else {
            return value;
        }
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getValue()
     */
    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSetValue() {
        return (this.value!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then the field is not added but removed. In this case "value" has no meaning. If the field is not present, then the entry is skipped.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRemove() {
        if (remove == null) {
            return false;
        } else {
            return remove;
        }
    }

    /**
     * Sets the value of the remove property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isRemove()
     */
    public void setRemove(boolean value) {
        this.remove = value;
    }

    public boolean isSetRemove() {
        return (this.remove!= null);
    }

    public void unsetRemove() {
        this.remove = null;
    }

}
