
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to force a specific shape for generated Data Matrix codes.&#13;
 *                     &lt;ul&gt;&lt;li&gt;default = Select an appropriate shape.&lt;/li&gt;&lt;li&gt;rectangle = Force a rectangular shape.&lt;/li&gt;&lt;li&gt;square = Force a square shape.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for DataMatrixShapeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="DataMatrixShapeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="default"/>
 *     <enumeration value="rectangle"/>
 *     <enumeration value="square"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "DataMatrixShapeType")
@XmlEnum
public enum DataMatrixShapeType {

    @XmlEnumValue("default")
    DEFAULT("default"),
    @XmlEnumValue("rectangle")
    RECTANGLE("rectangle"),
    @XmlEnumValue("square")
    SQUARE("square");
    private final String value;

    DataMatrixShapeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static DataMatrixShapeType fromValue(String v) {
        for (DataMatrixShapeType c: DataMatrixShapeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
