
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A DataMatrix barcode.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for DataMatrixBarcodeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="DataMatrixBarcodeType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseBarcodeType">
 *       <attribute name="errorCorrection" default="2">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *             <maxInclusive value="8"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="shape" type="{http://schema.webpdf.de/1.0/operation}DataMatrixShapeType" default="default" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DataMatrixBarcodeType")
public class DataMatrixBarcodeType
    extends BaseBarcodeType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to adjust the error correction level for generated Data Matrix codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable. A level of 1 to 8 can be specified.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "errorCorrection")
    protected Integer errorCorrection;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to force a specific shape for generated Data Matrix codes.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;default = Select an appropriate shape.&lt;/li&gt;&lt;li&gt;rectangle = Force a rectangular shape.&lt;/li&gt;&lt;li&gt;square = Force a square shape.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "shape")
    protected DataMatrixShapeType shape;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to adjust the error correction level for generated Data Matrix codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable. A level of 1 to 8 can be specified.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getErrorCorrection() {
        if (errorCorrection == null) {
            return  2;
        } else {
            return errorCorrection;
        }
    }

    /**
     * Sets the value of the errorCorrection property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getErrorCorrection()
     */
    public void setErrorCorrection(int value) {
        this.errorCorrection = value;
    }

    public boolean isSetErrorCorrection() {
        return (this.errorCorrection!= null);
    }

    public void unsetErrorCorrection() {
        this.errorCorrection = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to force a specific shape for generated Data Matrix codes.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;default = Select an appropriate shape.&lt;/li&gt;&lt;li&gt;rectangle = Force a rectangular shape.&lt;/li&gt;&lt;li&gt;square = Force a square shape.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link DataMatrixShapeType }
     *     
     */
    public DataMatrixShapeType getShape() {
        if (shape == null) {
            return DataMatrixShapeType.DEFAULT;
        } else {
            return shape;
        }
    }

    /**
     * Sets the value of the shape property.
     * 
     * @param value
     *     allowed object is
     *     {@link DataMatrixShapeType }
     *     
     * @see #getShape()
     */
    public void setShape(DataMatrixShapeType value) {
        this.shape = value;
    }

    public boolean isSetShape() {
        return (this.shape!= null);
    }

}
