
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to enable expanded error reporting for text-based documents (e.g., Word).&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ConverterReportType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ConverterReportType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="contentProblems" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="fontAliasUsage" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="fontIsMissing" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ConverterReportType")
public class ConverterReportType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then an error (ERR_CONVERTER_CONTENT_PROBLEMS) is triggered if a problem occurs with a content item during the conversion. The following are among the problems:&#13;
     *                         &lt;ul&gt;&lt;li&gt;Unicode resolution of characters is not possible&lt;/li&gt;&lt;li&gt;Vertical text elements&lt;/li&gt;&lt;li&gt;Unsupported text effects&lt;/li&gt;&lt;li&gt;Unsupported graphics compression&lt;/li&gt;&lt;li&gt;Unsupported colour space&lt;/li&gt;&lt;li&gt;Non-integrated sub-document that was not converted&lt;/li&gt;&lt;li&gt;Tables with a "right-to-left" alignment in the content&lt;/li&gt;&lt;li&gt;The document contains mathematical formulas&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "contentProblems")
    protected Boolean contentProblems;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then an error (ERR_CONVERTER_FONT_ALIAS_USED) is triggered if a font was not found during conversion and in its place a substitute (alias) font was used.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fontAliasUsage")
    protected Boolean fontAliasUsage;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then an error (ERR_CONVERTER_FONT_IS_MISSING) is triggered if a font was not found during conversion.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fontIsMissing")
    protected Boolean fontIsMissing;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then an error (ERR_CONVERTER_CONTENT_PROBLEMS) is triggered if a problem occurs with a content item during the conversion. The following are among the problems:&#13;
     *                         &lt;ul&gt;&lt;li&gt;Unicode resolution of characters is not possible&lt;/li&gt;&lt;li&gt;Vertical text elements&lt;/li&gt;&lt;li&gt;Unsupported text effects&lt;/li&gt;&lt;li&gt;Unsupported graphics compression&lt;/li&gt;&lt;li&gt;Unsupported colour space&lt;/li&gt;&lt;li&gt;Non-integrated sub-document that was not converted&lt;/li&gt;&lt;li&gt;Tables with a "right-to-left" alignment in the content&lt;/li&gt;&lt;li&gt;The document contains mathematical formulas&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isContentProblems() {
        if (contentProblems == null) {
            return false;
        } else {
            return contentProblems;
        }
    }

    /**
     * Sets the value of the contentProblems property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isContentProblems()
     */
    public void setContentProblems(boolean value) {
        this.contentProblems = value;
    }

    public boolean isSetContentProblems() {
        return (this.contentProblems!= null);
    }

    public void unsetContentProblems() {
        this.contentProblems = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then an error (ERR_CONVERTER_FONT_ALIAS_USED) is triggered if a font was not found during conversion and in its place a substitute (alias) font was used.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isFontAliasUsage() {
        if (fontAliasUsage == null) {
            return false;
        } else {
            return fontAliasUsage;
        }
    }

    /**
     * Sets the value of the fontAliasUsage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isFontAliasUsage()
     */
    public void setFontAliasUsage(boolean value) {
        this.fontAliasUsage = value;
    }

    public boolean isSetFontAliasUsage() {
        return (this.fontAliasUsage!= null);
    }

    public void unsetFontAliasUsage() {
        this.fontAliasUsage = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p165541_="https://jakarta.ee/xml/ns/jaxb" xmlns:p356920_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then an error (ERR_CONVERTER_FONT_IS_MISSING) is triggered if a font was not found during conversion.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isFontIsMissing() {
        if (fontIsMissing == null) {
            return false;
        } else {
            return fontIsMissing;
        }
    }

    /**
     * Sets the value of the fontIsMissing property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isFontIsMissing()
     */
    public void setFontIsMissing(boolean value) {
        this.fontIsMissing = value;
    }

    public boolean isSetFontIsMissing() {
        return (this.fontIsMissing!= null);
    }

    public void unsetFontIsMissing() {
        this.fontIsMissing = null;
    }

}
