
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import net.webpdf.wsclient.schema.ParameterInterface;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The &lt;code&gt;billing&lt;/code&gt; element can be used to affect the values that are written to the server's statistics logs (called "billing logs") for the web service call.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BillingType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BillingType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="customerCode" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="userName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="applicationName" type="{http://www.w3.org/2001/XMLSchema}string" default="external" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BillingType")
public class BillingType
    implements ParameterInterface
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A free text that identifies the customer calling the web service. This attribute makes it possible to analyze the logs with regard to specific customers, for example.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "customerCode")
    protected String customerCode;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A free text that specifies the name of the user calling the web service. This attribute makes it possible to analyze the logs with regard to specific users, for example.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         If the web service is called from the server's portal and a user is logged in, the user's name will be entered automatically.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "userName")
    protected String userName;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A free text that specifies the name of the application calling the web service. This attribute makes it possible to analyze the logs with regard to specific applications, for example.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         If the web service is called by an external application that does not set its own value for "applicationName", a value of "external" will be entered automatically. If the web service is called from the server's portal, a value of "portal" will be entered automatically.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "applicationName")
    protected String applicationName;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A free text that identifies the customer calling the web service. This attribute makes it possible to analyze the logs with regard to specific customers, for example.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCustomerCode() {
        if (customerCode == null) {
            return "";
        } else {
            return customerCode;
        }
    }

    /**
     * Sets the value of the customerCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCustomerCode()
     */
    public void setCustomerCode(String value) {
        this.customerCode = value;
    }

    public boolean isSetCustomerCode() {
        return (this.customerCode!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A free text that specifies the name of the user calling the web service. This attribute makes it possible to analyze the logs with regard to specific users, for example.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         If the web service is called from the server's portal and a user is logged in, the user's name will be entered automatically.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUserName() {
        if (userName == null) {
            return "";
        } else {
            return userName;
        }
    }

    /**
     * Sets the value of the userName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUserName()
     */
    public void setUserName(String value) {
        this.userName = value;
    }

    public boolean isSetUserName() {
        return (this.userName!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A free text that specifies the name of the application calling the web service. This attribute makes it possible to analyze the logs with regard to specific applications, for example.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p644063_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p831178_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         If the web service is called by an external application that does not set its own value for "applicationName", a value of "external" will be entered automatically. If the web service is called from the server's portal, a value of "portal" will be entered automatically.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getApplicationName() {
        if (applicationName == null) {
            return "external";
        } else {
            return applicationName;
        }
    }

    /**
     * Sets the value of the applicationName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getApplicationName()
     */
    public void setApplicationName(String value) {
        this.applicationName = value;
    }

    public boolean isSetApplicationName() {
        return (this.applicationName!= null);
    }

}
