
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A common base type for reply annotations.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BaseReplyType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BaseReplyType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="replyTo" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="creator" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="subject" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="page" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BaseReplyType")
@XmlSeeAlso({
    ReplyToAnnotationType.class,
    ReplyStateAnnotationType.class,
    MarkedStateAnnotationType.class
})
public class BaseReplyType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the object id of the annotation, that this annotation shall be a reply to. The object id shall be given as a String that may contain either:&#13;
     *                         &lt;ul&gt;&lt;li&gt;The numeric object ID itself&lt;/li&gt;&lt;li&gt;The object ID followed by the generation number, separated by a space&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "replyTo")
    protected String replyTo;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the author of the annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "creator")
    protected String creator;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the name of the annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "name")
    protected String name;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the subject of the annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "subject")
    protected String subject;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Set the number of the page, the annotation shall be placed on.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         A reply shall always be placed on the same page as it's target annotation. This is mostly providing a hint where to find the selected annotation.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "page")
    protected Integer page;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the object id of the annotation, that this annotation shall be a reply to. The object id shall be given as a String that may contain either:&#13;
     *                         &lt;ul&gt;&lt;li&gt;The numeric object ID itself&lt;/li&gt;&lt;li&gt;The object ID followed by the generation number, separated by a space&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getReplyTo() {
        if (replyTo == null) {
            return "";
        } else {
            return replyTo;
        }
    }

    /**
     * Sets the value of the replyTo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getReplyTo()
     */
    public void setReplyTo(String value) {
        this.replyTo = value;
    }

    public boolean isSetReplyTo() {
        return (this.replyTo!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the author of the annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCreator() {
        if (creator == null) {
            return "";
        } else {
            return creator;
        }
    }

    /**
     * Sets the value of the creator property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCreator()
     */
    public void setCreator(String value) {
        this.creator = value;
    }

    public boolean isSetCreator() {
        return (this.creator!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the name of the annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        if (name == null) {
            return "";
        } else {
            return name;
        }
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    public void setName(String value) {
        this.name = value;
    }

    public boolean isSetName() {
        return (this.name!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the subject of the annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSubject() {
        if (subject == null) {
            return "";
        } else {
            return subject;
        }
    }

    /**
     * Sets the value of the subject property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getSubject()
     */
    public void setSubject(String value) {
        this.subject = value;
    }

    public boolean isSetSubject() {
        return (this.subject!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Set the number of the page, the annotation shall be placed on.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         A reply shall always be placed on the same page as it's target annotation. This is mostly providing a hint where to find the selected annotation.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  1;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getPage()
     */
    public void setPage(int value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    public void unsetPage() {
        this.page = null;
    }

}
