
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;All barcode elements have a number of basic attributes in common. These attributes are described via this base type.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BaseBarcodeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BaseBarcodeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="position" type="{http://schema.webpdf.de/1.0/operation}RectangleType" minOccurs="0"/>
 *       </all>
 *       <attribute name="charset" type="{http://www.w3.org/2001/XMLSchema}string" default="utf-8" />
 *       <attribute name="value" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="rotation" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxExclusive value="360"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="margin" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="pages" default="">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BaseBarcodeType", propOrder = {

})
@XmlSeeAlso({
    QrBarcodeType.class,
    Pdf417BarcodeType.class,
    DataMatrixBarcodeType.class,
    AztecBarcodeType.class,
    CodabarBarcodeType.class,
    Code128BarcodeType.class,
    Code39BarcodeType.class,
    Ean13BarcodeType.class,
    Ean8BarcodeType.class,
    ItfBarcodeType.class,
    UpcaBarcodeType.class
})
public class BaseBarcodeType {

    protected RectangleType position;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the character set in which the barcode contents should be stored.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "charset")
    protected String charset;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Contains the value that should be encoded in the barcode. Depending on the selected barcode format, there may be specific criteria for the data structure. For a description, please refer to the chapter "Barcodes"&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "value", required = true)
    protected String value;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the barcode's rotation in 90-degree increments. When there is a value that falls under a full 90-degree increment, the next higher increment will be automatically selected.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "rotation")
    protected Integer rotation;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the width of the empty frame that should be generated around the barcode. This shall use the same metrics as the position - if no position is present, the default (mm) shall be assumed.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "margin")
    protected Integer margin;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page range for generating barcodes. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: "1-10" or "1,2,5-10")&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;

    /**
     * Gets the value of the position property.
     * 
     * @return
     *     possible object is
     *     {@link RectangleType }
     *     
     */
    public RectangleType getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link RectangleType }
     *     
     */
    public void setPosition(RectangleType value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the character set in which the barcode contents should be stored.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCharset() {
        if (charset == null) {
            return "utf-8";
        } else {
            return charset;
        }
    }

    /**
     * Sets the value of the charset property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCharset()
     */
    public void setCharset(String value) {
        this.charset = value;
    }

    public boolean isSetCharset() {
        return (this.charset!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Contains the value that should be encoded in the barcode. Depending on the selected barcode format, there may be specific criteria for the data structure. For a description, please refer to the chapter "Barcodes"&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getValue()
     */
    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSetValue() {
        return (this.value!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the barcode's rotation in 90-degree increments. When there is a value that falls under a full 90-degree increment, the next higher increment will be automatically selected.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getRotation() {
        if (rotation == null) {
            return  0;
        } else {
            return rotation;
        }
    }

    /**
     * Sets the value of the rotation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getRotation()
     */
    public void setRotation(int value) {
        this.rotation = value;
    }

    public boolean isSetRotation() {
        return (this.rotation!= null);
    }

    public void unsetRotation() {
        this.rotation = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the width of the empty frame that should be generated around the barcode. This shall use the same metrics as the position - if no position is present, the default (mm) shall be assumed.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getMargin() {
        if (margin == null) {
            return  0;
        } else {
            return margin;
        }
    }

    /**
     * Sets the value of the margin property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getMargin()
     */
    public void setMargin(int value) {
        this.margin = value;
    }

    public boolean isSetMargin() {
        return (this.margin!= null);
    }

    public void unsetMargin() {
        this.margin = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page range for generating barcodes. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: "1-10" or "1,2,5-10")&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

}
