
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the format in which the recognition results should be returned.&#13;
 *                     &lt;ul&gt;&lt;li&gt;json = JSON&lt;/li&gt;&lt;li&gt;xml = XML&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BarcodeDetectOutputFormatType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="BarcodeDetectOutputFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="xml"/>
 *     <enumeration value="json"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "BarcodeDetectOutputFormatType")
@XmlEnum
public enum BarcodeDetectOutputFormatType {

    @XmlEnumValue("xml")
    XML("xml"),
    @XmlEnumValue("json")
    JSON("json");
    private final String value;

    BarcodeDetectOutputFormatType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static BarcodeDetectOutputFormatType fromValue(String v) {
        for (BarcodeDetectOutputFormatType c: BarcodeDetectOutputFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
