
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the output format for the barcode generation. The resulting document will be created by this webservice, where selected image formats will completly ignore a possibly given PDF source document and will only contain the barcode image.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p111850_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p568541_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p98130_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     This parameter is for internal use only. Please only set this value to anything other than "pdf", if you are really sure that you need to do so.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BarcodeCreateOutputFormatType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="BarcodeCreateOutputFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="pdf"/>
 *     <enumeration value="bmp"/>
 *     <enumeration value="jpg"/>
 *     <enumeration value="png"/>
 *     <enumeration value="tif"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "BarcodeCreateOutputFormatType")
@XmlEnum
public enum BarcodeCreateOutputFormatType {

    @XmlEnumValue("pdf")
    PDF("pdf"),
    @XmlEnumValue("bmp")
    BMP("bmp"),
    @XmlEnumValue("jpg")
    JPG("jpg"),
    @XmlEnumValue("png")
    PNG("png"),
    @XmlEnumValue("tif")
    TIF("tif");
    private final String value;

    BarcodeCreateOutputFormatType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static BarcodeCreateOutputFormatType fromValue(String v) {
        for (BarcodeCreateOutputFormatType c: BarcodeCreateOutputFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
