
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define a svg resource for an annotation's appearance generation.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for AppearanceSvgType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="AppearanceSvgType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}AppearanceType">
 *       <all>
 *         <element name="data" type="{http://schema.webpdf.de/1.0/operation}AppearanceFileDataType"/>
 *       </all>
 *       <attribute name="preserveAspectRatio" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="aspectRatioAxis" type="{http://schema.webpdf.de/1.0/operation}AxisType" default="x" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AppearanceSvgType", propOrder = {
    "data"
})
public class AppearanceSvgType
    extends AppearanceType
{

    @XmlElement(required = true)
    protected AppearanceFileDataType data;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies whether the aspect ratio should be maintained when scaling the annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "preserveAspectRatio")
    protected Boolean preserveAspectRatio;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the dominant scaling axis, for aspect ratio aware scaling operations of SVGs.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "aspectRatioAxis")
    protected AxisType aspectRatioAxis;

    /**
     * Gets the value of the data property.
     * 
     * @return
     *     possible object is
     *     {@link AppearanceFileDataType }
     *     
     */
    public AppearanceFileDataType getData() {
        return data;
    }

    /**
     * Sets the value of the data property.
     * 
     * @param value
     *     allowed object is
     *     {@link AppearanceFileDataType }
     *     
     */
    public void setData(AppearanceFileDataType value) {
        this.data = value;
    }

    public boolean isSetData() {
        return (this.data!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies whether the aspect ratio should be maintained when scaling the annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isPreserveAspectRatio() {
        if (preserveAspectRatio == null) {
            return false;
        } else {
            return preserveAspectRatio;
        }
    }

    /**
     * Sets the value of the preserveAspectRatio property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isPreserveAspectRatio()
     */
    public void setPreserveAspectRatio(boolean value) {
        this.preserveAspectRatio = value;
    }

    public boolean isSetPreserveAspectRatio() {
        return (this.preserveAspectRatio!= null);
    }

    public void unsetPreserveAspectRatio() {
        this.preserveAspectRatio = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p443889_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p538622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p701498_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the dominant scaling axis, for aspect ratio aware scaling operations of SVGs.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link AxisType }
     *     
     */
    public AxisType getAspectRatioAxis() {
        if (aspectRatioAxis == null) {
            return AxisType.X;
        } else {
            return aspectRatioAxis;
        }
    }

    /**
     * Sets the value of the aspectRatioAxis property.
     * 
     * @param value
     *     allowed object is
     *     {@link AxisType }
     *     
     * @see #getAspectRatioAxis()
     */
    public void setAspectRatioAxis(AxisType value) {
        this.aspectRatioAxis = value;
    }

    public boolean isSetAspectRatioAxis() {
        return (this.aspectRatioAxis!= null);
    }

}
