/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines an LDAP dictionary or Active Directory as a user source.
 */
@Schema(description = "Defines an LDAP dictionary or Active Directory as a user source.")
@JsonPropertyOrder({
  ServerConfigUserLdap.JSON_PROPERTY_CERTIFICATES_TRUST_MODE,
  ServerConfigUserLdap.JSON_PROPERTY_CONNECTION_NAME,
  ServerConfigUserLdap.JSON_PROPERTY_CONNECTION_PASSWORD,
  ServerConfigUserLdap.JSON_PROPERTY_CONNECTION_U_R_L,
  ServerConfigUserLdap.JSON_PROPERTY_FOLLOW_REFERRAL,
  ServerConfigUserLdap.JSON_PROPERTY_KEEP_ALIVE,
  ServerConfigUserLdap.JSON_PROPERTY_ROLE_BASE,
  ServerConfigUserLdap.JSON_PROPERTY_ROLE_FIELD,
  ServerConfigUserLdap.JSON_PROPERTY_ROLE_SEARCH,
  ServerConfigUserLdap.JSON_PROPERTY_USER_BASE,
  ServerConfigUserLdap.JSON_PROPERTY_USER_CERTIFICATES,
  ServerConfigUserLdap.JSON_PROPERTY_USER_P_K_C_S12,
  ServerConfigUserLdap.JSON_PROPERTY_USER_SEARCH
})
@JsonTypeName("ServerConfig_UserLdap")

public class ServerConfigUserLdap {
  /**
   * Specifies the mode for handling the certificates presented by the LDAP server when establishing a connection.  *   validate &#x3D; Only certificates that can be verified as publicly valid are classified as trusted. It may be necessary to place the certificate or the issuer&#39;s certificate in the server&#39;s truststore. Self-signed certificates (e.g., from an own certificate authority) are excluded if they cannot be verified via a configured truststore. *   acceptAll &#x3D; All certificates are classified as trusted, including expired, unverifiable, invalid or self-signed certificates.
   */
  public enum CertificatesTrustModeEnum {
    VALIDATE(String.valueOf("validate")),
    
    ACCEPT_ALL(String.valueOf("acceptAll"));

    private String value;

    CertificatesTrustModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CertificatesTrustModeEnum fromValue(String value) {
      for (CertificatesTrustModeEnum b : CertificatesTrustModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CERTIFICATES_TRUST_MODE = "certificatesTrustMode";
  private CertificatesTrustModeEnum certificatesTrustMode = CertificatesTrustModeEnum.VALIDATE;

  public static final String JSON_PROPERTY_CONNECTION_NAME = "connectionName";
  private String connectionName = "";

  public static final String JSON_PROPERTY_CONNECTION_PASSWORD = "connectionPassword";
  private String connectionPassword = "";

  public static final String JSON_PROPERTY_CONNECTION_U_R_L = "connectionURL";
  private String connectionURL = "";

  public static final String JSON_PROPERTY_FOLLOW_REFERRAL = "followReferral";
  private Boolean followReferral = false;

  public static final String JSON_PROPERTY_KEEP_ALIVE = "keepAlive";
  private ServerConfigUserKeepAliveLdap keepAlive;

  public static final String JSON_PROPERTY_ROLE_BASE = "roleBase";
  private String roleBase = "";

  public static final String JSON_PROPERTY_ROLE_FIELD = "roleField";
  private String roleField = "";

  public static final String JSON_PROPERTY_ROLE_SEARCH = "roleSearch";
  private String roleSearch = "";

  public static final String JSON_PROPERTY_USER_BASE = "userBase";
  private String userBase = "";

  public static final String JSON_PROPERTY_USER_CERTIFICATES = "userCertificates";
  private ServerConfigUserCertificateLdap userCertificates;

  public static final String JSON_PROPERTY_USER_P_K_C_S12 = "userPKCS12";
  private ServerConfigUserPKCS12 userPKCS12;

  public static final String JSON_PROPERTY_USER_SEARCH = "userSearch";
  private String userSearch = "";

  public ServerConfigUserLdap() {
  }

  public ServerConfigUserLdap certificatesTrustMode(CertificatesTrustModeEnum certificatesTrustMode) {
    
    this.certificatesTrustMode = certificatesTrustMode;
    return this;
  }

  /**
   * Specifies the mode for handling the certificates presented by the LDAP server when establishing a connection.  *   validate &#x3D; Only certificates that can be verified as publicly valid are classified as trusted. It may be necessary to place the certificate or the issuer&#39;s certificate in the server&#39;s truststore. Self-signed certificates (e.g., from an own certificate authority) are excluded if they cannot be verified via a configured truststore. *   acceptAll &#x3D; All certificates are classified as trusted, including expired, unverifiable, invalid or self-signed certificates.
   * @return certificatesTrustMode
   **/
  @Nullable
  @Schema(name = "Specifies the mode for handling the certificates presented by the LDAP server when establishing a connection.  *   validate = Only certificates that can be verified as publicly valid are classified as trusted. It may be necessary to place the certificate or the issuer's certificate in the server's truststore. Self-signed certificates (e.g., from an own certificate authority) are excluded if they cannot be verified via a configured truststore. *   acceptAll = All certificates are classified as trusted, including expired, unverifiable, invalid or self-signed certificates.")
  @JsonProperty(JSON_PROPERTY_CERTIFICATES_TRUST_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CertificatesTrustModeEnum getCertificatesTrustMode() {
    return certificatesTrustMode;
  }


  @JsonProperty(JSON_PROPERTY_CERTIFICATES_TRUST_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCertificatesTrustMode(CertificatesTrustModeEnum certificatesTrustMode) {
    this.certificatesTrustMode = certificatesTrustMode;
  }


  public ServerConfigUserLdap connectionName(String connectionName) {
    
    this.connectionName = connectionName;
    return this;
  }

  /**
   * The name of the user used to access the LDAP server. (e.g. \&quot;cn&#x3D;ldapuser,cn&#x3D;Users,dc&#x3D;example,dc&#x3D;local\&quot;.)
   * @return connectionName
   **/
  @Nullable
  @Schema(name = "The name of the user used to access the LDAP server. (e.g. \"cn=ldapuser,cn=Users,dc=example,dc=local\".)")
  @JsonProperty(JSON_PROPERTY_CONNECTION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConnectionName() {
    return connectionName;
  }


  @JsonProperty(JSON_PROPERTY_CONNECTION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConnectionName(String connectionName) {
    this.connectionName = connectionName;
  }


  public ServerConfigUserLdap connectionPassword(String connectionPassword) {
    
    this.connectionPassword = connectionPassword;
    return this;
  }

  /**
   * The password used to access the LDAP server.
   * @return connectionPassword
   **/
  @Nullable
  @Schema(name = "The password used to access the LDAP server.")
  @JsonProperty(JSON_PROPERTY_CONNECTION_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConnectionPassword() {
    return connectionPassword;
  }


  @JsonProperty(JSON_PROPERTY_CONNECTION_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConnectionPassword(String connectionPassword) {
    this.connectionPassword = connectionPassword;
  }


  public ServerConfigUserLdap connectionURL(String connectionURL) {
    
    this.connectionURL = connectionURL;
    return this;
  }

  /**
   * The URL used to connect to the LDAP server. (e.g. \&quot;ldap://server.example.com:389/\&quot;.)
   * @return connectionURL
   **/
  @Nullable
  @Schema(name = "The URL used to connect to the LDAP server. (e.g. \"ldap://server.example.com:389/\".)")
  @JsonProperty(JSON_PROPERTY_CONNECTION_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConnectionURL() {
    return connectionURL;
  }


  @JsonProperty(JSON_PROPERTY_CONNECTION_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConnectionURL(String connectionURL) {
    this.connectionURL = connectionURL;
  }


  public ServerConfigUserLdap followReferral(Boolean followReferral) {
    
    this.followReferral = followReferral;
    return this;
  }

  /**
   * When set to true, all LDAP requests that respond with references are followed. The same schema and credentials are used for the referred request.
   * @return followReferral
   **/
  @Nullable
  @Schema(name = "When set to true, all LDAP requests that respond with references are followed. The same schema and credentials are used for the referred request.")
  @JsonProperty(JSON_PROPERTY_FOLLOW_REFERRAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFollowReferral() {
    return followReferral;
  }


  @JsonProperty(JSON_PROPERTY_FOLLOW_REFERRAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFollowReferral(Boolean followReferral) {
    this.followReferral = followReferral;
  }


  public ServerConfigUserLdap keepAlive(ServerConfigUserKeepAliveLdap keepAlive) {
    
    this.keepAlive = keepAlive;
    return this;
  }

  /**
   * Get keepAlive
   * @return keepAlive
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_KEEP_ALIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigUserKeepAliveLdap getKeepAlive() {
    return keepAlive;
  }


  @JsonProperty(JSON_PROPERTY_KEEP_ALIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKeepAlive(ServerConfigUserKeepAliveLdap keepAlive) {
    this.keepAlive = keepAlive;
  }


  public ServerConfigUserLdap roleBase(String roleBase) {
    
    this.roleBase = roleBase;
    return this;
  }

  /**
   * The Base for the LDAP user&#39;s role determination. (e.g. \&quot;CN&#x3D;Users,DC&#x3D;example,DC&#x3D;local\&quot;.)
   * @return roleBase
   **/
  @Nullable
  @Schema(name = "The Base for the LDAP user's role determination. (e.g. \"CN=Users,DC=example,DC=local\".)")
  @JsonProperty(JSON_PROPERTY_ROLE_BASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoleBase() {
    return roleBase;
  }


  @JsonProperty(JSON_PROPERTY_ROLE_BASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoleBase(String roleBase) {
    this.roleBase = roleBase;
  }


  public ServerConfigUserLdap roleField(String roleField) {
    
    this.roleField = roleField;
    return this;
  }

  /**
   * The field that indicates that a user is part of a group. (e.g. \&quot;cn\&quot;.)
   * @return roleField
   **/
  @Nullable
  @Schema(name = "The field that indicates that a user is part of a group. (e.g. \"cn\".)")
  @JsonProperty(JSON_PROPERTY_ROLE_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoleField() {
    return roleField;
  }


  @JsonProperty(JSON_PROPERTY_ROLE_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoleField(String roleField) {
    this.roleField = roleField;
  }


  public ServerConfigUserLdap roleSearch(String roleSearch) {
    
    this.roleSearch = roleSearch;
    return this;
  }

  /**
   * The LDAP request used to find the user&#39;s role with. (e.g. \&quot;(member&#x3D;{0})\&quot;.)
   * @return roleSearch
   **/
  @Nullable
  @Schema(name = "The LDAP request used to find the user's role with. (e.g. \"(member={0})\".)")
  @JsonProperty(JSON_PROPERTY_ROLE_SEARCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoleSearch() {
    return roleSearch;
  }


  @JsonProperty(JSON_PROPERTY_ROLE_SEARCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoleSearch(String roleSearch) {
    this.roleSearch = roleSearch;
  }


  public ServerConfigUserLdap userBase(String userBase) {
    
    this.userBase = userBase;
    return this;
  }

  /**
   * The Base for the LDAP user search. (e.g. \&quot;CN&#x3D;Users,DC&#x3D;example,DC&#x3D;local\&quot;.)
   * @return userBase
   **/
  @Nullable
  @Schema(name = "The Base for the LDAP user search. (e.g. \"CN=Users,DC=example,DC=local\".)")
  @JsonProperty(JSON_PROPERTY_USER_BASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUserBase() {
    return userBase;
  }


  @JsonProperty(JSON_PROPERTY_USER_BASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserBase(String userBase) {
    this.userBase = userBase;
  }


  public ServerConfigUserLdap userCertificates(ServerConfigUserCertificateLdap userCertificates) {
    
    this.userCertificates = userCertificates;
    return this;
  }

  /**
   * Get userCertificates
   * @return userCertificates
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_USER_CERTIFICATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigUserCertificateLdap getUserCertificates() {
    return userCertificates;
  }


  @JsonProperty(JSON_PROPERTY_USER_CERTIFICATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserCertificates(ServerConfigUserCertificateLdap userCertificates) {
    this.userCertificates = userCertificates;
  }


  public ServerConfigUserLdap userPKCS12(ServerConfigUserPKCS12 userPKCS12) {
    
    this.userPKCS12 = userPKCS12;
    return this;
  }

  /**
   * Get userPKCS12
   * @return userPKCS12
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_USER_P_K_C_S12)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigUserPKCS12 getUserPKCS12() {
    return userPKCS12;
  }


  @JsonProperty(JSON_PROPERTY_USER_P_K_C_S12)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserPKCS12(ServerConfigUserPKCS12 userPKCS12) {
    this.userPKCS12 = userPKCS12;
  }


  public ServerConfigUserLdap userSearch(String userSearch) {
    
    this.userSearch = userSearch;
    return this;
  }

  /**
   * The LDAP request used to find the user&#39;s login name with. (e.g. \&quot;(sAMAccountName&#x3D;{0})\&quot;.)
   * @return userSearch
   **/
  @Nullable
  @Schema(name = "The LDAP request used to find the user's login name with. (e.g. \"(sAMAccountName={0})\".)")
  @JsonProperty(JSON_PROPERTY_USER_SEARCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUserSearch() {
    return userSearch;
  }


  @JsonProperty(JSON_PROPERTY_USER_SEARCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSearch(String userSearch) {
    this.userSearch = userSearch;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServerConfigUserLdap serverConfigUserLdap = (ServerConfigUserLdap) o;
    return Objects.equals(this.certificatesTrustMode, serverConfigUserLdap.certificatesTrustMode) &&
        Objects.equals(this.connectionName, serverConfigUserLdap.connectionName) &&
        Objects.equals(this.connectionPassword, serverConfigUserLdap.connectionPassword) &&
        Objects.equals(this.connectionURL, serverConfigUserLdap.connectionURL) &&
        Objects.equals(this.followReferral, serverConfigUserLdap.followReferral) &&
        Objects.equals(this.keepAlive, serverConfigUserLdap.keepAlive) &&
        Objects.equals(this.roleBase, serverConfigUserLdap.roleBase) &&
        Objects.equals(this.roleField, serverConfigUserLdap.roleField) &&
        Objects.equals(this.roleSearch, serverConfigUserLdap.roleSearch) &&
        Objects.equals(this.userBase, serverConfigUserLdap.userBase) &&
        Objects.equals(this.userCertificates, serverConfigUserLdap.userCertificates) &&
        Objects.equals(this.userPKCS12, serverConfigUserLdap.userPKCS12) &&
        Objects.equals(this.userSearch, serverConfigUserLdap.userSearch);
  }

  @Override
  public int hashCode() {
    return Objects.hash(certificatesTrustMode, connectionName, connectionPassword, connectionURL, followReferral, keepAlive, roleBase, roleField, roleSearch, userBase, userCertificates, userPKCS12, userSearch);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServerConfigUserLdap {\n");
    sb.append("    certificatesTrustMode: ").append(toIndentedString(certificatesTrustMode)).append("\n");
    sb.append("    connectionName: ").append(toIndentedString(connectionName)).append("\n");
    sb.append("    connectionPassword: ").append(toIndentedString(connectionPassword)).append("\n");
    sb.append("    connectionURL: ").append(toIndentedString(connectionURL)).append("\n");
    sb.append("    followReferral: ").append(toIndentedString(followReferral)).append("\n");
    sb.append("    keepAlive: ").append(toIndentedString(keepAlive)).append("\n");
    sb.append("    roleBase: ").append(toIndentedString(roleBase)).append("\n");
    sb.append("    roleField: ").append(toIndentedString(roleField)).append("\n");
    sb.append("    roleSearch: ").append(toIndentedString(roleSearch)).append("\n");
    sb.append("    userBase: ").append(toIndentedString(userBase)).append("\n");
    sb.append("    userCertificates: ").append(toIndentedString(userCertificates)).append("\n");
    sb.append("    userPKCS12: ").append(toIndentedString(userPKCS12)).append("\n");
    sb.append("    userSearch: ").append(toIndentedString(userSearch)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
