/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines a relational user database as a user source.
 */
@Schema(description = "Defines a relational user database as a user source.")
@JsonPropertyOrder({
  ServerConfigUserDb.JSON_PROPERTY_CONNECTION_NAME,
  ServerConfigUserDb.JSON_PROPERTY_CONNECTION_PASSWORD,
  ServerConfigUserDb.JSON_PROPERTY_CONNECTION_U_R_L,
  ServerConfigUserDb.JSON_PROPERTY_DIGEST,
  ServerConfigUserDb.JSON_PROPERTY_DRIVER_NAME,
  ServerConfigUserDb.JSON_PROPERTY_ROLE_NAME_COL,
  ServerConfigUserDb.JSON_PROPERTY_USER_CRED_COL,
  ServerConfigUserDb.JSON_PROPERTY_USER_NAME_COL,
  ServerConfigUserDb.JSON_PROPERTY_USER_ROLE_TABLE,
  ServerConfigUserDb.JSON_PROPERTY_USER_TABLE
})
@JsonTypeName("ServerConfig_UserDb")

public class ServerConfigUserDb {
  public static final String JSON_PROPERTY_CONNECTION_NAME = "connectionName";
  private String connectionName = "";

  public static final String JSON_PROPERTY_CONNECTION_PASSWORD = "connectionPassword";
  private String connectionPassword = "";

  public static final String JSON_PROPERTY_CONNECTION_U_R_L = "connectionURL";
  private String connectionURL = "";

  public static final String JSON_PROPERTY_DIGEST = "digest";
  private String digest = "";

  public static final String JSON_PROPERTY_DRIVER_NAME = "driverName";
  private String driverName = "";

  public static final String JSON_PROPERTY_ROLE_NAME_COL = "roleNameCol";
  private String roleNameCol = "role_name";

  public static final String JSON_PROPERTY_USER_CRED_COL = "userCredCol";
  private String userCredCol = "user_pass";

  public static final String JSON_PROPERTY_USER_NAME_COL = "userNameCol";
  private String userNameCol = "user_name";

  public static final String JSON_PROPERTY_USER_ROLE_TABLE = "userRoleTable";
  private String userRoleTable = "user_roles";

  public static final String JSON_PROPERTY_USER_TABLE = "userTable";
  private String userTable = "users";

  public ServerConfigUserDb() {
  }

  public ServerConfigUserDb connectionName(String connectionName) {
    
    this.connectionName = connectionName;
    return this;
  }

  /**
   * The name of the database user to access the database for.
   * @return connectionName
   **/
  @Nullable
  @Schema(name = "The name of the database user to access the database for.")
  @JsonProperty(JSON_PROPERTY_CONNECTION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConnectionName() {
    return connectionName;
  }


  @JsonProperty(JSON_PROPERTY_CONNECTION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConnectionName(String connectionName) {
    this.connectionName = connectionName;
  }


  public ServerConfigUserDb connectionPassword(String connectionPassword) {
    
    this.connectionPassword = connectionPassword;
    return this;
  }

  /**
   * The password of the database user to access the database with.
   * @return connectionPassword
   **/
  @Nullable
  @Schema(name = "The password of the database user to access the database with.")
  @JsonProperty(JSON_PROPERTY_CONNECTION_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConnectionPassword() {
    return connectionPassword;
  }


  @JsonProperty(JSON_PROPERTY_CONNECTION_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConnectionPassword(String connectionPassword) {
    this.connectionPassword = connectionPassword;
  }


  public ServerConfigUserDb connectionURL(String connectionURL) {
    
    this.connectionURL = connectionURL;
    return this;
  }

  /**
   * The URL of the database. (e.g. \&quot;jdbc:mysql://localhost:3306/webpdf\&quot;.)
   * @return connectionURL
   **/
  @Nullable
  @Schema(name = "The URL of the database. (e.g. \"jdbc:mysql://localhost:3306/webpdf\".)")
  @JsonProperty(JSON_PROPERTY_CONNECTION_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConnectionURL() {
    return connectionURL;
  }


  @JsonProperty(JSON_PROPERTY_CONNECTION_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConnectionURL(String connectionURL) {
    this.connectionURL = connectionURL;
  }


  public ServerConfigUserDb digest(String digest) {
    
    this.digest = digest;
    return this;
  }

  /**
   * This field currently is unused.
   * @return digest
   **/
  @Nullable
  @Schema(name = "This field currently is unused.")
  @JsonProperty(JSON_PROPERTY_DIGEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDigest() {
    return digest;
  }


  @JsonProperty(JSON_PROPERTY_DIGEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDigest(String digest) {
    this.digest = digest;
  }


  public ServerConfigUserDb driverName(String driverName) {
    
    this.driverName = driverName;
    return this;
  }

  /**
   * The name of the driver (path of the java class) to use for database access. (e.g. \&quot;com.mysql.jdbc.Driver\&quot;.)
   * @return driverName
   **/
  @Nullable
  @Schema(name = "The name of the driver (path of the java class) to use for database access. (e.g. \"com.mysql.jdbc.Driver\".)")
  @JsonProperty(JSON_PROPERTY_DRIVER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDriverName() {
    return driverName;
  }


  @JsonProperty(JSON_PROPERTY_DRIVER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDriverName(String driverName) {
    this.driverName = driverName;
  }


  public ServerConfigUserDb roleNameCol(String roleNameCol) {
    
    this.roleNameCol = roleNameCol;
    return this;
  }

  /**
   * The name of the column containing the user&#39;s role.
   * @return roleNameCol
   **/
  @Nullable
  @Schema(name = "The name of the column containing the user's role.")
  @JsonProperty(JSON_PROPERTY_ROLE_NAME_COL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoleNameCol() {
    return roleNameCol;
  }


  @JsonProperty(JSON_PROPERTY_ROLE_NAME_COL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoleNameCol(String roleNameCol) {
    this.roleNameCol = roleNameCol;
  }


  public ServerConfigUserDb userCredCol(String userCredCol) {
    
    this.userCredCol = userCredCol;
    return this;
  }

  /**
   * The name of the column containing the user&#39;s credentials.
   * @return userCredCol
   **/
  @Nullable
  @Schema(name = "The name of the column containing the user's credentials.")
  @JsonProperty(JSON_PROPERTY_USER_CRED_COL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUserCredCol() {
    return userCredCol;
  }


  @JsonProperty(JSON_PROPERTY_USER_CRED_COL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserCredCol(String userCredCol) {
    this.userCredCol = userCredCol;
  }


  public ServerConfigUserDb userNameCol(String userNameCol) {
    
    this.userNameCol = userNameCol;
    return this;
  }

  /**
   * The name of the column containing the user&#39;s name.
   * @return userNameCol
   **/
  @Nullable
  @Schema(name = "The name of the column containing the user's name.")
  @JsonProperty(JSON_PROPERTY_USER_NAME_COL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUserNameCol() {
    return userNameCol;
  }


  @JsonProperty(JSON_PROPERTY_USER_NAME_COL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserNameCol(String userNameCol) {
    this.userNameCol = userNameCol;
  }


  public ServerConfigUserDb userRoleTable(String userRoleTable) {
    
    this.userRoleTable = userRoleTable;
    return this;
  }

  /**
   * The name of the table that defines the available user roles.
   * @return userRoleTable
   **/
  @Nullable
  @Schema(name = "The name of the table that defines the available user roles.")
  @JsonProperty(JSON_PROPERTY_USER_ROLE_TABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUserRoleTable() {
    return userRoleTable;
  }


  @JsonProperty(JSON_PROPERTY_USER_ROLE_TABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserRoleTable(String userRoleTable) {
    this.userRoleTable = userRoleTable;
  }


  public ServerConfigUserDb userTable(String userTable) {
    
    this.userTable = userTable;
    return this;
  }

  /**
   * The name of the database table, that lists the server&#39;s users.
   * @return userTable
   **/
  @Nullable
  @Schema(name = "The name of the database table, that lists the server's users.")
  @JsonProperty(JSON_PROPERTY_USER_TABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUserTable() {
    return userTable;
  }


  @JsonProperty(JSON_PROPERTY_USER_TABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserTable(String userTable) {
    this.userTable = userTable;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServerConfigUserDb serverConfigUserDb = (ServerConfigUserDb) o;
    return Objects.equals(this.connectionName, serverConfigUserDb.connectionName) &&
        Objects.equals(this.connectionPassword, serverConfigUserDb.connectionPassword) &&
        Objects.equals(this.connectionURL, serverConfigUserDb.connectionURL) &&
        Objects.equals(this.digest, serverConfigUserDb.digest) &&
        Objects.equals(this.driverName, serverConfigUserDb.driverName) &&
        Objects.equals(this.roleNameCol, serverConfigUserDb.roleNameCol) &&
        Objects.equals(this.userCredCol, serverConfigUserDb.userCredCol) &&
        Objects.equals(this.userNameCol, serverConfigUserDb.userNameCol) &&
        Objects.equals(this.userRoleTable, serverConfigUserDb.userRoleTable) &&
        Objects.equals(this.userTable, serverConfigUserDb.userTable);
  }

  @Override
  public int hashCode() {
    return Objects.hash(connectionName, connectionPassword, connectionURL, digest, driverName, roleNameCol, userCredCol, userNameCol, userRoleTable, userTable);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServerConfigUserDb {\n");
    sb.append("    connectionName: ").append(toIndentedString(connectionName)).append("\n");
    sb.append("    connectionPassword: ").append(toIndentedString(connectionPassword)).append("\n");
    sb.append("    connectionURL: ").append(toIndentedString(connectionURL)).append("\n");
    sb.append("    digest: ").append(toIndentedString(digest)).append("\n");
    sb.append("    driverName: ").append(toIndentedString(driverName)).append("\n");
    sb.append("    roleNameCol: ").append(toIndentedString(roleNameCol)).append("\n");
    sb.append("    userCredCol: ").append(toIndentedString(userCredCol)).append("\n");
    sb.append("    userNameCol: ").append(toIndentedString(userNameCol)).append("\n");
    sb.append("    userRoleTable: ").append(toIndentedString(userRoleTable)).append("\n");
    sb.append("    userTable: ").append(toIndentedString(userTable)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
