/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines an Oauth2 authorization provider.
 */
@Schema(description = "Defines an Oauth2 authorization provider.")
@JsonPropertyOrder({
  ServerConfigOAuthProvider.JSON_PROPERTY_APPLICATION_ID,
  ServerConfigOAuthProvider.JSON_PROPERTY_CLAIM_CLIENT_ID,
  ServerConfigOAuthProvider.JSON_PROPERTY_CLAIM_ROLES,
  ServerConfigOAuthProvider.JSON_PROPERTY_CLAIM_SESSION_ID,
  ServerConfigOAuthProvider.JSON_PROPERTY_CLIENT_ID,
  ServerConfigOAuthProvider.JSON_PROPERTY_DISCOVERY_URL,
  ServerConfigOAuthProvider.JSON_PROPERTY_DISPLAY_NAME,
  ServerConfigOAuthProvider.JSON_PROPERTY_FLOW,
  ServerConfigOAuthProvider.JSON_PROPERTY_ID,
  ServerConfigOAuthProvider.JSON_PROPERTY_LOGOUT,
  ServerConfigOAuthProvider.JSON_PROPERTY_MAX_TIME_SKEW,
  ServerConfigOAuthProvider.JSON_PROPERTY_NAME,
  ServerConfigOAuthProvider.JSON_PROPERTY_ROLE_NAME_ADMIN,
  ServerConfigOAuthProvider.JSON_PROPERTY_ROLE_NAME_USER,
  ServerConfigOAuthProvider.JSON_PROPERTY_SCOPE,
  ServerConfigOAuthProvider.JSON_PROPERTY_TENANT_ID
})
@JsonTypeName("ServerConfig_OAuthProvider")

public class ServerConfigOAuthProvider {
  public static final String JSON_PROPERTY_APPLICATION_ID = "applicationId";
  private String applicationId = "";

  public static final String JSON_PROPERTY_CLAIM_CLIENT_ID = "claimClientId";
  private String claimClientId = "";

  public static final String JSON_PROPERTY_CLAIM_ROLES = "claimRoles";
  private String claimRoles = "";

  public static final String JSON_PROPERTY_CLAIM_SESSION_ID = "claimSessionId";
  private String claimSessionId = "";

  public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
  private String clientId = "";

  public static final String JSON_PROPERTY_DISCOVERY_URL = "discoveryUrl";
  private String discoveryUrl = "";

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName = "";

  /**
   * Selects the [OAuth2 flow](https://datatracker.ietf.org/doc/html/rfc6749#section-1.2) used. Depending on the flow, different settings are necessary for the provider.
   */
  public enum FlowEnum {
    CLIENT_CREDENTIALS(String.valueOf("clientCredentials")),
    
    AUTHORIZATION_CODE_WITH_PKCE(String.valueOf("authorizationCodeWithPkce"));

    private String value;

    FlowEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FlowEnum fromValue(String value) {
      for (FlowEnum b : FlowEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FLOW = "flow";
  private FlowEnum flow = FlowEnum.CLIENT_CREDENTIALS;

  public static final String JSON_PROPERTY_ID = "id";
  private String id = "";

  public static final String JSON_PROPERTY_LOGOUT = "logout";
  private ServerConfigOAuthProviderLogout logout;

  public static final String JSON_PROPERTY_MAX_TIME_SKEW = "maxTimeSkew";
  private Integer maxTimeSkew = 0;

  /**
   * Selects the OAuth2 provider or \&quot;generic\&quot; when not available in the list.
   */
  public enum NameEnum {
    GENERIC(String.valueOf("generic")),
    
    AZURE_AD(String.valueOf("azureAd")),
    
    AUTH0(String.valueOf("auth0"));

    private String value;

    NameEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NameEnum fromValue(String value) {
      for (NameEnum b : NameEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NAME = "name";
  private NameEnum name = NameEnum.GENERIC;

  public static final String JSON_PROPERTY_ROLE_NAME_ADMIN = "roleNameAdmin";
  private String roleNameAdmin = "";

  public static final String JSON_PROPERTY_ROLE_NAME_USER = "roleNameUser";
  private String roleNameUser = "";

  public static final String JSON_PROPERTY_SCOPE = "scope";
  private String scope = "";

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private String tenantId = "";

  public ServerConfigOAuthProvider() {
  }

  public ServerConfigOAuthProvider applicationId(String applicationId) {
    
    this.applicationId = applicationId;
    return this;
  }

  /**
   * Sets the application identifier that uniquely identifies the application (the API of this server). This ID is also defined as the audience for the token to verify that the token was issued for the API dServer.
   * @return applicationId
   **/
  @Nullable
  @Schema(name = "Sets the application identifier that uniquely identifies the application (the API of this server). This ID is also defined as the audience for the token to verify that the token was issued for the API dServer.")
  @JsonProperty(JSON_PROPERTY_APPLICATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getApplicationId() {
    return applicationId;
  }


  @JsonProperty(JSON_PROPERTY_APPLICATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationId(String applicationId) {
    this.applicationId = applicationId;
  }


  public ServerConfigOAuthProvider claimClientId(String claimClientId) {
    
    this.claimClientId = claimClientId;
    return this;
  }

  /**
   * Sets the name of the claim (in most cases \&quot;azp\&quot;) that contains the client ID in the token.
   * @return claimClientId
   **/
  @Nullable
  @Schema(name = "Sets the name of the claim (in most cases \"azp\") that contains the client ID in the token.")
  @JsonProperty(JSON_PROPERTY_CLAIM_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClaimClientId() {
    return claimClientId;
  }


  @JsonProperty(JSON_PROPERTY_CLAIM_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClaimClientId(String claimClientId) {
    this.claimClientId = claimClientId;
  }


  public ServerConfigOAuthProvider claimRoles(String claimRoles) {
    
    this.claimRoles = claimRoles;
    return this;
  }

  /**
   * Sets the name of the claim (in most cases \&quot;roles\&quot;) that contains the roles in the token.
   * @return claimRoles
   **/
  @Nullable
  @Schema(name = "Sets the name of the claim (in most cases \"roles\") that contains the roles in the token.")
  @JsonProperty(JSON_PROPERTY_CLAIM_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClaimRoles() {
    return claimRoles;
  }


  @JsonProperty(JSON_PROPERTY_CLAIM_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClaimRoles(String claimRoles) {
    this.claimRoles = claimRoles;
  }


  public ServerConfigOAuthProvider claimSessionId(String claimSessionId) {
    
    this.claimSessionId = claimSessionId;
    return this;
  }

  /**
   * Specifies the name of the claim (in most cases \&quot;sub\&quot;) that contains the session ID in the token. This must be a unique identifier that uniquely identifies the authenticated client (or user).
   * @return claimSessionId
   **/
  @Nullable
  @Schema(name = "Specifies the name of the claim (in most cases \"sub\") that contains the session ID in the token. This must be a unique identifier that uniquely identifies the authenticated client (or user).")
  @JsonProperty(JSON_PROPERTY_CLAIM_SESSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClaimSessionId() {
    return claimSessionId;
  }


  @JsonProperty(JSON_PROPERTY_CLAIM_SESSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClaimSessionId(String claimSessionId) {
    this.claimSessionId = claimSessionId;
  }


  public ServerConfigOAuthProvider clientId(String clientId) {
    
    this.clientId = clientId;
    return this;
  }

  /**
   * Sets the [OAuth2 client identifier](https://datatracker.ietf.org/doc/html/rfc6749#section-2.2).
   * @return clientId
   **/
  @Nullable
  @Schema(name = "Sets the [OAuth2 client identifier](https://datatracker.ietf.org/doc/html/rfc6749#section-2.2).")
  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClientId() {
    return clientId;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientId(String clientId) {
    this.clientId = clientId;
  }


  public ServerConfigOAuthProvider discoveryUrl(String discoveryUrl) {
    
    this.discoveryUrl = discoveryUrl;
    return this;
  }

  /**
   * Sets the [discovery URL](https://datatracker.ietf.org/doc/html/rfc8414) for the OAuth2 process, where the server can find, for example, the required public signature keys for token validation.
   * @return discoveryUrl
   **/
  @Nullable
  @Schema(name = "Sets the [discovery URL](https://datatracker.ietf.org/doc/html/rfc8414) for the OAuth2 process, where the server can find, for example, the required public signature keys for token validation.")
  @JsonProperty(JSON_PROPERTY_DISCOVERY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDiscoveryUrl() {
    return discoveryUrl;
  }


  @JsonProperty(JSON_PROPERTY_DISCOVERY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscoveryUrl(String discoveryUrl) {
    this.discoveryUrl = discoveryUrl;
  }


  public ServerConfigOAuthProvider displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

  /**
   * The displayed name for the provider (e.g., in the portal).
   * @return displayName
   **/
  @Nullable
  @Schema(name = "The displayed name for the provider (e.g., in the portal).")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public ServerConfigOAuthProvider flow(FlowEnum flow) {
    
    this.flow = flow;
    return this;
  }

  /**
   * Selects the [OAuth2 flow](https://datatracker.ietf.org/doc/html/rfc6749#section-1.2) used. Depending on the flow, different settings are necessary for the provider.
   * @return flow
   **/
  @Nullable
  @Schema(name = "Selects the [OAuth2 flow](https://datatracker.ietf.org/doc/html/rfc6749#section-1.2) used. Depending on the flow, different settings are necessary for the provider.")
  @JsonProperty(JSON_PROPERTY_FLOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FlowEnum getFlow() {
    return flow;
  }


  @JsonProperty(JSON_PROPERTY_FLOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlow(FlowEnum flow) {
    this.flow = flow;
  }


  public ServerConfigOAuthProvider id(String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Sets a unique ID that uniquely identifies this provider configuration.
   * @return id
   **/
  @Nullable
  @Schema(name = "Sets a unique ID that uniquely identifies this provider configuration.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public ServerConfigOAuthProvider logout(ServerConfigOAuthProviderLogout logout) {
    
    this.logout = logout;
    return this;
  }

  /**
   * Get logout
   * @return logout
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_LOGOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigOAuthProviderLogout getLogout() {
    return logout;
  }


  @JsonProperty(JSON_PROPERTY_LOGOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogout(ServerConfigOAuthProviderLogout logout) {
    this.logout = logout;
  }


  public ServerConfigOAuthProvider maxTimeSkew(Integer maxTimeSkew) {
    
    this.maxTimeSkew = maxTimeSkew;
    return this;
  }

  /**
   * The maximum time skew that may occur between the local time on the server and the local time of the issuer of the token.
   * @return maxTimeSkew
   **/
  @Nullable
  @Schema(name = "The maximum time skew that may occur between the local time on the server and the local time of the issuer of the token.")
  @JsonProperty(JSON_PROPERTY_MAX_TIME_SKEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxTimeSkew() {
    return maxTimeSkew;
  }


  @JsonProperty(JSON_PROPERTY_MAX_TIME_SKEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxTimeSkew(Integer maxTimeSkew) {
    this.maxTimeSkew = maxTimeSkew;
  }


  public ServerConfigOAuthProvider name(NameEnum name) {
    
    this.name = name;
    return this;
  }

  /**
   * Selects the OAuth2 provider or \&quot;generic\&quot; when not available in the list.
   * @return name
   **/
  @Nullable
  @Schema(name = "Selects the OAuth2 provider or \"generic\" when not available in the list.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NameEnum getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(NameEnum name) {
    this.name = name;
  }


  public ServerConfigOAuthProvider roleNameAdmin(String roleNameAdmin) {
    
    this.roleNameAdmin = roleNameAdmin;
    return this;
  }

  /**
   * Sets the name of the role that grants administrative rights. This allows changing the default \&quot;admin\&quot; value to a custom role name. This must match the content of the claim defined via \&quot;claimRoles\&quot;.
   * @return roleNameAdmin
   **/
  @Nullable
  @Schema(name = "Sets the name of the role that grants administrative rights. This allows changing the default \"admin\" value to a custom role name. This must match the content of the claim defined via \"claimRoles\".")
  @JsonProperty(JSON_PROPERTY_ROLE_NAME_ADMIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoleNameAdmin() {
    return roleNameAdmin;
  }


  @JsonProperty(JSON_PROPERTY_ROLE_NAME_ADMIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoleNameAdmin(String roleNameAdmin) {
    this.roleNameAdmin = roleNameAdmin;
  }


  public ServerConfigOAuthProvider roleNameUser(String roleNameUser) {
    
    this.roleNameUser = roleNameUser;
    return this;
  }

  /**
   * Sets the name of the role that grants normal user rights. This allows changing the default \&quot;user\&quot; value to a custom role name. This must match the content of the claim defined via \&quot;claimRoles\&quot;.
   * @return roleNameUser
   **/
  @Nullable
  @Schema(name = "Sets the name of the role that grants normal user rights. This allows changing the default \"user\" value to a custom role name. This must match the content of the claim defined via \"claimRoles\".")
  @JsonProperty(JSON_PROPERTY_ROLE_NAME_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoleNameUser() {
    return roleNameUser;
  }


  @JsonProperty(JSON_PROPERTY_ROLE_NAME_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoleNameUser(String roleNameUser) {
    this.roleNameUser = roleNameUser;
  }


  public ServerConfigOAuthProvider scope(String scope) {
    
    this.scope = scope;
    return this;
  }

  /**
   * Specifies the [scope](https://datatracker.ietf.org/doc/html/rfc6749#page-23) for the OAuth2 token. Each separated by a space.
   * @return scope
   **/
  @Nullable
  @Schema(name = "Specifies the [scope](https://datatracker.ietf.org/doc/html/rfc6749#page-23) for the OAuth2 token. Each separated by a space.")
  @JsonProperty(JSON_PROPERTY_SCOPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getScope() {
    return scope;
  }


  @JsonProperty(JSON_PROPERTY_SCOPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScope(String scope) {
    this.scope = scope;
  }


  public ServerConfigOAuthProvider tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * Sets a tenant identifier for the OAuth2 request. Not all providers require a tenant id.
   * @return tenantId
   **/
  @Nullable
  @Schema(name = "Sets a tenant identifier for the OAuth2 request. Not all providers require a tenant id.")
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServerConfigOAuthProvider serverConfigOAuthProvider = (ServerConfigOAuthProvider) o;
    return Objects.equals(this.applicationId, serverConfigOAuthProvider.applicationId) &&
        Objects.equals(this.claimClientId, serverConfigOAuthProvider.claimClientId) &&
        Objects.equals(this.claimRoles, serverConfigOAuthProvider.claimRoles) &&
        Objects.equals(this.claimSessionId, serverConfigOAuthProvider.claimSessionId) &&
        Objects.equals(this.clientId, serverConfigOAuthProvider.clientId) &&
        Objects.equals(this.discoveryUrl, serverConfigOAuthProvider.discoveryUrl) &&
        Objects.equals(this.displayName, serverConfigOAuthProvider.displayName) &&
        Objects.equals(this.flow, serverConfigOAuthProvider.flow) &&
        Objects.equals(this.id, serverConfigOAuthProvider.id) &&
        Objects.equals(this.logout, serverConfigOAuthProvider.logout) &&
        Objects.equals(this.maxTimeSkew, serverConfigOAuthProvider.maxTimeSkew) &&
        Objects.equals(this.name, serverConfigOAuthProvider.name) &&
        Objects.equals(this.roleNameAdmin, serverConfigOAuthProvider.roleNameAdmin) &&
        Objects.equals(this.roleNameUser, serverConfigOAuthProvider.roleNameUser) &&
        Objects.equals(this.scope, serverConfigOAuthProvider.scope) &&
        Objects.equals(this.tenantId, serverConfigOAuthProvider.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(applicationId, claimClientId, claimRoles, claimSessionId, clientId, discoveryUrl, displayName, flow, id, logout, maxTimeSkew, name, roleNameAdmin, roleNameUser, scope, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServerConfigOAuthProvider {\n");
    sb.append("    applicationId: ").append(toIndentedString(applicationId)).append("\n");
    sb.append("    claimClientId: ").append(toIndentedString(claimClientId)).append("\n");
    sb.append("    claimRoles: ").append(toIndentedString(claimRoles)).append("\n");
    sb.append("    claimSessionId: ").append(toIndentedString(claimSessionId)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    discoveryUrl: ").append(toIndentedString(discoveryUrl)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    flow: ").append(toIndentedString(flow)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    logout: ").append(toIndentedString(logout)).append("\n");
    sb.append("    maxTimeSkew: ").append(toIndentedString(maxTimeSkew)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    roleNameAdmin: ").append(toIndentedString(roleNameAdmin)).append("\n");
    sb.append("    roleNameUser: ").append(toIndentedString(roleNameUser)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
