/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * A [connector](https://tomcat.apache.org/tomcat-10.1-doc/config/http.html) defines the properties of a port the server can be accessed by.
 */
@Schema(description = "A [connector](https://tomcat.apache.org/tomcat-10.1-doc/config/http.html) defines the properties of a port the server can be accessed by.")
@JsonPropertyOrder({
  ServerConfigConnector.JSON_PROPERTY_ADDRESS,
  ServerConfigConnector.JSON_PROPERTY_COMPRESSIBLE_MIME_TYPE,
  ServerConfigConnector.JSON_PROPERTY_COMPRESSION,
  ServerConfigConnector.JSON_PROPERTY_COMPRESSION_MIN_SIZE,
  ServerConfigConnector.JSON_PROPERTY_CONFIGURATION,
  ServerConfigConnector.JSON_PROPERTY_ENABLED,
  ServerConfigConnector.JSON_PROPERTY_PORT,
  ServerConfigConnector.JSON_PROPERTY_PROTOCOL,
  ServerConfigConnector.JSON_PROPERTY_PROXY,
  ServerConfigConnector.JSON_PROPERTY_SSL
})
@JsonTypeName("ServerConfig_Connector")

public class ServerConfigConnector {
  public static final String JSON_PROPERTY_ADDRESS = "address";
  private String address = "";

  public static final String JSON_PROPERTY_COMPRESSIBLE_MIME_TYPE = "compressibleMimeType";
  private String compressibleMimeType = "text/html,text/xml,text/css,application/json,application/javascript";

  /**
   * Specifies whether to apply GZIP compression to the message to save bandwidth.  *   off &#x3D; disable compression. *   on &#x3D; allow compression, which causes text data to be compressed. *   force &#x3D; forces compression in all cases.
   */
  public enum CompressionEnum {
    ON(String.valueOf("on")),
    
    OFF(String.valueOf("off")),
    
    FORCE(String.valueOf("force"));

    private String value;

    CompressionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CompressionEnum fromValue(String value) {
      for (CompressionEnum b : CompressionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_COMPRESSION = "compression";
  private CompressionEnum compression = CompressionEnum.ON;

  public static final String JSON_PROPERTY_COMPRESSION_MIN_SIZE = "compressionMinSize";
  private Integer compressionMinSize = 2048;

  public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
  private ServerConfigConnectorConfiguration _configuration;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_PORT = "port";
  private Integer port = 8080;

  /**
   * The protocol to use for the connector.  *   HTTP/1.1 &#x3D; Non blocking java NIO connector. *   HTTP/2.0 &#x3D; Non blocking java NIO2 connector. *   AJP/1.3 &#x3D; The APR/native connector.
   */
  public enum ProtocolEnum {
    HTTP_1_1(String.valueOf("HTTP/1.1")),
    
    HTTP_2_0(String.valueOf("HTTP/2.0")),
    
    AJP_1_3(String.valueOf("AJP/1.3"));

    private String value;

    ProtocolEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProtocolEnum fromValue(String value) {
      for (ProtocolEnum b : ProtocolEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PROTOCOL = "protocol";
  private ProtocolEnum protocol = ProtocolEnum.HTTP_1_1;

  public static final String JSON_PROPERTY_PROXY = "proxy";
  private ServerConfigProxy proxy;

  public static final String JSON_PROPERTY_SSL = "ssl";
  private ServerConfigSSL ssl;

  public ServerConfigConnector() {
  }

  public ServerConfigConnector address(String address) {
    
    this.address = address;
    return this;
  }

  /**
   * The IP address to which the connector should bind. If not defined, all IP addresses are used.
   * @return address
   **/
  @Nullable
  @Schema(name = "The IP address to which the connector should bind. If not defined, all IP addresses are used.")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(String address) {
    this.address = address;
  }


  public ServerConfigConnector compressibleMimeType(String compressibleMimeType) {
    
    this.compressibleMimeType = compressibleMimeType;
    return this;
  }

  /**
   * Selects the MIME Types of message contents, that may be compressed via GZIP compression.
   * @return compressibleMimeType
   **/
  @Nullable
  @Schema(name = "Selects the MIME Types of message contents, that may be compressed via GZIP compression.")
  @JsonProperty(JSON_PROPERTY_COMPRESSIBLE_MIME_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCompressibleMimeType() {
    return compressibleMimeType;
  }


  @JsonProperty(JSON_PROPERTY_COMPRESSIBLE_MIME_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompressibleMimeType(String compressibleMimeType) {
    this.compressibleMimeType = compressibleMimeType;
  }


  public ServerConfigConnector compression(CompressionEnum compression) {
    
    this.compression = compression;
    return this;
  }

  /**
   * Specifies whether to apply GZIP compression to the message to save bandwidth.  *   off &#x3D; disable compression. *   on &#x3D; allow compression, which causes text data to be compressed. *   force &#x3D; forces compression in all cases.
   * @return compression
   **/
  @Nullable
  @Schema(name = "Specifies whether to apply GZIP compression to the message to save bandwidth.  *   off = disable compression. *   on = allow compression, which causes text data to be compressed. *   force = forces compression in all cases.")
  @JsonProperty(JSON_PROPERTY_COMPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CompressionEnum getCompression() {
    return compression;
  }


  @JsonProperty(JSON_PROPERTY_COMPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompression(CompressionEnum compression) {
    this.compression = compression;
  }


  public ServerConfigConnector compressionMinSize(Integer compressionMinSize) {
    
    this.compressionMinSize = compressionMinSize;
    return this;
  }

  /**
   * Sets the minimum number of bytes a message must reach before GZIP compression shall be applied.
   * @return compressionMinSize
   **/
  @Nullable
  @Schema(name = "Sets the minimum number of bytes a message must reach before GZIP compression shall be applied.")
  @JsonProperty(JSON_PROPERTY_COMPRESSION_MIN_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCompressionMinSize() {
    return compressionMinSize;
  }


  @JsonProperty(JSON_PROPERTY_COMPRESSION_MIN_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompressionMinSize(Integer compressionMinSize) {
    this.compressionMinSize = compressionMinSize;
  }


  public ServerConfigConnector _configuration(ServerConfigConnectorConfiguration _configuration) {
    
    this._configuration = _configuration;
    return this;
  }

  /**
   * Get _configuration
   * @return _configuration
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigConnectorConfiguration getConfiguration() {
    return _configuration;
  }


  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConfiguration(ServerConfigConnectorConfiguration _configuration) {
    this._configuration = _configuration;
  }


  public ServerConfigConnector enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

  /**
   * When set to true this connector is active and may be used to connect to the server.
   * @return enabled
   **/
  @Nullable
  @Schema(name = "When set to true this connector is active and may be used to connect to the server.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public ServerConfigConnector port(Integer port) {
    
    this.port = port;
    return this;
  }

  /**
   * The port the connector is listening to.
   * minimum: 1
   * @return port
   **/
  @Nullable
  @Schema(name = "The port the connector is listening to.")
  @JsonProperty(JSON_PROPERTY_PORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPort() {
    return port;
  }


  @JsonProperty(JSON_PROPERTY_PORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPort(Integer port) {
    this.port = port;
  }


  public ServerConfigConnector protocol(ProtocolEnum protocol) {
    
    this.protocol = protocol;
    return this;
  }

  /**
   * The protocol to use for the connector.  *   HTTP/1.1 &#x3D; Non blocking java NIO connector. *   HTTP/2.0 &#x3D; Non blocking java NIO2 connector. *   AJP/1.3 &#x3D; The APR/native connector.
   * @return protocol
   **/
  @Nullable
  @Schema(name = "The protocol to use for the connector.  *   HTTP/1.1 = Non blocking java NIO connector. *   HTTP/2.0 = Non blocking java NIO2 connector. *   AJP/1.3 = The APR/native connector.")
  @JsonProperty(JSON_PROPERTY_PROTOCOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProtocolEnum getProtocol() {
    return protocol;
  }


  @JsonProperty(JSON_PROPERTY_PROTOCOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProtocol(ProtocolEnum protocol) {
    this.protocol = protocol;
  }


  public ServerConfigConnector proxy(ServerConfigProxy proxy) {
    
    this.proxy = proxy;
    return this;
  }

  /**
   * Get proxy
   * @return proxy
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PROXY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigProxy getProxy() {
    return proxy;
  }


  @JsonProperty(JSON_PROPERTY_PROXY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProxy(ServerConfigProxy proxy) {
    this.proxy = proxy;
  }


  public ServerConfigConnector ssl(ServerConfigSSL ssl) {
    
    this.ssl = ssl;
    return this;
  }

  /**
   * Get ssl
   * @return ssl
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SSL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigSSL getSsl() {
    return ssl;
  }


  @JsonProperty(JSON_PROPERTY_SSL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSsl(ServerConfigSSL ssl) {
    this.ssl = ssl;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServerConfigConnector serverConfigConnector = (ServerConfigConnector) o;
    return Objects.equals(this.address, serverConfigConnector.address) &&
        Objects.equals(this.compressibleMimeType, serverConfigConnector.compressibleMimeType) &&
        Objects.equals(this.compression, serverConfigConnector.compression) &&
        Objects.equals(this.compressionMinSize, serverConfigConnector.compressionMinSize) &&
        Objects.equals(this._configuration, serverConfigConnector._configuration) &&
        Objects.equals(this.enabled, serverConfigConnector.enabled) &&
        Objects.equals(this.port, serverConfigConnector.port) &&
        Objects.equals(this.protocol, serverConfigConnector.protocol) &&
        Objects.equals(this.proxy, serverConfigConnector.proxy) &&
        Objects.equals(this.ssl, serverConfigConnector.ssl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, compressibleMimeType, compression, compressionMinSize, _configuration, enabled, port, protocol, proxy, ssl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServerConfigConnector {\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    compressibleMimeType: ").append(toIndentedString(compressibleMimeType)).append("\n");
    sb.append("    compression: ").append(toIndentedString(compression)).append("\n");
    sb.append("    compressionMinSize: ").append(toIndentedString(compressionMinSize)).append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    port: ").append(toIndentedString(port)).append("\n");
    sb.append("    protocol: ").append(toIndentedString(protocol)).append("\n");
    sb.append("    proxy: ").append(toIndentedString(proxy)).append("\n");
    sb.append("    ssl: ").append(toIndentedString(ssl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
