/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Configures an [APR Lifecycle Listener](https://tomcat.apache.org/tomcat-10.0-doc/config/listeners.html) for the underlying tomcat server.
 */
@Schema(description = "Configures an [APR Lifecycle Listener](https://tomcat.apache.org/tomcat-10.0-doc/config/listeners.html) for the underlying tomcat server.")
@JsonPropertyOrder({
  ServerConfigApr.JSON_PROPERTY_ENABLED,
  ServerConfigApr.JSON_PROPERTY_FIPS_MODE,
  ServerConfigApr.JSON_PROPERTY_SSL_ENGINE,
  ServerConfigApr.JSON_PROPERTY_SSL_RANDOM_SEED,
  ServerConfigApr.JSON_PROPERTY_USE_APR_CONNECTOR,
  ServerConfigApr.JSON_PROPERTY_USE_OPEN_S_S_L
})
@JsonTypeName("ServerConfig_Apr")

public class ServerConfigApr {
  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = false;

  public static final String JSON_PROPERTY_FIPS_MODE = "fipsMode";
  private String fipsMode = "off";

  public static final String JSON_PROPERTY_SSL_ENGINE = "sslEngine";
  private String sslEngine = "on";

  public static final String JSON_PROPERTY_SSL_RANDOM_SEED = "sslRandomSeed";
  private String sslRandomSeed = "builtin";

  public static final String JSON_PROPERTY_USE_APR_CONNECTOR = "useAprConnector";
  private Boolean useAprConnector = false;

  public static final String JSON_PROPERTY_USE_OPEN_S_S_L = "useOpenSSL";
  private Boolean useOpenSSL = true;

  public ServerConfigApr() {
  }

  public ServerConfigApr enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

  /**
   * When set to true, the APR Lifecycle Listener shall be activated.
   * @return enabled
   **/
  @Nullable
  @Schema(name = "When set to true, the APR Lifecycle Listener shall be activated.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public ServerConfigApr fipsMode(String fipsMode) {
    
    this.fipsMode = fipsMode;
    return this;
  }

  /**
   * Set this to \&quot;on\&quot; to request SSL to operate in FIPS (Federal Information Processing Standards) mode.  *   \&quot;enter\&quot; to force OpenSSL to enter FIPS mode. *   \&quot;require\&quot; to require that OpenSSL already operates in FIPS mode. *   \&quot;off\&quot; to disable the FIPS mode.  For this to take effect \&quot;useOpenSSL\&quot; must be set to true. (It is highly recommended to refer to https://tomcat.apache.org/tomcat-10.0-doc/config/listeners.html)
   * @return fipsMode
   **/
  @Nullable
  @Schema(name = "Set this to \"on\" to request SSL to operate in FIPS (Federal Information Processing Standards) mode.  *   \"enter\" to force OpenSSL to enter FIPS mode. *   \"require\" to require that OpenSSL already operates in FIPS mode. *   \"off\" to disable the FIPS mode.  For this to take effect \"useOpenSSL\" must be set to true. (It is highly recommended to refer to https://tomcat.apache.org/tomcat-10.0-doc/config/listeners.html)")
  @JsonProperty(JSON_PROPERTY_FIPS_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFipsMode() {
    return fipsMode;
  }


  @JsonProperty(JSON_PROPERTY_FIPS_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFipsMode(String fipsMode) {
    this.fipsMode = fipsMode;
  }


  public ServerConfigApr sslEngine(String sslEngine) {
    
    this.sslEngine = sslEngine;
    return this;
  }

  /**
   * Selects the [SSL](https://www.openssl.org/) engine to use, possible values are \&quot;off\&quot; (do not use SSL) \&quot;on\&quot; (use SSL without specifying the engine).
   * @return sslEngine
   **/
  @Nullable
  @Schema(name = "Selects the [SSL](https://www.openssl.org/) engine to use, possible values are \"off\" (do not use SSL) \"on\" (use SSL without specifying the engine).")
  @JsonProperty(JSON_PROPERTY_SSL_ENGINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSslEngine() {
    return sslEngine;
  }


  @JsonProperty(JSON_PROPERTY_SSL_ENGINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSslEngine(String sslEngine) {
    this.sslEngine = sslEngine;
  }


  public ServerConfigApr sslRandomSeed(String sslRandomSeed) {
    
    this.sslRandomSeed = sslRandomSeed;
    return this;
  }

  /**
   * An entropy source to seed the SSL engine&#39;s random number generation with. To allow for quicker start time, set this to \&quot;/dev/urandom\&quot;.
   * @return sslRandomSeed
   **/
  @Nullable
  @Schema(name = "An entropy source to seed the SSL engine's random number generation with. To allow for quicker start time, set this to \"/dev/urandom\".")
  @JsonProperty(JSON_PROPERTY_SSL_RANDOM_SEED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSslRandomSeed() {
    return sslRandomSeed;
  }


  @JsonProperty(JSON_PROPERTY_SSL_RANDOM_SEED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSslRandomSeed(String sslRandomSeed) {
    this.sslRandomSeed = sslRandomSeed;
  }


  public ServerConfigApr useAprConnector(Boolean useAprConnector) {
    
    this.useAprConnector = useAprConnector;
    return this;
  }

  /**
   * This field currently is unused.
   * @return useAprConnector
   **/
  @Nullable
  @Schema(name = "This field currently is unused.")
  @JsonProperty(JSON_PROPERTY_USE_APR_CONNECTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseAprConnector() {
    return useAprConnector;
  }


  @JsonProperty(JSON_PROPERTY_USE_APR_CONNECTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseAprConnector(Boolean useAprConnector) {
    this.useAprConnector = useAprConnector;
  }


  public ServerConfigApr useOpenSSL(Boolean useOpenSSL) {
    
    this.useOpenSSL = useOpenSSL;
    return this;
  }

  /**
   * When set to true this activates the usage of OpenSSL for NIO and NIO2 connectors.
   * @return useOpenSSL
   **/
  @Nullable
  @Schema(name = "When set to true this activates the usage of OpenSSL for NIO and NIO2 connectors.")
  @JsonProperty(JSON_PROPERTY_USE_OPEN_S_S_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseOpenSSL() {
    return useOpenSSL;
  }


  @JsonProperty(JSON_PROPERTY_USE_OPEN_S_S_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseOpenSSL(Boolean useOpenSSL) {
    this.useOpenSSL = useOpenSSL;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServerConfigApr serverConfigApr = (ServerConfigApr) o;
    return Objects.equals(this.enabled, serverConfigApr.enabled) &&
        Objects.equals(this.fipsMode, serverConfigApr.fipsMode) &&
        Objects.equals(this.sslEngine, serverConfigApr.sslEngine) &&
        Objects.equals(this.sslRandomSeed, serverConfigApr.sslRandomSeed) &&
        Objects.equals(this.useAprConnector, serverConfigApr.useAprConnector) &&
        Objects.equals(this.useOpenSSL, serverConfigApr.useOpenSSL);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enabled, fipsMode, sslEngine, sslRandomSeed, useAprConnector, useOpenSSL);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServerConfigApr {\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    fipsMode: ").append(toIndentedString(fipsMode)).append("\n");
    sb.append("    sslEngine: ").append(toIndentedString(sslEngine)).append("\n");
    sb.append("    sslRandomSeed: ").append(toIndentedString(sslRandomSeed)).append("\n");
    sb.append("    useAprConnector: ").append(toIndentedString(useAprConnector)).append("\n");
    sb.append("    useOpenSSL: ").append(toIndentedString(useOpenSSL)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
