/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The image operation element can be used to export a document as an image.
 */
@Schema(description = "The image operation element can be used to export a document as an image.")
@JsonPropertyOrder({
  OperationToolboxImageImage.JSON_PROPERTY_BMP,
  OperationToolboxImageImage.JSON_PROPERTY_FILE_NAME_TEMPLATE,
  OperationToolboxImageImage.JSON_PROPERTY_GIF,
  OperationToolboxImageImage.JSON_PROPERTY_JPEG,
  OperationToolboxImageImage.JSON_PROPERTY_PAGES,
  OperationToolboxImageImage.JSON_PROPERTY_PNG,
  OperationToolboxImageImage.JSON_PROPERTY_SVG,
  OperationToolboxImageImage.JSON_PROPERTY_TIFF
})
@JsonTypeName("Operation_ToolboxImage_image")

public class OperationToolboxImageImage {
  public static final String JSON_PROPERTY_BMP = "bmp";
  private OperationBmp bmp;

  public static final String JSON_PROPERTY_FILE_NAME_TEMPLATE = "fileNameTemplate";
  private String fileNameTemplate = "page[%d]";

  public static final String JSON_PROPERTY_GIF = "gif";
  private OperationGif gif;

  public static final String JSON_PROPERTY_JPEG = "jpeg";
  private OperationJpeg jpeg;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private String pages = "1";

  public static final String JSON_PROPERTY_PNG = "png";
  private OperationPng png;

  public static final String JSON_PROPERTY_SVG = "svg";
  private OperationSvg svg;

  public static final String JSON_PROPERTY_TIFF = "tiff";
  private OperationTiff tiff;

  public OperationToolboxImageImage() {
  }

  public OperationToolboxImageImage bmp(OperationBmp bmp) {
    
    this.bmp = bmp;
    return this;
  }

  /**
   * Get bmp
   * @return bmp
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_BMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationBmp getBmp() {
    return bmp;
  }


  @JsonProperty(JSON_PROPERTY_BMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBmp(OperationBmp bmp) {
    this.bmp = bmp;
  }


  public OperationToolboxImageImage fileNameTemplate(String fileNameTemplate) {
    
    this.fileNameTemplate = fileNameTemplate;
    return this;
  }

  /**
   * When exporting multiple pages, this parameter is used to define the file name that will be used for the generated image files in the ZIP file. The file name must include the string \&quot;%d\&quot;. This string will be replaced with a consecutive number in the file name.
   * @return fileNameTemplate
   **/
  @Nullable
  @Schema(name = "When exporting multiple pages, this parameter is used to define the file name that will be used for the generated image files in the ZIP file. The file name must include the string \"%d\". This string will be replaced with a consecutive number in the file name.")
  @JsonProperty(JSON_PROPERTY_FILE_NAME_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileNameTemplate() {
    return fileNameTemplate;
  }


  @JsonProperty(JSON_PROPERTY_FILE_NAME_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileNameTemplate(String fileNameTemplate) {
    this.fileNameTemplate = fileNameTemplate;
  }


  public OperationToolboxImageImage gif(OperationGif gif) {
    
    this.gif = gif;
    return this;
  }

  /**
   * Get gif
   * @return gif
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_GIF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationGif getGif() {
    return gif;
  }


  @JsonProperty(JSON_PROPERTY_GIF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGif(OperationGif gif) {
    this.gif = gif;
  }


  public OperationToolboxImageImage jpeg(OperationJpeg jpeg) {
    
    this.jpeg = jpeg;
    return this;
  }

  /**
   * Get jpeg
   * @return jpeg
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_JPEG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationJpeg getJpeg() {
    return jpeg;
  }


  @JsonProperty(JSON_PROPERTY_JPEG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJpeg(OperationJpeg jpeg) {
    this.jpeg = jpeg;
  }


  public OperationToolboxImageImage pages(String pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * Used to define the page number or page range (e.g., \&quot;1,5-6,9\&quot;) that should be converted to an image file format. If only a single page is defined, the image file will be returned directly. If a range of pages is declared, then the call will return a ZIP file containing all the exported pages. The name of the individual image file (when multiple pages are exported) is defined with the \&quot;fileNameTemplate\&quot; attribute. The \&quot;tif\&quot; format is an exception when exporting multiple pages. When using this format, the \&quot;multipage\&quot; attribute can be used to define whether a multipage TIFF will be generated or whether the individual pages will be exported to a ZIP file (as with the other image file formats).
   * @return pages
   **/
  @Nullable
  @Schema(name = "Used to define the page number or page range (e.g., \"1,5-6,9\") that should be converted to an image file format. If only a single page is defined, the image file will be returned directly. If a range of pages is declared, then the call will return a ZIP file containing all the exported pages. The name of the individual image file (when multiple pages are exported) is defined with the \"fileNameTemplate\" attribute. The \"tif\" format is an exception when exporting multiple pages. When using this format, the \"multipage\" attribute can be used to define whether a multipage TIFF will be generated or whether the individual pages will be exported to a ZIP file (as with the other image file formats).")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(String pages) {
    this.pages = pages;
  }


  public OperationToolboxImageImage png(OperationPng png) {
    
    this.png = png;
    return this;
  }

  /**
   * Get png
   * @return png
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PNG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationPng getPng() {
    return png;
  }


  @JsonProperty(JSON_PROPERTY_PNG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPng(OperationPng png) {
    this.png = png;
  }


  public OperationToolboxImageImage svg(OperationSvg svg) {
    
    this.svg = svg;
    return this;
  }

  /**
   * Get svg
   * @return svg
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SVG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSvg getSvg() {
    return svg;
  }


  @JsonProperty(JSON_PROPERTY_SVG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSvg(OperationSvg svg) {
    this.svg = svg;
  }


  public OperationToolboxImageImage tiff(OperationTiff tiff) {
    
    this.tiff = tiff;
    return this;
  }

  /**
   * Get tiff
   * @return tiff
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TIFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationTiff getTiff() {
    return tiff;
  }


  @JsonProperty(JSON_PROPERTY_TIFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTiff(OperationTiff tiff) {
    this.tiff = tiff;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationToolboxImageImage operationToolboxImageImage = (OperationToolboxImageImage) o;
    return Objects.equals(this.bmp, operationToolboxImageImage.bmp) &&
        Objects.equals(this.fileNameTemplate, operationToolboxImageImage.fileNameTemplate) &&
        Objects.equals(this.gif, operationToolboxImageImage.gif) &&
        Objects.equals(this.jpeg, operationToolboxImageImage.jpeg) &&
        Objects.equals(this.pages, operationToolboxImageImage.pages) &&
        Objects.equals(this.png, operationToolboxImageImage.png) &&
        Objects.equals(this.svg, operationToolboxImageImage.svg) &&
        Objects.equals(this.tiff, operationToolboxImageImage.tiff);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bmp, fileNameTemplate, gif, jpeg, pages, png, svg, tiff);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationToolboxImageImage {\n");
    sb.append("    bmp: ").append(toIndentedString(bmp)).append("\n");
    sb.append("    fileNameTemplate: ").append(toIndentedString(fileNameTemplate)).append("\n");
    sb.append("    gif: ").append(toIndentedString(gif)).append("\n");
    sb.append("    jpeg: ").append(toIndentedString(jpeg)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    png: ").append(toIndentedString(png)).append("\n");
    sb.append("    svg: ").append(toIndentedString(svg)).append("\n");
    sb.append("    tiff: ").append(toIndentedString(tiff)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
