/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines a target TIFF image format.
 */
@Schema(description = "Defines a target TIFF image format.")
@JsonPropertyOrder({
  OperationTiff.JSON_PROPERTY_BLACK_AND_WHITE_QUALITY,
  OperationTiff.JSON_PROPERTY_COMPRESSION,
  OperationTiff.JSON_PROPERTY_DPI,
  OperationTiff.JSON_PROPERTY_HEIGHT,
  OperationTiff.JSON_PROPERTY_JPEG_QUALITY,
  OperationTiff.JSON_PROPERTY_METRICS,
  OperationTiff.JSON_PROPERTY_MULTIPAGE,
  OperationTiff.JSON_PROPERTY_WIDTH
})
@JsonTypeName("Operation_Tiff")

public class OperationTiff {
  /**
   * For \&quot;tif\&quot; exports, this parameter is used to define the quality of black-and-white images if \&quot;group3\&quot; or \&quot;group4\&quot; is used as a compression method. The higher the quality, the more time that will be required in order to render the image:  *   low &#x3D; Direct conversion (best reserved for \&quot;text only\&quot; content) *   middle &#x3D; A diffusion filter will be applied to the image before conversion *   high &#x3D; Greyscale conversion and a diffusion filter will be applied to the image before conversion
   */
  public enum BlackAndWhiteQualityEnum {
    LOW(String.valueOf("low")),
    
    MIDDLE(String.valueOf("middle")),
    
    HIGH(String.valueOf("high"));

    private String value;

    BlackAndWhiteQualityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static BlackAndWhiteQualityEnum fromValue(String value) {
      for (BlackAndWhiteQualityEnum b : BlackAndWhiteQualityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_BLACK_AND_WHITE_QUALITY = "blackAndWhiteQuality";
  private BlackAndWhiteQualityEnum blackAndWhiteQuality = BlackAndWhiteQualityEnum.HIGH;

  /**
   * This parameter is used to specify the compression method when exporting pages as \&quot;tif\&quot; images. The following values are available:  *   none &#x3D; No compression *   rle &#x3D; TIFF CCITT Modified Huffman RLE compression *   deflate &#x3D; TIFF Deflate lossless compression (Zip-in-TIFF). *   group3 &#x3D; TIFF CCITT Group 3 fax encoding *   group4 &#x3D; TIFF CCITT Group 4 fax encoding *   jpeg &#x3D; TIFF JPEG-in-TIFF compression *   lzw &#x3D; TIFF LZW compression *   packbits &#x3D; TIFF Byte-oriented run-length encoding \&quot;PackBits\&quot; compression *   zlib &#x3D; TIFF ZLib compression
   */
  public enum CompressionEnum {
    NONE(String.valueOf("none")),
    
    RLE(String.valueOf("rle")),
    
    DEFLATE(String.valueOf("deflate")),
    
    GROUP3(String.valueOf("group3")),
    
    GROUP4(String.valueOf("group4")),
    
    JPEG(String.valueOf("jpeg")),
    
    LZW(String.valueOf("lzw")),
    
    PACKBITS(String.valueOf("packbits")),
    
    ZLIB(String.valueOf("zlib"));

    private String value;

    CompressionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CompressionEnum fromValue(String value) {
      for (CompressionEnum b : CompressionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_COMPRESSION = "compression";
  private CompressionEnum compression = CompressionEnum.NONE;

  public static final String JSON_PROPERTY_DPI = "dpi";
  private Integer dpi = 72;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Integer height = 0;

  public static final String JSON_PROPERTY_JPEG_QUALITY = "jpegQuality";
  private Integer jpegQuality = 80;

  /**
   * Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt &#x3D; Points(1/72 inch) *   pc &#x3D; Picas(12 points) *   px &#x3D; Pixels(1/96 inch) *   mm &#x3D; Millimeters *   in &#x3D; Inches
   */
  public enum MetricsEnum {
    PT(String.valueOf("pt")),
    
    PC(String.valueOf("pc")),
    
    PX(String.valueOf("px")),
    
    MM(String.valueOf("mm")),
    
    IN(String.valueOf("in"));

    private String value;

    MetricsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MetricsEnum fromValue(String value) {
      for (MetricsEnum b : MetricsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_METRICS = "metrics";
  private MetricsEnum metrics = MetricsEnum.MM;

  public static final String JSON_PROPERTY_MULTIPAGE = "multipage";
  private Boolean multipage = false;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Integer width = 0;

  public OperationTiff() {
  }

  public OperationTiff blackAndWhiteQuality(BlackAndWhiteQualityEnum blackAndWhiteQuality) {
    
    this.blackAndWhiteQuality = blackAndWhiteQuality;
    return this;
  }

  /**
   * For \&quot;tif\&quot; exports, this parameter is used to define the quality of black-and-white images if \&quot;group3\&quot; or \&quot;group4\&quot; is used as a compression method. The higher the quality, the more time that will be required in order to render the image:  *   low &#x3D; Direct conversion (best reserved for \&quot;text only\&quot; content) *   middle &#x3D; A diffusion filter will be applied to the image before conversion *   high &#x3D; Greyscale conversion and a diffusion filter will be applied to the image before conversion
   * @return blackAndWhiteQuality
   **/
  @Nullable
  @Schema(name = "For \"tif\" exports, this parameter is used to define the quality of black-and-white images if \"group3\" or \"group4\" is used as a compression method. The higher the quality, the more time that will be required in order to render the image:  *   low = Direct conversion (best reserved for \"text only\" content) *   middle = A diffusion filter will be applied to the image before conversion *   high = Greyscale conversion and a diffusion filter will be applied to the image before conversion")
  @JsonProperty(JSON_PROPERTY_BLACK_AND_WHITE_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BlackAndWhiteQualityEnum getBlackAndWhiteQuality() {
    return blackAndWhiteQuality;
  }


  @JsonProperty(JSON_PROPERTY_BLACK_AND_WHITE_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBlackAndWhiteQuality(BlackAndWhiteQualityEnum blackAndWhiteQuality) {
    this.blackAndWhiteQuality = blackAndWhiteQuality;
  }


  public OperationTiff compression(CompressionEnum compression) {
    
    this.compression = compression;
    return this;
  }

  /**
   * This parameter is used to specify the compression method when exporting pages as \&quot;tif\&quot; images. The following values are available:  *   none &#x3D; No compression *   rle &#x3D; TIFF CCITT Modified Huffman RLE compression *   deflate &#x3D; TIFF Deflate lossless compression (Zip-in-TIFF). *   group3 &#x3D; TIFF CCITT Group 3 fax encoding *   group4 &#x3D; TIFF CCITT Group 4 fax encoding *   jpeg &#x3D; TIFF JPEG-in-TIFF compression *   lzw &#x3D; TIFF LZW compression *   packbits &#x3D; TIFF Byte-oriented run-length encoding \&quot;PackBits\&quot; compression *   zlib &#x3D; TIFF ZLib compression
   * @return compression
   **/
  @Nullable
  @Schema(name = "This parameter is used to specify the compression method when exporting pages as \"tif\" images. The following values are available:  *   none = No compression *   rle = TIFF CCITT Modified Huffman RLE compression *   deflate = TIFF Deflate lossless compression (Zip-in-TIFF). *   group3 = TIFF CCITT Group 3 fax encoding *   group4 = TIFF CCITT Group 4 fax encoding *   jpeg = TIFF JPEG-in-TIFF compression *   lzw = TIFF LZW compression *   packbits = TIFF Byte-oriented run-length encoding \"PackBits\" compression *   zlib = TIFF ZLib compression")
  @JsonProperty(JSON_PROPERTY_COMPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CompressionEnum getCompression() {
    return compression;
  }


  @JsonProperty(JSON_PROPERTY_COMPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompression(CompressionEnum compression) {
    this.compression = compression;
  }


  public OperationTiff dpi(Integer dpi) {
    
    this.dpi = dpi;
    return this;
  }

  /**
   * This parameter is used to define the image&#39;s DPI resolution. The larger the value, the larger the image&#39;s x, y resolution. In addition, the larger the DPI resolution, the larger the size of the image file.
   * minimum: 0
   * maximum: 9600
   * @return dpi
   **/
  @Nullable
  @Schema(name = "This parameter is used to define the image's DPI resolution. The larger the value, the larger the image's x, y resolution. In addition, the larger the DPI resolution, the larger the size of the image file.")
  @JsonProperty(JSON_PROPERTY_DPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDpi() {
    return dpi;
  }


  @JsonProperty(JSON_PROPERTY_DPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDpi(Integer dpi) {
    this.dpi = dpi;
  }


  public OperationTiff height(Integer height) {
    
    this.height = height;
    return this;
  }

  /**
   * Used to limit the maximum height of the exported image. 0 &#x3D; No restriction
   * minimum: 0
   * @return height
   **/
  @Nullable
  @Schema(name = "Used to limit the maximum height of the exported image. 0 = No restriction")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeight(Integer height) {
    this.height = height;
  }


  public OperationTiff jpegQuality(Integer jpegQuality) {
    
    this.jpegQuality = jpegQuality;
    return this;
  }

  /**
   * When exporting to \&quot;jpg\&quot; format, this parameter can be used to define the image&#39;s quality as a percentage. The value must fall between 0 and 100. The larger the value, the better the quality and the lower the compression level.
   * minimum: 0
   * maximum: 100
   * @return jpegQuality
   **/
  @Nullable
  @Schema(name = "When exporting to \"jpg\" format, this parameter can be used to define the image's quality as a percentage. The value must fall between 0 and 100. The larger the value, the better the quality and the lower the compression level.")
  @JsonProperty(JSON_PROPERTY_JPEG_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getJpegQuality() {
    return jpegQuality;
  }


  @JsonProperty(JSON_PROPERTY_JPEG_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJpegQuality(Integer jpegQuality) {
    this.jpegQuality = jpegQuality;
  }


  public OperationTiff metrics(MetricsEnum metrics) {
    
    this.metrics = metrics;
    return this;
  }

  /**
   * Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt &#x3D; Points(1/72 inch) *   pc &#x3D; Picas(12 points) *   px &#x3D; Pixels(1/96 inch) *   mm &#x3D; Millimeters *   in &#x3D; Inches
   * @return metrics
   **/
  @Nullable
  @Schema(name = "Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
  @JsonProperty(JSON_PROPERTY_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetricsEnum getMetrics() {
    return metrics;
  }


  @JsonProperty(JSON_PROPERTY_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetrics(MetricsEnum metrics) {
    this.metrics = metrics;
  }


  public OperationTiff multipage(Boolean multipage) {
    
    this.multipage = multipage;
    return this;
  }

  /**
   * If \&quot;true,\&quot; a \&quot;multi-page TIFF\&quot; will be created when multiple pages are exported as \&quot;tif\&quot; images. All the pages will be exported to a single file, and a ZIP file with individual images will not be generated.
   * @return multipage
   **/
  @Nullable
  @Schema(name = "If \"true,\" a \"multi-page TIFF\" will be created when multiple pages are exported as \"tif\" images. All the pages will be exported to a single file, and a ZIP file with individual images will not be generated.")
  @JsonProperty(JSON_PROPERTY_MULTIPAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMultipage() {
    return multipage;
  }


  @JsonProperty(JSON_PROPERTY_MULTIPAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultipage(Boolean multipage) {
    this.multipage = multipage;
  }


  public OperationTiff width(Integer width) {
    
    this.width = width;
    return this;
  }

  /**
   * Used to limit the maximum width of the exported image. 0 &#x3D; No restriction
   * minimum: 0
   * @return width
   **/
  @Nullable
  @Schema(name = "Used to limit the maximum width of the exported image. 0 = No restriction")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWidth(Integer width) {
    this.width = width;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationTiff operationTiff = (OperationTiff) o;
    return Objects.equals(this.blackAndWhiteQuality, operationTiff.blackAndWhiteQuality) &&
        Objects.equals(this.compression, operationTiff.compression) &&
        Objects.equals(this.dpi, operationTiff.dpi) &&
        Objects.equals(this.height, operationTiff.height) &&
        Objects.equals(this.jpegQuality, operationTiff.jpegQuality) &&
        Objects.equals(this.metrics, operationTiff.metrics) &&
        Objects.equals(this.multipage, operationTiff.multipage) &&
        Objects.equals(this.width, operationTiff.width);
  }

  @Override
  public int hashCode() {
    return Objects.hash(blackAndWhiteQuality, compression, dpi, height, jpegQuality, metrics, multipage, width);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationTiff {\n");
    sb.append("    blackAndWhiteQuality: ").append(toIndentedString(blackAndWhiteQuality)).append("\n");
    sb.append("    compression: ").append(toIndentedString(compression)).append("\n");
    sb.append("    dpi: ").append(toIndentedString(dpi)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    jpegQuality: ").append(toIndentedString(jpegQuality)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("    multipage: ").append(toIndentedString(multipage)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
