/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Selects parameters for the creation of SVGs, possibly contained in resulting documents.
 */
@Schema(description = "Selects parameters for the creation of SVGs, possibly contained in resulting documents.")
@JsonPropertyOrder({
  OperationSvgFormat.JSON_PROPERTY_DECIMAL_PRECISION,
  OperationSvgFormat.JSON_PROPERTY_GRAPHICS_STATE_MODE,
  OperationSvgFormat.JSON_PROPERTY_PATH_DRAW_MODE
})
@JsonTypeName("Operation_SvgFormat")

public class OperationSvgFormat {
  public static final String JSON_PROPERTY_DECIMAL_PRECISION = "decimalPrecision";
  private Integer decimalPrecision = 2;

  /**
   * Selects the SVG syntax used for formatting graphics states.  *   verbose &#x3D; Writes verbose graphics states and groups and always prefers direct path definitions. *   centralize &#x3D; Writes compact graphics states and groups and centralizes formatting instructions, also utilizes the \&quot;use\&quot; syntax to prepare and reference indirect paths. (May not be readable by some SVG viewers.)
   */
  public enum GraphicsStateModeEnum {
    VERBOSE(String.valueOf("verbose")),
    
    CENTRALIZE(String.valueOf("centralize"));

    private String value;

    GraphicsStateModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static GraphicsStateModeEnum fromValue(String value) {
      for (GraphicsStateModeEnum b : GraphicsStateModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_GRAPHICS_STATE_MODE = "graphicsStateMode";
  private GraphicsStateModeEnum graphicsStateMode = GraphicsStateModeEnum.CENTRALIZE;

  /**
   * Selects the SVG syntax used for formatting paths.  *   verbose &#x3D; Writes verbose paths, containing a human readable complete and simple syntax. *   compress &#x3D; Compresses path draw instructions, by applying the EBNF (Extended Backus Naur Form).
   */
  public enum PathDrawModeEnum {
    VERBOSE(String.valueOf("verbose")),
    
    COMPACT(String.valueOf("compact"));

    private String value;

    PathDrawModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PathDrawModeEnum fromValue(String value) {
      for (PathDrawModeEnum b : PathDrawModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PATH_DRAW_MODE = "pathDrawMode";
  private PathDrawModeEnum pathDrawMode = PathDrawModeEnum.COMPACT;

  public OperationSvgFormat() {
  }

  public OperationSvgFormat decimalPrecision(Integer decimalPrecision) {
    
    this.decimalPrecision = decimalPrecision;
    return this;
  }

  /**
   * Selects the number of decimal places for numeric values of contained SVGs.  **Important:** The number of decimal places directly influences the size of the resulting file. (should SVGs be contained.) However: Higher values will result in a better SVG quality.
   * minimum: 0
   * maximum: 10
   * @return decimalPrecision
   **/
  @Nullable
  @Schema(name = "Selects the number of decimal places for numeric values of contained SVGs.  **Important:** The number of decimal places directly influences the size of the resulting file. (should SVGs be contained.) However: Higher values will result in a better SVG quality.")
  @JsonProperty(JSON_PROPERTY_DECIMAL_PRECISION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDecimalPrecision() {
    return decimalPrecision;
  }


  @JsonProperty(JSON_PROPERTY_DECIMAL_PRECISION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecimalPrecision(Integer decimalPrecision) {
    this.decimalPrecision = decimalPrecision;
  }


  public OperationSvgFormat graphicsStateMode(GraphicsStateModeEnum graphicsStateMode) {
    
    this.graphicsStateMode = graphicsStateMode;
    return this;
  }

  /**
   * Selects the SVG syntax used for formatting graphics states.  *   verbose &#x3D; Writes verbose graphics states and groups and always prefers direct path definitions. *   centralize &#x3D; Writes compact graphics states and groups and centralizes formatting instructions, also utilizes the \&quot;use\&quot; syntax to prepare and reference indirect paths. (May not be readable by some SVG viewers.)
   * @return graphicsStateMode
   **/
  @Nullable
  @Schema(name = "Selects the SVG syntax used for formatting graphics states.  *   verbose = Writes verbose graphics states and groups and always prefers direct path definitions. *   centralize = Writes compact graphics states and groups and centralizes formatting instructions, also utilizes the \"use\" syntax to prepare and reference indirect paths. (May not be readable by some SVG viewers.)")
  @JsonProperty(JSON_PROPERTY_GRAPHICS_STATE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GraphicsStateModeEnum getGraphicsStateMode() {
    return graphicsStateMode;
  }


  @JsonProperty(JSON_PROPERTY_GRAPHICS_STATE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGraphicsStateMode(GraphicsStateModeEnum graphicsStateMode) {
    this.graphicsStateMode = graphicsStateMode;
  }


  public OperationSvgFormat pathDrawMode(PathDrawModeEnum pathDrawMode) {
    
    this.pathDrawMode = pathDrawMode;
    return this;
  }

  /**
   * Selects the SVG syntax used for formatting paths.  *   verbose &#x3D; Writes verbose paths, containing a human readable complete and simple syntax. *   compress &#x3D; Compresses path draw instructions, by applying the EBNF (Extended Backus Naur Form).
   * @return pathDrawMode
   **/
  @Nullable
  @Schema(name = "Selects the SVG syntax used for formatting paths.  *   verbose = Writes verbose paths, containing a human readable complete and simple syntax. *   compress = Compresses path draw instructions, by applying the EBNF (Extended Backus Naur Form).")
  @JsonProperty(JSON_PROPERTY_PATH_DRAW_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PathDrawModeEnum getPathDrawMode() {
    return pathDrawMode;
  }


  @JsonProperty(JSON_PROPERTY_PATH_DRAW_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPathDrawMode(PathDrawModeEnum pathDrawMode) {
    this.pathDrawMode = pathDrawMode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationSvgFormat operationSvgFormat = (OperationSvgFormat) o;
    return Objects.equals(this.decimalPrecision, operationSvgFormat.decimalPrecision) &&
        Objects.equals(this.graphicsStateMode, operationSvgFormat.graphicsStateMode) &&
        Objects.equals(this.pathDrawMode, operationSvgFormat.pathDrawMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decimalPrecision, graphicsStateMode, pathDrawMode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationSvgFormat {\n");
    sb.append("    decimalPrecision: ").append(toIndentedString(decimalPrecision)).append("\n");
    sb.append("    graphicsStateMode: ").append(toIndentedString(graphicsStateMode)).append("\n");
    sb.append("    pathDrawMode: ").append(toIndentedString(pathDrawMode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
