/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Contains the BASE64 encoded file that should be inserted or appended. The \&quot;format\&quot; attribute is used to define whether the file is a single PDF document, a ZIP file containing multiple PDF documents or a list of documents references by ID. If a ZIP archive is passed as the source document of the web service request, this parameter can be omitted. The parameter \&quot;sourceIsZip\&quot; must be set to \&quot;true\&quot; in that case.
 */
@Schema(description = "Contains the BASE64 encoded file that should be inserted or appended. The \"format\" attribute is used to define whether the file is a single PDF document, a ZIP file containing multiple PDF documents or a list of documents references by ID. If a ZIP archive is passed as the source document of the web service request, this parameter can be omitted. The parameter \"sourceIsZip\" must be set to \"true\" in that case.")
@JsonPropertyOrder({
  OperationMergeFileData.JSON_PROPERTY_FORMAT,
  OperationMergeFileData.JSON_PROPERTY_OUTLINE_NAME,
  OperationMergeFileData.JSON_PROPERTY_SOURCE,
  OperationMergeFileData.JSON_PROPERTY_URI,
  OperationMergeFileData.JSON_PROPERTY_VALUE
})
@JsonTypeName("Operation_MergeFileData")

public class OperationMergeFileData {
  /**
   * Specifies the format how to pass the documents to be used for merging.  *   pdf &#x3D; A single PDF file *   zip &#x3D; It is a ZIP file that contains one or more PDF documents. *   id &#x3D; It is a semicolon separated list of document ID&#39;s referencing documents already on the server (REST API only).  **Important:** The \&quot;id\&quot; parameter can be used only with REST API. Each document that has been uploaded to the server via REST API has a unique ID. This ID can be used to reference the document. In the content of the \&quot;data\&quot; element, the list is passed as BASE64 content. Example for two documents:  *   List of documents: 3bde686a47284a2da3bfce62bd6bb8bd;f5c2b314d0c74fd0878d1f4ca310b0ad *   BASE64 encoded: M2JkZTY4NmE0NzI4NGEyZGEzYmZjZTYyYmQ2YmI4YmQ7ZjVjMmIzMTRkMGM3NGZkMDg3OGQxZjRjYTMxMGIwYWQ&#x3D;
   */
  public enum FormatEnum {
    PDF(String.valueOf("pdf")),
    
    ZIP(String.valueOf("zip")),
    
    ID(String.valueOf("id"));

    private String value;

    FormatEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FormatEnum fromValue(String value) {
      for (FormatEnum b : FormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FORMAT = "format";
  private FormatEnum format = FormatEnum.PDF;

  public static final String JSON_PROPERTY_OUTLINE_NAME = "outlineName";
  private String outlineName = "";

  /**
   * Selects the data source for the hereby expressed resource. Possible values are:  *   value &#x3D; The element&#39;s value shall contain the BASE64 encoded data. *   uri &#x3D; The data shall be located at the given uri.
   */
  public enum SourceEnum {
    VALUE(String.valueOf("value")),
    
    URI(String.valueOf("uri"));

    private String value;

    SourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SourceEnum fromValue(String value) {
      for (SourceEnum b : SourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SOURCE = "source";
  private SourceEnum source = SourceEnum.VALUE;

  public static final String JSON_PROPERTY_URI = "uri";
  private String uri = "";

  public static final String JSON_PROPERTY_VALUE = "value";
  private byte[] value;

  public OperationMergeFileData() {
  }

  public OperationMergeFileData format(FormatEnum format) {
    
    this.format = format;
    return this;
  }

  /**
   * Specifies the format how to pass the documents to be used for merging.  *   pdf &#x3D; A single PDF file *   zip &#x3D; It is a ZIP file that contains one or more PDF documents. *   id &#x3D; It is a semicolon separated list of document ID&#39;s referencing documents already on the server (REST API only).  **Important:** The \&quot;id\&quot; parameter can be used only with REST API. Each document that has been uploaded to the server via REST API has a unique ID. This ID can be used to reference the document. In the content of the \&quot;data\&quot; element, the list is passed as BASE64 content. Example for two documents:  *   List of documents: 3bde686a47284a2da3bfce62bd6bb8bd;f5c2b314d0c74fd0878d1f4ca310b0ad *   BASE64 encoded: M2JkZTY4NmE0NzI4NGEyZGEzYmZjZTYyYmQ2YmI4YmQ7ZjVjMmIzMTRkMGM3NGZkMDg3OGQxZjRjYTMxMGIwYWQ&#x3D;
   * @return format
   **/
  @Nullable
  @Schema(name = "Specifies the format how to pass the documents to be used for merging.  *   pdf = A single PDF file *   zip = It is a ZIP file that contains one or more PDF documents. *   id = It is a semicolon separated list of document ID's referencing documents already on the server (REST API only).  **Important:** The \"id\" parameter can be used only with REST API. Each document that has been uploaded to the server via REST API has a unique ID. This ID can be used to reference the document. In the content of the \"data\" element, the list is passed as BASE64 content. Example for two documents:  *   List of documents: 3bde686a47284a2da3bfce62bd6bb8bd;f5c2b314d0c74fd0878d1f4ca310b0ad *   BASE64 encoded: M2JkZTY4NmE0NzI4NGEyZGEzYmZjZTYyYmQ2YmI4YmQ7ZjVjMmIzMTRkMGM3NGZkMDg3OGQxZjRjYTMxMGIwYWQ=")
  @JsonProperty(JSON_PROPERTY_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FormatEnum getFormat() {
    return format;
  }


  @JsonProperty(JSON_PROPERTY_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormat(FormatEnum format) {
    this.format = format;
  }


  public OperationMergeFileData outlineName(String outlineName) {
    
    this.outlineName = outlineName;
    return this;
  }

  /**
   * Used to define the base path that should be used for outline nodes of the appended document. This parameter can contain a slash separated path and should ideally end with the name of the document (\&quot;A/B/filename\&quot;). If this parameter is not set, all outlines will be appended to the root outline node.
   * @return outlineName
   **/
  @Nullable
  @Schema(name = "Used to define the base path that should be used for outline nodes of the appended document. This parameter can contain a slash separated path and should ideally end with the name of the document (\"A/B/filename\"). If this parameter is not set, all outlines will be appended to the root outline node.")
  @JsonProperty(JSON_PROPERTY_OUTLINE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOutlineName() {
    return outlineName;
  }


  @JsonProperty(JSON_PROPERTY_OUTLINE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOutlineName(String outlineName) {
    this.outlineName = outlineName;
  }


  public OperationMergeFileData source(SourceEnum source) {
    
    this.source = source;
    return this;
  }

  /**
   * Selects the data source for the hereby expressed resource. Possible values are:  *   value &#x3D; The element&#39;s value shall contain the BASE64 encoded data. *   uri &#x3D; The data shall be located at the given uri.
   * @return source
   **/
  @Nullable
  @Schema(name = "Selects the data source for the hereby expressed resource. Possible values are:  *   value = The element's value shall contain the BASE64 encoded data. *   uri = The data shall be located at the given uri.")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SourceEnum getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSource(SourceEnum source) {
    this.source = source;
  }


  public OperationMergeFileData uri(String uri) {
    
    this.uri = uri;
    return this;
  }

  /**
   * The uri the data shall be located at. (This shall only have effect, if the \&quot;source\&quot; is \&quot;uri\&quot;.)
   * @return uri
   **/
  @Nullable
  @Schema(name = "The uri the data shall be located at. (This shall only have effect, if the \"source\" is \"uri\".)")
  @JsonProperty(JSON_PROPERTY_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUri() {
    return uri;
  }


  @JsonProperty(JSON_PROPERTY_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUri(String uri) {
    this.uri = uri;
  }


  public OperationMergeFileData value(byte[] value) {
    
    this.value = value;
    return this;
  }

  /**
   * Get value
   * @return value
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public byte[] getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(byte[] value) {
    this.value = value;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationMergeFileData operationMergeFileData = (OperationMergeFileData) o;
    return Objects.equals(this.format, operationMergeFileData.format) &&
        Objects.equals(this.outlineName, operationMergeFileData.outlineName) &&
        Objects.equals(this.source, operationMergeFileData.source) &&
        Objects.equals(this.uri, operationMergeFileData.uri) &&
        Arrays.equals(this.value, operationMergeFileData.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(format, outlineName, source, uri, Arrays.hashCode(value));
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationMergeFileData {\n");
    sb.append("    format: ").append(toIndentedString(format)).append("\n");
    sb.append("    outlineName: ").append(toIndentedString(outlineName)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
