/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * These parameters can be used to set the asymmetric encryption of a PDF document.
 */
@Schema(description = "These parameters can be used to set the asymmetric encryption of a PDF document.")
@JsonPropertyOrder({
  OperationEncryptCertificate.JSON_PROPERTY_CONTENT_ENCRYPTION,
  OperationEncryptCertificate.JSON_PROPERTY_ENCRYPTION_KEY,
  OperationEncryptCertificate.JSON_PROPERTY_RECIPIENT
})
@JsonTypeName("Operation_EncryptCertificate")

public class OperationEncryptCertificate {
  /**
   * Specifies whether certain contents should be treated differently than others during encryption.  *   encryptEverything &#x3D; All contents of the document are encrypted without distinction (if provided by the standard). *   exposeMetadata &#x3D; The document&#39;s metadata is left unencrypted to make it discoverable by processing programs. (Has an effect only for 128 bit and 256 bit AES).
   */
  public enum ContentEncryptionEnum {
    ENCRYPT_EVERYTHING(String.valueOf("encryptEverything")),
    
    EXPOSE_METADATA(String.valueOf("exposeMetadata"));

    private String value;

    ContentEncryptionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ContentEncryptionEnum fromValue(String value) {
      for (ContentEncryptionEnum b : ContentEncryptionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CONTENT_ENCRYPTION = "contentEncryption";
  private ContentEncryptionEnum contentEncryption = ContentEncryptionEnum.ENCRYPT_EVERYTHING;

  /**
   * Sets the encryption level for the document.  *   RC4\\_40 &#x3D; 40-bit RC4 *   RC4\\_128 &#x3D; 128-bit RC4 *   AES\\_128 &#x3D; 128-bit AES *   AES\\_256 &#x3D; 256-bit AES  **Important:** Please note that the option \&quot;256-bit AES\&quot; only works if the \&quot;Java Cryptography Extension (JCE)\&quot; has been enabled with \&quot;Unlimited Strength\&quot; in the JVM. You can obtain the modified \&quot;Policy Files\&quot; (along with instructions for installation) from the Oracle website: Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files 7 Download: http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html
   */
  public enum EncryptionKeyEnum {
    RC4_40(String.valueOf("RC4_40")),
    
    RC4_128(String.valueOf("RC4_128")),
    
    AES_128(String.valueOf("AES_128")),
    
    AES_256(String.valueOf("AES_256"));

    private String value;

    EncryptionKeyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EncryptionKeyEnum fromValue(String value) {
      for (EncryptionKeyEnum b : EncryptionKeyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ENCRYPTION_KEY = "encryptionKey";
  private EncryptionKeyEnum encryptionKey = EncryptionKeyEnum.RC4_128;

  public static final String JSON_PROPERTY_RECIPIENT = "recipient";
  private List<OperationRecipient> recipient = new ArrayList<>();

  public OperationEncryptCertificate() {
  }

  public OperationEncryptCertificate contentEncryption(ContentEncryptionEnum contentEncryption) {
    
    this.contentEncryption = contentEncryption;
    return this;
  }

  /**
   * Specifies whether certain contents should be treated differently than others during encryption.  *   encryptEverything &#x3D; All contents of the document are encrypted without distinction (if provided by the standard). *   exposeMetadata &#x3D; The document&#39;s metadata is left unencrypted to make it discoverable by processing programs. (Has an effect only for 128 bit and 256 bit AES).
   * @return contentEncryption
   **/
  @Nullable
  @Schema(name = "Specifies whether certain contents should be treated differently than others during encryption.  *   encryptEverything = All contents of the document are encrypted without distinction (if provided by the standard). *   exposeMetadata = The document's metadata is left unencrypted to make it discoverable by processing programs. (Has an effect only for 128 bit and 256 bit AES).")
  @JsonProperty(JSON_PROPERTY_CONTENT_ENCRYPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContentEncryptionEnum getContentEncryption() {
    return contentEncryption;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT_ENCRYPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContentEncryption(ContentEncryptionEnum contentEncryption) {
    this.contentEncryption = contentEncryption;
  }


  public OperationEncryptCertificate encryptionKey(EncryptionKeyEnum encryptionKey) {
    
    this.encryptionKey = encryptionKey;
    return this;
  }

  /**
   * Sets the encryption level for the document.  *   RC4\\_40 &#x3D; 40-bit RC4 *   RC4\\_128 &#x3D; 128-bit RC4 *   AES\\_128 &#x3D; 128-bit AES *   AES\\_256 &#x3D; 256-bit AES  **Important:** Please note that the option \&quot;256-bit AES\&quot; only works if the \&quot;Java Cryptography Extension (JCE)\&quot; has been enabled with \&quot;Unlimited Strength\&quot; in the JVM. You can obtain the modified \&quot;Policy Files\&quot; (along with instructions for installation) from the Oracle website: Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files 7 Download: http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html
   * @return encryptionKey
   **/
  @Nullable
  @Schema(name = "Sets the encryption level for the document.  *   RC4\\_40 = 40-bit RC4 *   RC4\\_128 = 128-bit RC4 *   AES\\_128 = 128-bit AES *   AES\\_256 = 256-bit AES  **Important:** Please note that the option \"256-bit AES\" only works if the \"Java Cryptography Extension (JCE)\" has been enabled with \"Unlimited Strength\" in the JVM. You can obtain the modified \"Policy Files\" (along with instructions for installation) from the Oracle website: Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files 7 Download: http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html")
  @JsonProperty(JSON_PROPERTY_ENCRYPTION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EncryptionKeyEnum getEncryptionKey() {
    return encryptionKey;
  }


  @JsonProperty(JSON_PROPERTY_ENCRYPTION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEncryptionKey(EncryptionKeyEnum encryptionKey) {
    this.encryptionKey = encryptionKey;
  }


  public OperationEncryptCertificate recipient(List<OperationRecipient> recipient) {
    
    this.recipient = recipient;
    return this;
  }

  public OperationEncryptCertificate addRecipientItem(OperationRecipient recipientItem) {
    if (this.recipient == null) {
        this.recipient = new ArrayList<>();
    }
    this.recipient.add(recipientItem);
    return this;
  }

  /**
   * Get recipient
   * @return recipient
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OperationRecipient> getRecipient() {
    return recipient;
  }


  @JsonProperty(JSON_PROPERTY_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRecipient(List<OperationRecipient> recipient) {
    this.recipient = recipient;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationEncryptCertificate operationEncryptCertificate = (OperationEncryptCertificate) o;
    return Objects.equals(this.contentEncryption, operationEncryptCertificate.contentEncryption) &&
        Objects.equals(this.encryptionKey, operationEncryptCertificate.encryptionKey) &&
        Objects.equals(this.recipient, operationEncryptCertificate.recipient);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contentEncryption, encryptionKey, recipient);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationEncryptCertificate {\n");
    sb.append("    contentEncryption: ").append(toIndentedString(contentEncryption)).append("\n");
    sb.append("    encryptionKey: ").append(toIndentedString(encryptionKey)).append("\n");
    sb.append("    recipient: ").append(toIndentedString(recipient)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
