/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * These parameters can be used to set encryption for a PDF document.
 */
@Schema(description = "These parameters can be used to set encryption for a PDF document.")
@JsonPropertyOrder({
  OperationEncrypt.JSON_PROPERTY_CAN_ASSEMBLE,
  OperationEncrypt.JSON_PROPERTY_CAN_EXTRACT_CONTENT,
  OperationEncrypt.JSON_PROPERTY_CAN_EXTRACT_FOR_ACCESSIBILITY,
  OperationEncrypt.JSON_PROPERTY_CAN_FILL_IN_FORM,
  OperationEncrypt.JSON_PROPERTY_CAN_MODIFY,
  OperationEncrypt.JSON_PROPERTY_CAN_MODIFY_ANNOTATIONS,
  OperationEncrypt.JSON_PROPERTY_CAN_PRINT,
  OperationEncrypt.JSON_PROPERTY_CAN_PRINT_HIGH_RES,
  OperationEncrypt.JSON_PROPERTY_CONTENT_ENCRYPTION,
  OperationEncrypt.JSON_PROPERTY_PASSWORD
})
@JsonTypeName("Operation_Encrypt")

public class OperationEncrypt {
  public static final String JSON_PROPERTY_CAN_ASSEMBLE = "canAssemble";
  private Boolean canAssemble = false;

  public static final String JSON_PROPERTY_CAN_EXTRACT_CONTENT = "canExtractContent";
  private Boolean canExtractContent = false;

  public static final String JSON_PROPERTY_CAN_EXTRACT_FOR_ACCESSIBILITY = "canExtractForAccessibility";
  private Boolean canExtractForAccessibility = false;

  public static final String JSON_PROPERTY_CAN_FILL_IN_FORM = "canFillInForm";
  private Boolean canFillInForm = false;

  public static final String JSON_PROPERTY_CAN_MODIFY = "canModify";
  private Boolean canModify = false;

  public static final String JSON_PROPERTY_CAN_MODIFY_ANNOTATIONS = "canModifyAnnotations";
  private Boolean canModifyAnnotations = false;

  public static final String JSON_PROPERTY_CAN_PRINT = "canPrint";
  private Boolean canPrint = false;

  public static final String JSON_PROPERTY_CAN_PRINT_HIGH_RES = "canPrintHighRes";
  private Boolean canPrintHighRes = false;

  /**
   * Specifies whether certain contents should be treated differently than others during encryption.  *   encryptEverything &#x3D; All contents of the document are encrypted without distinction (if provided by the standard). *   exposeMetadata &#x3D; The document&#39;s metadata is left unencrypted to make it discoverable by processing programs. (Has an effect only for 128 bit and 256 bit AES).
   */
  public enum ContentEncryptionEnum {
    ENCRYPT_EVERYTHING(String.valueOf("encryptEverything")),
    
    EXPOSE_METADATA(String.valueOf("exposeMetadata"));

    private String value;

    ContentEncryptionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ContentEncryptionEnum fromValue(String value) {
      for (ContentEncryptionEnum b : ContentEncryptionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CONTENT_ENCRYPTION = "contentEncryption";
  private ContentEncryptionEnum contentEncryption = ContentEncryptionEnum.ENCRYPT_EVERYTHING;

  public static final String JSON_PROPERTY_PASSWORD = "password";
  private OperationPasswordEncrypt password;

  public OperationEncrypt() {
  }

  public OperationEncrypt canAssemble(Boolean canAssemble) {
    
    this.canAssemble = canAssemble;
    return this;
  }

  /**
   * If \&quot;true,\&quot; the document can be rearranged (e.g., pages can be deleted, inserted, and rotated).
   * @return canAssemble
   **/
  @Nullable
  @Schema(name = "If \"true,\" the document can be rearranged (e.g., pages can be deleted, inserted, and rotated).")
  @JsonProperty(JSON_PROPERTY_CAN_ASSEMBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCanAssemble() {
    return canAssemble;
  }


  @JsonProperty(JSON_PROPERTY_CAN_ASSEMBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanAssemble(Boolean canAssemble) {
    this.canAssemble = canAssemble;
  }


  public OperationEncrypt canExtractContent(Boolean canExtractContent) {
    
    this.canExtractContent = canExtractContent;
    return this;
  }

  /**
   * If \&quot;true,\&quot; content can be extracted (copied) from the document.
   * @return canExtractContent
   **/
  @Nullable
  @Schema(name = "If \"true,\" content can be extracted (copied) from the document.")
  @JsonProperty(JSON_PROPERTY_CAN_EXTRACT_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCanExtractContent() {
    return canExtractContent;
  }


  @JsonProperty(JSON_PROPERTY_CAN_EXTRACT_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanExtractContent(Boolean canExtractContent) {
    this.canExtractContent = canExtractContent;
  }


  public OperationEncrypt canExtractForAccessibility(Boolean canExtractForAccessibility) {
    
    this.canExtractForAccessibility = canExtractForAccessibility;
    return this;
  }

  /**
   * If \&quot;true,\&quot; content can be extracted (copied) for accessibility purposes.
   * @return canExtractForAccessibility
   **/
  @Nullable
  @Schema(name = "If \"true,\" content can be extracted (copied) for accessibility purposes.")
  @JsonProperty(JSON_PROPERTY_CAN_EXTRACT_FOR_ACCESSIBILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCanExtractForAccessibility() {
    return canExtractForAccessibility;
  }


  @JsonProperty(JSON_PROPERTY_CAN_EXTRACT_FOR_ACCESSIBILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanExtractForAccessibility(Boolean canExtractForAccessibility) {
    this.canExtractForAccessibility = canExtractForAccessibility;
  }


  public OperationEncrypt canFillInForm(Boolean canFillInForm) {
    
    this.canFillInForm = canFillInForm;
    return this;
  }

  /**
   * If \&quot;true,\&quot; form fields can be filled out and the document can be signed.
   * @return canFillInForm
   **/
  @Nullable
  @Schema(name = "If \"true,\" form fields can be filled out and the document can be signed.")
  @JsonProperty(JSON_PROPERTY_CAN_FILL_IN_FORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCanFillInForm() {
    return canFillInForm;
  }


  @JsonProperty(JSON_PROPERTY_CAN_FILL_IN_FORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanFillInForm(Boolean canFillInForm) {
    this.canFillInForm = canFillInForm;
  }


  public OperationEncrypt canModify(Boolean canModify) {
    
    this.canModify = canModify;
    return this;
  }

  /**
   * If \&quot;true,\&quot; changes to the document are permitted.
   * @return canModify
   **/
  @Nullable
  @Schema(name = "If \"true,\" changes to the document are permitted.")
  @JsonProperty(JSON_PROPERTY_CAN_MODIFY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCanModify() {
    return canModify;
  }


  @JsonProperty(JSON_PROPERTY_CAN_MODIFY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanModify(Boolean canModify) {
    this.canModify = canModify;
  }


  public OperationEncrypt canModifyAnnotations(Boolean canModifyAnnotations) {
    
    this.canModifyAnnotations = canModifyAnnotations;
    return this;
  }

  /**
   * If \&quot;true,\&quot; comments can be added to the document and deleted from the document.
   * @return canModifyAnnotations
   **/
  @Nullable
  @Schema(name = "If \"true,\" comments can be added to the document and deleted from the document.")
  @JsonProperty(JSON_PROPERTY_CAN_MODIFY_ANNOTATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCanModifyAnnotations() {
    return canModifyAnnotations;
  }


  @JsonProperty(JSON_PROPERTY_CAN_MODIFY_ANNOTATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanModifyAnnotations(Boolean canModifyAnnotations) {
    this.canModifyAnnotations = canModifyAnnotations;
  }


  public OperationEncrypt canPrint(Boolean canPrint) {
    
    this.canPrint = canPrint;
    return this;
  }

  /**
   * If \&quot;true,\&quot; the document can be printed.
   * @return canPrint
   **/
  @Nullable
  @Schema(name = "If \"true,\" the document can be printed.")
  @JsonProperty(JSON_PROPERTY_CAN_PRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCanPrint() {
    return canPrint;
  }


  @JsonProperty(JSON_PROPERTY_CAN_PRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanPrint(Boolean canPrint) {
    this.canPrint = canPrint;
  }


  public OperationEncrypt canPrintHighRes(Boolean canPrintHighRes) {
    
    this.canPrintHighRes = canPrintHighRes;
    return this;
  }

  /**
   * If \&quot;true,\&quot; the document can be printed at high resolution levels.
   * @return canPrintHighRes
   **/
  @Nullable
  @Schema(name = "If \"true,\" the document can be printed at high resolution levels.")
  @JsonProperty(JSON_PROPERTY_CAN_PRINT_HIGH_RES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCanPrintHighRes() {
    return canPrintHighRes;
  }


  @JsonProperty(JSON_PROPERTY_CAN_PRINT_HIGH_RES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanPrintHighRes(Boolean canPrintHighRes) {
    this.canPrintHighRes = canPrintHighRes;
  }


  public OperationEncrypt contentEncryption(ContentEncryptionEnum contentEncryption) {
    
    this.contentEncryption = contentEncryption;
    return this;
  }

  /**
   * Specifies whether certain contents should be treated differently than others during encryption.  *   encryptEverything &#x3D; All contents of the document are encrypted without distinction (if provided by the standard). *   exposeMetadata &#x3D; The document&#39;s metadata is left unencrypted to make it discoverable by processing programs. (Has an effect only for 128 bit and 256 bit AES).
   * @return contentEncryption
   **/
  @Nullable
  @Schema(name = "Specifies whether certain contents should be treated differently than others during encryption.  *   encryptEverything = All contents of the document are encrypted without distinction (if provided by the standard). *   exposeMetadata = The document's metadata is left unencrypted to make it discoverable by processing programs. (Has an effect only for 128 bit and 256 bit AES).")
  @JsonProperty(JSON_PROPERTY_CONTENT_ENCRYPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContentEncryptionEnum getContentEncryption() {
    return contentEncryption;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT_ENCRYPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContentEncryption(ContentEncryptionEnum contentEncryption) {
    this.contentEncryption = contentEncryption;
  }


  public OperationEncrypt password(OperationPasswordEncrypt password) {
    
    this.password = password;
    return this;
  }

  /**
   * Get password
   * @return password
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationPasswordEncrypt getPassword() {
    return password;
  }


  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassword(OperationPasswordEncrypt password) {
    this.password = password;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationEncrypt operationEncrypt = (OperationEncrypt) o;
    return Objects.equals(this.canAssemble, operationEncrypt.canAssemble) &&
        Objects.equals(this.canExtractContent, operationEncrypt.canExtractContent) &&
        Objects.equals(this.canExtractForAccessibility, operationEncrypt.canExtractForAccessibility) &&
        Objects.equals(this.canFillInForm, operationEncrypt.canFillInForm) &&
        Objects.equals(this.canModify, operationEncrypt.canModify) &&
        Objects.equals(this.canModifyAnnotations, operationEncrypt.canModifyAnnotations) &&
        Objects.equals(this.canPrint, operationEncrypt.canPrint) &&
        Objects.equals(this.canPrintHighRes, operationEncrypt.canPrintHighRes) &&
        Objects.equals(this.contentEncryption, operationEncrypt.contentEncryption) &&
        Objects.equals(this.password, operationEncrypt.password);
  }

  @Override
  public int hashCode() {
    return Objects.hash(canAssemble, canExtractContent, canExtractForAccessibility, canFillInForm, canModify, canModifyAnnotations, canPrint, canPrintHighRes, contentEncryption, password);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationEncrypt {\n");
    sb.append("    canAssemble: ").append(toIndentedString(canAssemble)).append("\n");
    sb.append("    canExtractContent: ").append(toIndentedString(canExtractContent)).append("\n");
    sb.append("    canExtractForAccessibility: ").append(toIndentedString(canExtractForAccessibility)).append("\n");
    sb.append("    canFillInForm: ").append(toIndentedString(canFillInForm)).append("\n");
    sb.append("    canModify: ").append(toIndentedString(canModify)).append("\n");
    sb.append("    canModifyAnnotations: ").append(toIndentedString(canModifyAnnotations)).append("\n");
    sb.append("    canPrint: ").append(toIndentedString(canPrint)).append("\n");
    sb.append("    canPrintHighRes: ").append(toIndentedString(canPrintHighRes)).append("\n");
    sb.append("    contentEncryption: ").append(toIndentedString(contentEncryption)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
