/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * These settings are only used for HTML (e.g. websites) and HTML-based documents (e.g. e-mails).
 */
@Schema(description = "These settings are only used for HTML (e.g. websites) and HTML-based documents (e.g. e-mails).")
@JsonPropertyOrder({
  OperationConverterHtml.JSON_PROPERTY_ADJUST_FONTS,
  OperationConverterHtml.JSON_PROPERTY_BASE_U_R_L,
  OperationConverterHtml.JSON_PROPERTY_DOWNLOAD_IMAGES,
  OperationConverterHtml.JSON_PROPERTY_ERROR_REPORT,
  OperationConverterHtml.JSON_PROPERTY_IMAGE_MODE,
  OperationConverterHtml.JSON_PROPERTY_PREFER_C_S_S_PAGE_SIZE,
  OperationConverterHtml.JSON_PROPERTY_TEMPLATE_DATA,
  OperationConverterHtml.JSON_PROPERTY_USE_AS_TEMPLATE,
  OperationConverterHtml.JSON_PROPERTY_USE_BACKGROUND
})
@JsonTypeName("Operation_ConverterHtml")

public class OperationConverterHtml {
  public static final String JSON_PROPERTY_ADJUST_FONTS = "adjustFonts";
  private Boolean adjustFonts = false;

  public static final String JSON_PROPERTY_BASE_U_R_L = "baseURL";
  private String baseURL = "";

  public static final String JSON_PROPERTY_DOWNLOAD_IMAGES = "downloadImages";
  private Boolean downloadImages = false;

  public static final String JSON_PROPERTY_ERROR_REPORT = "errorReport";
  private OperationConverterHtmlErrorReport errorReport;

  /**
   * This defines how downloaded images are inserted into the HTML content (with reference to the &#x60;&lt;downloadImages&gt;&#x60; parameter). When referencing large images in the HTML content, it is recommended to use &#x60;&lt;file&gt;&#x60; to reduce the size of the HTML file and speed up the rendering of the HTML.  *   base64 &#x3D; embed images as BASE64 content *   file &#x3D; embed images as file links to local temporary files
   */
  public enum ImageModeEnum {
    BASE64(String.valueOf("base64")),
    
    FILE(String.valueOf("file"));

    private String value;

    ImageModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ImageModeEnum fromValue(String value) {
      for (ImageModeEnum b : ImageModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_IMAGE_MODE = "imageMode";
  private ImageModeEnum imageMode = ImageModeEnum.BASE64;

  public static final String JSON_PROPERTY_PREFER_C_S_S_PAGE_SIZE = "preferCSSPageSize";
  private Boolean preferCSSPageSize = false;

  public static final String JSON_PROPERTY_TEMPLATE_DATA = "templateData";
  private OperationTemplateData templateData;

  public static final String JSON_PROPERTY_USE_AS_TEMPLATE = "useAsTemplate";
  private Boolean useAsTemplate = false;

  public static final String JSON_PROPERTY_USE_BACKGROUND = "useBackground";
  private Boolean useBackground = true;

  public OperationConverterHtml() {
  }

  public OperationConverterHtml adjustFonts(Boolean adjustFonts) {
    
    this.adjustFonts = adjustFonts;
    return this;
  }

  /**
   * If \&quot;true\&quot;, then the font specifications \&quot;Arial\&quot;, \&quot;Helvetica\&quot; and \&quot;Sans-Serif\&quot; in HTML documents and e-mails (which are based on HTML) are automatically replaced by the \&quot;Arial Unicode MS\&quot; font. The improves the appearance of the typeface in the PDF result.
   * @return adjustFonts
   **/
  @Nullable
  @Schema(name = "If \"true\", then the font specifications \"Arial\", \"Helvetica\" and \"Sans-Serif\" in HTML documents and e-mails (which are based on HTML) are automatically replaced by the \"Arial Unicode MS\" font. The improves the appearance of the typeface in the PDF result.")
  @JsonProperty(JSON_PROPERTY_ADJUST_FONTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAdjustFonts() {
    return adjustFonts;
  }


  @JsonProperty(JSON_PROPERTY_ADJUST_FONTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdjustFonts(Boolean adjustFonts) {
    this.adjustFonts = adjustFonts;
  }


  public OperationConverterHtml baseURL(String baseURL) {
    
    this.baseURL = baseURL;
    return this;
  }

  /**
   * Used to define the URL that will be the base for all URLs in the HTML document that are not defined as absolute URLs. The URL must be absolute and contain a scheme (e.g. &#39;http&#39; or &#39;https&#39;); the scheme &#39;file&#39; is not allowed.
   * @return baseURL
   **/
  @Nullable
  @Schema(name = "Used to define the URL that will be the base for all URLs in the HTML document that are not defined as absolute URLs. The URL must be absolute and contain a scheme (e.g. 'http' or 'https'); the scheme 'file' is not allowed.")
  @JsonProperty(JSON_PROPERTY_BASE_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBaseURL() {
    return baseURL;
  }


  @JsonProperty(JSON_PROPERTY_BASE_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBaseURL(String baseURL) {
    this.baseURL = baseURL;
  }


  public OperationConverterHtml downloadImages(Boolean downloadImages) {
    
    this.downloadImages = downloadImages;
    return this;
  }

  /**
   * If \&quot;true\&quot;, then externally referenced images of the HTML document are downloaded and inserted into the document. If false, the images are not downloaded and the external references to the image are removed, leaving already embedded images intact.
   * @return downloadImages
   **/
  @Nullable
  @Schema(name = "If \"true\", then externally referenced images of the HTML document are downloaded and inserted into the document. If false, the images are not downloaded and the external references to the image are removed, leaving already embedded images intact.")
  @JsonProperty(JSON_PROPERTY_DOWNLOAD_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDownloadImages() {
    return downloadImages;
  }


  @JsonProperty(JSON_PROPERTY_DOWNLOAD_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDownloadImages(Boolean downloadImages) {
    this.downloadImages = downloadImages;
  }


  public OperationConverterHtml errorReport(OperationConverterHtmlErrorReport errorReport) {
    
    this.errorReport = errorReport;
    return this;
  }

  /**
   * Get errorReport
   * @return errorReport
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ERROR_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationConverterHtmlErrorReport getErrorReport() {
    return errorReport;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorReport(OperationConverterHtmlErrorReport errorReport) {
    this.errorReport = errorReport;
  }


  public OperationConverterHtml imageMode(ImageModeEnum imageMode) {
    
    this.imageMode = imageMode;
    return this;
  }

  /**
   * This defines how downloaded images are inserted into the HTML content (with reference to the &#x60;&lt;downloadImages&gt;&#x60; parameter). When referencing large images in the HTML content, it is recommended to use &#x60;&lt;file&gt;&#x60; to reduce the size of the HTML file and speed up the rendering of the HTML.  *   base64 &#x3D; embed images as BASE64 content *   file &#x3D; embed images as file links to local temporary files
   * @return imageMode
   **/
  @Nullable
  @Schema(name = "This defines how downloaded images are inserted into the HTML content (with reference to the `<downloadImages>` parameter). When referencing large images in the HTML content, it is recommended to use `<file>` to reduce the size of the HTML file and speed up the rendering of the HTML.  *   base64 = embed images as BASE64 content *   file = embed images as file links to local temporary files")
  @JsonProperty(JSON_PROPERTY_IMAGE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ImageModeEnum getImageMode() {
    return imageMode;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageMode(ImageModeEnum imageMode) {
    this.imageMode = imageMode;
  }


  public OperationConverterHtml preferCSSPageSize(Boolean preferCSSPageSize) {
    
    this.preferCSSPageSize = preferCSSPageSize;
    return this;
  }

  /**
   * If \&quot;true\&quot;, then the page size and margins are preferentially used from the CSS. Otherwise, the sizes from the passed page parameter are used. The values can also be only partially overwritten, so that e.g. the page size is determined by the parameter values and the page margins are defined in the CSS.
   * @return preferCSSPageSize
   **/
  @Nullable
  @Schema(name = "If \"true\", then the page size and margins are preferentially used from the CSS. Otherwise, the sizes from the passed page parameter are used. The values can also be only partially overwritten, so that e.g. the page size is determined by the parameter values and the page margins are defined in the CSS.")
  @JsonProperty(JSON_PROPERTY_PREFER_C_S_S_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPreferCSSPageSize() {
    return preferCSSPageSize;
  }


  @JsonProperty(JSON_PROPERTY_PREFER_C_S_S_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreferCSSPageSize(Boolean preferCSSPageSize) {
    this.preferCSSPageSize = preferCSSPageSize;
  }


  public OperationConverterHtml templateData(OperationTemplateData templateData) {
    
    this.templateData = templateData;
    return this;
  }

  /**
   * Get templateData
   * @return templateData
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TEMPLATE_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationTemplateData getTemplateData() {
    return templateData;
  }


  @JsonProperty(JSON_PROPERTY_TEMPLATE_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTemplateData(OperationTemplateData templateData) {
    this.templateData = templateData;
  }


  public OperationConverterHtml useAsTemplate(Boolean useAsTemplate) {
    
    this.useAsTemplate = useAsTemplate;
    return this;
  }

  /**
   * If \&quot;true\&quot;, the HTML document will be interpreted as a template, i.e., the system will search for variables in the HTML and replace them with the data passed in \&quot;templateData\&quot;. The document will not be converted to HTML format until after this step is completed. This means that by using the HTML document as a template together with passed data, you can obtain a dynamically generated PDF document.
   * @return useAsTemplate
   **/
  @Nullable
  @Schema(name = "If \"true\", the HTML document will be interpreted as a template, i.e., the system will search for variables in the HTML and replace them with the data passed in \"templateData\". The document will not be converted to HTML format until after this step is completed. This means that by using the HTML document as a template together with passed data, you can obtain a dynamically generated PDF document.")
  @JsonProperty(JSON_PROPERTY_USE_AS_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseAsTemplate() {
    return useAsTemplate;
  }


  @JsonProperty(JSON_PROPERTY_USE_AS_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseAsTemplate(Boolean useAsTemplate) {
    this.useAsTemplate = useAsTemplate;
  }


  public OperationConverterHtml useBackground(Boolean useBackground) {
    
    this.useBackground = useBackground;
    return this;
  }

  /**
   * If \&quot;true\&quot;, the background defined in the HTML document will be output in the PDF document as well. If \&quot;false\&quot;, the background will be hidden.
   * @return useBackground
   **/
  @Nullable
  @Schema(name = "If \"true\", the background defined in the HTML document will be output in the PDF document as well. If \"false\", the background will be hidden.")
  @JsonProperty(JSON_PROPERTY_USE_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseBackground() {
    return useBackground;
  }


  @JsonProperty(JSON_PROPERTY_USE_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseBackground(Boolean useBackground) {
    this.useBackground = useBackground;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationConverterHtml operationConverterHtml = (OperationConverterHtml) o;
    return Objects.equals(this.adjustFonts, operationConverterHtml.adjustFonts) &&
        Objects.equals(this.baseURL, operationConverterHtml.baseURL) &&
        Objects.equals(this.downloadImages, operationConverterHtml.downloadImages) &&
        Objects.equals(this.errorReport, operationConverterHtml.errorReport) &&
        Objects.equals(this.imageMode, operationConverterHtml.imageMode) &&
        Objects.equals(this.preferCSSPageSize, operationConverterHtml.preferCSSPageSize) &&
        Objects.equals(this.templateData, operationConverterHtml.templateData) &&
        Objects.equals(this.useAsTemplate, operationConverterHtml.useAsTemplate) &&
        Objects.equals(this.useBackground, operationConverterHtml.useBackground);
  }

  @Override
  public int hashCode() {
    return Objects.hash(adjustFonts, baseURL, downloadImages, errorReport, imageMode, preferCSSPageSize, templateData, useAsTemplate, useBackground);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationConverterHtml {\n");
    sb.append("    adjustFonts: ").append(toIndentedString(adjustFonts)).append("\n");
    sb.append("    baseURL: ").append(toIndentedString(baseURL)).append("\n");
    sb.append("    downloadImages: ").append(toIndentedString(downloadImages)).append("\n");
    sb.append("    errorReport: ").append(toIndentedString(errorReport)).append("\n");
    sb.append("    imageMode: ").append(toIndentedString(imageMode)).append("\n");
    sb.append("    preferCSSPageSize: ").append(toIndentedString(preferCSSPageSize)).append("\n");
    sb.append("    templateData: ").append(toIndentedString(templateData)).append("\n");
    sb.append("    useAsTemplate: ").append(toIndentedString(useAsTemplate)).append("\n");
    sb.append("    useBackground: ").append(toIndentedString(useBackground)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
