/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines basic configuration settings for generating background layers.
 */
@Schema(description = "Defines basic configuration settings for generating background layers.")
@JsonPropertyOrder({
  OperationBackgroundBaseSettings.JSON_PROPERTY_OPACITY,
  OperationBackgroundBaseSettings.JSON_PROPERTY_PAGES,
  OperationBackgroundBaseSettings.JSON_PROPERTY_POSITION,
  OperationBackgroundBaseSettings.JSON_PROPERTY_RELATIVE_TO_PAGE,
  OperationBackgroundBaseSettings.JSON_PROPERTY_REPLACE_EXISTING,
  OperationBackgroundBaseSettings.JSON_PROPERTY_ROTATION,
  OperationBackgroundBaseSettings.JSON_PROPERTY_SCALE,
  OperationBackgroundBaseSettings.JSON_PROPERTY_VISIBILITY
})
@JsonTypeName("Operation_BackgroundBaseSettings")

public class OperationBackgroundBaseSettings {
  public static final String JSON_PROPERTY_OPACITY = "opacity";
  private Integer opacity = 100;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private OperationPagesBackgroundBaseSettings pages;

  public static final String JSON_PROPERTY_POSITION = "position";
  private OperationPositionBackgroundBaseSettings position;

  public static final String JSON_PROPERTY_RELATIVE_TO_PAGE = "relativeToPage";
  private Boolean relativeToPage = true;

  public static final String JSON_PROPERTY_REPLACE_EXISTING = "replaceExisting";
  private Boolean replaceExisting = false;

  public static final String JSON_PROPERTY_ROTATION = "rotation";
  private Integer rotation = 0;

  public static final String JSON_PROPERTY_SCALE = "scale";
  private Integer scale = 100;

  public static final String JSON_PROPERTY_VISIBILITY = "visibility";
  private OperationVisibilityBackgroundBaseSettings visibility;

  public OperationBackgroundBaseSettings() {
  }

  public OperationBackgroundBaseSettings opacity(Integer opacity) {
    
    this.opacity = opacity;
    return this;
  }

  /**
   * A percentage value that is used to specify the background layer&#39;s transparency (100 percent means fully visible).
   * minimum: 0
   * maximum: 100
   * @return opacity
   **/
  @Nullable
  @Schema(name = "A percentage value that is used to specify the background layer's transparency (100 percent means fully visible).")
  @JsonProperty(JSON_PROPERTY_OPACITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOpacity() {
    return opacity;
  }


  @JsonProperty(JSON_PROPERTY_OPACITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpacity(Integer opacity) {
    this.opacity = opacity;
  }


  public OperationBackgroundBaseSettings pages(OperationPagesBackgroundBaseSettings pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * Get pages
   * @return pages
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationPagesBackgroundBaseSettings getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(OperationPagesBackgroundBaseSettings pages) {
    this.pages = pages;
  }


  public OperationBackgroundBaseSettings position(OperationPositionBackgroundBaseSettings position) {
    
    this.position = position;
    return this;
  }

  /**
   * Get position
   * @return position
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationPositionBackgroundBaseSettings getPosition() {
    return position;
  }


  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPosition(OperationPositionBackgroundBaseSettings position) {
    this.position = position;
  }


  public OperationBackgroundBaseSettings relativeToPage(Boolean relativeToPage) {
    
    this.relativeToPage = relativeToPage;
    return this;
  }

  /**
   * If true, the background layer will not be scaled relative to its own original size, but rather to the dimensions of the page containing it.
   * @return relativeToPage
   **/
  @Nullable
  @Schema(name = "If true, the background layer will not be scaled relative to its own original size, but rather to the dimensions of the page containing it.")
  @JsonProperty(JSON_PROPERTY_RELATIVE_TO_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRelativeToPage() {
    return relativeToPage;
  }


  @JsonProperty(JSON_PROPERTY_RELATIVE_TO_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRelativeToPage(Boolean relativeToPage) {
    this.relativeToPage = relativeToPage;
  }


  public OperationBackgroundBaseSettings replaceExisting(Boolean replaceExisting) {
    
    this.replaceExisting = replaceExisting;
    return this;
  }

  /**
   * If true, an existing background layer will be automatically deleted and replaced with the new one. If false, an existing background layer will cause the operation to be aborted.
   * @return replaceExisting
   **/
  @Nullable
  @Schema(name = "If true, an existing background layer will be automatically deleted and replaced with the new one. If false, an existing background layer will cause the operation to be aborted.")
  @JsonProperty(JSON_PROPERTY_REPLACE_EXISTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReplaceExisting() {
    return replaceExisting;
  }


  @JsonProperty(JSON_PROPERTY_REPLACE_EXISTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReplaceExisting(Boolean replaceExisting) {
    this.replaceExisting = replaceExisting;
  }


  public OperationBackgroundBaseSettings rotation(Integer rotation) {
    
    this.rotation = rotation;
    return this;
  }

  /**
   * A value between 0 and 360 degrees that is used to specify the background layer&#39;s rotation.
   * minimum: 0
   * maximum: 360
   * @return rotation
   **/
  @Nullable
  @Schema(name = "A value between 0 and 360 degrees that is used to specify the background layer's rotation.")
  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRotation() {
    return rotation;
  }


  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRotation(Integer rotation) {
    this.rotation = rotation;
  }


  public OperationBackgroundBaseSettings scale(Integer scale) {
    
    this.scale = scale;
    return this;
  }

  /**
   * A percentage value used to specify the scaling for the background layer. This scaling can either be relative to the background layer&#39;s original size or to the dimensions of the page containing it (depends on the \&quot;relativeToPage\&quot; parameter)
   * minimum: 0
   * @return scale
   **/
  @Nullable
  @Schema(name = "A percentage value used to specify the scaling for the background layer. This scaling can either be relative to the background layer's original size or to the dimensions of the page containing it (depends on the \"relativeToPage\" parameter)")
  @JsonProperty(JSON_PROPERTY_SCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getScale() {
    return scale;
  }


  @JsonProperty(JSON_PROPERTY_SCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScale(Integer scale) {
    this.scale = scale;
  }


  public OperationBackgroundBaseSettings visibility(OperationVisibilityBackgroundBaseSettings visibility) {
    
    this.visibility = visibility;
    return this;
  }

  /**
   * Get visibility
   * @return visibility
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_VISIBILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationVisibilityBackgroundBaseSettings getVisibility() {
    return visibility;
  }


  @JsonProperty(JSON_PROPERTY_VISIBILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisibility(OperationVisibilityBackgroundBaseSettings visibility) {
    this.visibility = visibility;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationBackgroundBaseSettings operationBackgroundBaseSettings = (OperationBackgroundBaseSettings) o;
    return Objects.equals(this.opacity, operationBackgroundBaseSettings.opacity) &&
        Objects.equals(this.pages, operationBackgroundBaseSettings.pages) &&
        Objects.equals(this.position, operationBackgroundBaseSettings.position) &&
        Objects.equals(this.relativeToPage, operationBackgroundBaseSettings.relativeToPage) &&
        Objects.equals(this.replaceExisting, operationBackgroundBaseSettings.replaceExisting) &&
        Objects.equals(this.rotation, operationBackgroundBaseSettings.rotation) &&
        Objects.equals(this.scale, operationBackgroundBaseSettings.scale) &&
        Objects.equals(this.visibility, operationBackgroundBaseSettings.visibility);
  }

  @Override
  public int hashCode() {
    return Objects.hash(opacity, pages, position, relativeToPage, replaceExisting, rotation, scale, visibility);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationBackgroundBaseSettings {\n");
    sb.append("    opacity: ").append(toIndentedString(opacity)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    relativeToPage: ").append(toIndentedString(relativeToPage)).append("\n");
    sb.append("    replaceExisting: ").append(toIndentedString(replaceExisting)).append("\n");
    sb.append("    rotation: ").append(toIndentedString(rotation)).append("\n");
    sb.append("    scale: ").append(toIndentedString(scale)).append("\n");
    sb.append("    visibility: ").append(toIndentedString(visibility)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
