/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines a set of attributes for text markup annotations.
 */
@Schema(description = "Defines a set of attributes for text markup annotations.")
@JsonPropertyOrder({
  MetadataMarkup.JSON_PROPERTY_CREATION_DATE,
  MetadataMarkup.JSON_PROPERTY_CREATOR,
  MetadataMarkup.JSON_PROPERTY_INTENTS,
  MetadataMarkup.JSON_PROPERTY_OPACITY,
  MetadataMarkup.JSON_PROPERTY_RELATION,
  MetadataMarkup.JSON_PROPERTY_RICH_CONTENTS,
  MetadataMarkup.JSON_PROPERTY_SUBJECT
})
@JsonTypeName("Metadata_Markup")

public class MetadataMarkup {
  public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
  private String creationDate = "";

  public static final String JSON_PROPERTY_CREATOR = "creator";
  private String creator = "";

  public static final String JSON_PROPERTY_INTENTS = "intents";
  private String intents = "";

  public static final String JSON_PROPERTY_OPACITY = "opacity";
  private Integer opacity = 100;

  public static final String JSON_PROPERTY_RELATION = "relation";
  private MetadataRelationMarkup relation;

  public static final String JSON_PROPERTY_RICH_CONTENTS = "richContents";
  private String richContents = "";

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  private String subject = "";

  public MetadataMarkup() {
  }

  public MetadataMarkup creationDate(String creationDate) {
    
    this.creationDate = creationDate;
    return this;
  }

  /**
   * The date of the annotation&#39;s creation. This string will contain the date in ASN.1 standard format. (D:YYYYMMDDHHmmSSOHH&#39;mm)
   * @return creationDate
   **/
  @Nullable
  @Schema(name = "The date of the annotation's creation. This string will contain the date in ASN.1 standard format. (D:YYYYMMDDHHmmSSOHH'mm)")
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreationDate() {
    return creationDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationDate(String creationDate) {
    this.creationDate = creationDate;
  }


  public MetadataMarkup creator(String creator) {
    
    this.creator = creator;
    return this;
  }

  /**
   * The name of the annotation&#39;s author.
   * @return creator
   **/
  @Nullable
  @Schema(name = "The name of the annotation's author.")
  @JsonProperty(JSON_PROPERTY_CREATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreator() {
    return creator;
  }


  @JsonProperty(JSON_PROPERTY_CREATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreator(String creator) {
    this.creator = creator;
  }


  public MetadataMarkup intents(String intents) {
    
    this.intents = intents;
    return this;
  }

  /**
   * The annotation&#39;s intents. Depending on the annotation sub type the intents value shall serve further purposes.
   * @return intents
   **/
  @Nullable
  @Schema(name = "The annotation's intents. Depending on the annotation sub type the intents value shall serve further purposes.")
  @JsonProperty(JSON_PROPERTY_INTENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIntents() {
    return intents;
  }


  @JsonProperty(JSON_PROPERTY_INTENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIntents(String intents) {
    this.intents = intents;
  }


  public MetadataMarkup opacity(Integer opacity) {
    
    this.opacity = opacity;
    return this;
  }

  /**
   * The annotations opacity as a percentage, where 100 is fully oqaque and 0 is fully transparent.
   * minimum: 0
   * maximum: 100
   * @return opacity
   **/
  @Nullable
  @Schema(name = "The annotations opacity as a percentage, where 100 is fully oqaque and 0 is fully transparent.")
  @JsonProperty(JSON_PROPERTY_OPACITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOpacity() {
    return opacity;
  }


  @JsonProperty(JSON_PROPERTY_OPACITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpacity(Integer opacity) {
    this.opacity = opacity;
  }


  public MetadataMarkup relation(MetadataRelationMarkup relation) {
    
    this.relation = relation;
    return this;
  }

  /**
   * Get relation
   * @return relation
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_RELATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataRelationMarkup getRelation() {
    return relation;
  }


  @JsonProperty(JSON_PROPERTY_RELATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRelation(MetadataRelationMarkup relation) {
    this.relation = relation;
  }


  public MetadataMarkup richContents(String richContents) {
    
    this.richContents = richContents;
    return this;
  }

  /**
   * A richtext string containing defining style and contents of the annotation. (This String shall conform to the richtext conventions of the XML Forms Specification (XFA)).
   * @return richContents
   **/
  @Nullable
  @Schema(name = "A richtext string containing defining style and contents of the annotation. (This String shall conform to the richtext conventions of the XML Forms Specification (XFA)).")
  @JsonProperty(JSON_PROPERTY_RICH_CONTENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRichContents() {
    return richContents;
  }


  @JsonProperty(JSON_PROPERTY_RICH_CONTENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRichContents(String richContents) {
    this.richContents = richContents;
  }


  public MetadataMarkup subject(String subject) {
    
    this.subject = subject;
    return this;
  }

  /**
   * The annotation&#39;s subject.
   * @return subject
   **/
  @Nullable
  @Schema(name = "The annotation's subject.")
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(String subject) {
    this.subject = subject;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataMarkup metadataMarkup = (MetadataMarkup) o;
    return Objects.equals(this.creationDate, metadataMarkup.creationDate) &&
        Objects.equals(this.creator, metadataMarkup.creator) &&
        Objects.equals(this.intents, metadataMarkup.intents) &&
        Objects.equals(this.opacity, metadataMarkup.opacity) &&
        Objects.equals(this.relation, metadataMarkup.relation) &&
        Objects.equals(this.richContents, metadataMarkup.richContents) &&
        Objects.equals(this.subject, metadataMarkup.subject);
  }

  @Override
  public int hashCode() {
    return Objects.hash(creationDate, creator, intents, opacity, relation, richContents, subject);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataMarkup {\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    creator: ").append(toIndentedString(creator)).append("\n");
    sb.append("    intents: ").append(toIndentedString(intents)).append("\n");
    sb.append("    opacity: ").append(toIndentedString(opacity)).append("\n");
    sb.append("    relation: ").append(toIndentedString(relation)).append("\n");
    sb.append("    richContents: ").append(toIndentedString(richContents)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
