/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines a set of attributes for Line annotations.
 */
@Schema(description = "Defines a set of attributes for Line annotations.")
@JsonPropertyOrder({
  MetadataLine.JSON_PROPERTY_CAPTION_HORIZONTAL_OFFSET,
  MetadataLine.JSON_PROPERTY_CAPTION_POSITIONING,
  MetadataLine.JSON_PROPERTY_CAPTION_VERTICAL_OFFSET,
  MetadataLine.JSON_PROPERTY_END_STYLE,
  MetadataLine.JSON_PROPERTY_LEADER_LINE_EXTENSION_LENGTH,
  MetadataLine.JSON_PROPERTY_LEADER_LINE_LENGTH,
  MetadataLine.JSON_PROPERTY_LEADER_LINE_OFFSET_LENGTH,
  MetadataLine.JSON_PROPERTY_SHOW_CAPTION,
  MetadataLine.JSON_PROPERTY_START_STYLE
})
@JsonTypeName("Metadata_Line")

public class MetadataLine {
  public static final String JSON_PROPERTY_CAPTION_HORIZONTAL_OFFSET = "captionHorizontalOffset";
  private Float captionHorizontalOffset = 0f;

  public static final String JSON_PROPERTY_CAPTION_POSITIONING = "captionPositioning";
  private String captionPositioning = "";

  public static final String JSON_PROPERTY_CAPTION_VERTICAL_OFFSET = "captionVerticalOffset";
  private Float captionVerticalOffset = 0f;

  public static final String JSON_PROPERTY_END_STYLE = "endStyle";
  private String endStyle = "";

  public static final String JSON_PROPERTY_LEADER_LINE_EXTENSION_LENGTH = "leaderLineExtensionLength";
  private Float leaderLineExtensionLength = 0f;

  public static final String JSON_PROPERTY_LEADER_LINE_LENGTH = "leaderLineLength";
  private Float leaderLineLength = 0f;

  public static final String JSON_PROPERTY_LEADER_LINE_OFFSET_LENGTH = "leaderLineOffsetLength";
  private Float leaderLineOffsetLength = 0f;

  public static final String JSON_PROPERTY_SHOW_CAPTION = "showCaption";
  private Boolean showCaption = false;

  public static final String JSON_PROPERTY_START_STYLE = "startStyle";
  private String startStyle = "";

  public MetadataLine() {
  }

  public MetadataLine captionHorizontalOffset(Float captionHorizontalOffset) {
    
    this.captionHorizontalOffset = captionHorizontalOffset;
    return this;
  }

  /**
   * The horizontal offset of the caption&#39;s leading letter in relation to it&#39;s normal position.
   * @return captionHorizontalOffset
   **/
  @Nullable
  @Schema(name = "The horizontal offset of the caption's leading letter in relation to it's normal position.")
  @JsonProperty(JSON_PROPERTY_CAPTION_HORIZONTAL_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getCaptionHorizontalOffset() {
    return captionHorizontalOffset;
  }


  @JsonProperty(JSON_PROPERTY_CAPTION_HORIZONTAL_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptionHorizontalOffset(Float captionHorizontalOffset) {
    this.captionHorizontalOffset = captionHorizontalOffset;
  }


  public MetadataLine captionPositioning(String captionPositioning) {
    
    this.captionPositioning = captionPositioning;
    return this;
  }

  /**
   * The positioning method for the caption of the line. Possible values are \&quot;Inline\&quot; (superimposed) and \&quot;Top\&quot; (above the line).
   * @return captionPositioning
   **/
  @Nullable
  @Schema(name = "The positioning method for the caption of the line. Possible values are \"Inline\" (superimposed) and \"Top\" (above the line).")
  @JsonProperty(JSON_PROPERTY_CAPTION_POSITIONING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCaptionPositioning() {
    return captionPositioning;
  }


  @JsonProperty(JSON_PROPERTY_CAPTION_POSITIONING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptionPositioning(String captionPositioning) {
    this.captionPositioning = captionPositioning;
  }


  public MetadataLine captionVerticalOffset(Float captionVerticalOffset) {
    
    this.captionVerticalOffset = captionVerticalOffset;
    return this;
  }

  /**
   * The vertical offset of the caption&#39;s leading letter in relation to it&#39;s normal position.
   * @return captionVerticalOffset
   **/
  @Nullable
  @Schema(name = "The vertical offset of the caption's leading letter in relation to it's normal position.")
  @JsonProperty(JSON_PROPERTY_CAPTION_VERTICAL_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getCaptionVerticalOffset() {
    return captionVerticalOffset;
  }


  @JsonProperty(JSON_PROPERTY_CAPTION_VERTICAL_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptionVerticalOffset(Float captionVerticalOffset) {
    this.captionVerticalOffset = captionVerticalOffset;
  }


  public MetadataLine endStyle(String endStyle) {
    
    this.endStyle = endStyle;
    return this;
  }

  /**
   * Selects the Line ending style at the end of the line. Possible values are: Square, Circle, Diamond, OpenArrow, ClosedArrow, None, Butt, ROpenArrow, RClosedArrow, Slash
   * @return endStyle
   **/
  @Nullable
  @Schema(name = "Selects the Line ending style at the end of the line. Possible values are: Square, Circle, Diamond, OpenArrow, ClosedArrow, None, Butt, ROpenArrow, RClosedArrow, Slash")
  @JsonProperty(JSON_PROPERTY_END_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEndStyle() {
    return endStyle;
  }


  @JsonProperty(JSON_PROPERTY_END_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndStyle(String endStyle) {
    this.endStyle = endStyle;
  }


  public MetadataLine leaderLineExtensionLength(Float leaderLineExtensionLength) {
    
    this.leaderLineExtensionLength = leaderLineExtensionLength;
    return this;
  }

  /**
   * A non-negative number that shall represent the length of leader line extensions that extend from the line proper 180 degrees from the leader lines. (0 &#x3D; no leader line extensions)
   * @return leaderLineExtensionLength
   **/
  @Nullable
  @Schema(name = "A non-negative number that shall represent the length of leader line extensions that extend from the line proper 180 degrees from the leader lines. (0 = no leader line extensions)")
  @JsonProperty(JSON_PROPERTY_LEADER_LINE_EXTENSION_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLeaderLineExtensionLength() {
    return leaderLineExtensionLength;
  }


  @JsonProperty(JSON_PROPERTY_LEADER_LINE_EXTENSION_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLeaderLineExtensionLength(Float leaderLineExtensionLength) {
    this.leaderLineExtensionLength = leaderLineExtensionLength;
  }


  public MetadataLine leaderLineLength(Float leaderLineLength) {
    
    this.leaderLineLength = leaderLineLength;
    return this;
  }

  /**
   * The length of leader lines that extend from each endpoint of the line perpendicular to the line itself. A positive value shall mean that the leader lines appear in the direction that is clockwise when traversing the line from its starting point to its ending point; a negative value shall indicate the opposite direction.(0 &#x3D; no leader lines)
   * @return leaderLineLength
   **/
  @Nullable
  @Schema(name = "The length of leader lines that extend from each endpoint of the line perpendicular to the line itself. A positive value shall mean that the leader lines appear in the direction that is clockwise when traversing the line from its starting point to its ending point; a negative value shall indicate the opposite direction.(0 = no leader lines)")
  @JsonProperty(JSON_PROPERTY_LEADER_LINE_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLeaderLineLength() {
    return leaderLineLength;
  }


  @JsonProperty(JSON_PROPERTY_LEADER_LINE_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLeaderLineLength(Float leaderLineLength) {
    this.leaderLineLength = leaderLineLength;
  }


  public MetadataLine leaderLineOffsetLength(Float leaderLineOffsetLength) {
    
    this.leaderLineOffsetLength = leaderLineOffsetLength;
    return this;
  }

  /**
   * A non-negative number that shall represent the length of the leader line offset, which is the amount of empty space between the endpoints of the annotation and the beginning of the leader lines.
   * @return leaderLineOffsetLength
   **/
  @Nullable
  @Schema(name = "A non-negative number that shall represent the length of the leader line offset, which is the amount of empty space between the endpoints of the annotation and the beginning of the leader lines.")
  @JsonProperty(JSON_PROPERTY_LEADER_LINE_OFFSET_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLeaderLineOffsetLength() {
    return leaderLineOffsetLength;
  }


  @JsonProperty(JSON_PROPERTY_LEADER_LINE_OFFSET_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLeaderLineOffsetLength(Float leaderLineOffsetLength) {
    this.leaderLineOffsetLength = leaderLineOffsetLength;
  }


  public MetadataLine showCaption(Boolean showCaption) {
    
    this.showCaption = showCaption;
    return this;
  }

  /**
   * When set to true the line shall display a textual caption.
   * @return showCaption
   **/
  @Nullable
  @Schema(name = "When set to true the line shall display a textual caption.")
  @JsonProperty(JSON_PROPERTY_SHOW_CAPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowCaption() {
    return showCaption;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_CAPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowCaption(Boolean showCaption) {
    this.showCaption = showCaption;
  }


  public MetadataLine startStyle(String startStyle) {
    
    this.startStyle = startStyle;
    return this;
  }

  /**
   * Selects the Line ending style at the start of the line.
   * @return startStyle
   **/
  @Nullable
  @Schema(name = "Selects the Line ending style at the start of the line.")
  @JsonProperty(JSON_PROPERTY_START_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStartStyle() {
    return startStyle;
  }


  @JsonProperty(JSON_PROPERTY_START_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartStyle(String startStyle) {
    this.startStyle = startStyle;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataLine metadataLine = (MetadataLine) o;
    return Objects.equals(this.captionHorizontalOffset, metadataLine.captionHorizontalOffset) &&
        Objects.equals(this.captionPositioning, metadataLine.captionPositioning) &&
        Objects.equals(this.captionVerticalOffset, metadataLine.captionVerticalOffset) &&
        Objects.equals(this.endStyle, metadataLine.endStyle) &&
        Objects.equals(this.leaderLineExtensionLength, metadataLine.leaderLineExtensionLength) &&
        Objects.equals(this.leaderLineLength, metadataLine.leaderLineLength) &&
        Objects.equals(this.leaderLineOffsetLength, metadataLine.leaderLineOffsetLength) &&
        Objects.equals(this.showCaption, metadataLine.showCaption) &&
        Objects.equals(this.startStyle, metadataLine.startStyle);
  }

  @Override
  public int hashCode() {
    return Objects.hash(captionHorizontalOffset, captionPositioning, captionVerticalOffset, endStyle, leaderLineExtensionLength, leaderLineLength, leaderLineOffsetLength, showCaption, startStyle);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataLine {\n");
    sb.append("    captionHorizontalOffset: ").append(toIndentedString(captionHorizontalOffset)).append("\n");
    sb.append("    captionPositioning: ").append(toIndentedString(captionPositioning)).append("\n");
    sb.append("    captionVerticalOffset: ").append(toIndentedString(captionVerticalOffset)).append("\n");
    sb.append("    endStyle: ").append(toIndentedString(endStyle)).append("\n");
    sb.append("    leaderLineExtensionLength: ").append(toIndentedString(leaderLineExtensionLength)).append("\n");
    sb.append("    leaderLineLength: ").append(toIndentedString(leaderLineLength)).append("\n");
    sb.append("    leaderLineOffsetLength: ").append(toIndentedString(leaderLineOffsetLength)).append("\n");
    sb.append("    showCaption: ").append(toIndentedString(showCaption)).append("\n");
    sb.append("    startStyle: ").append(toIndentedString(startStyle)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
